/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.concurrent;

import com.vmware.vise.util.concurrent.IdleThreadsAwareThreadPoolExecutor;
import com.vmware.vise.util.concurrent.LoggingRejectedExecutionHandler;
import com.vmware.vise.util.concurrent.QueuingCachedThreadPool;
import com.vmware.vise.util.concurrent.ThreadPoolManager;
import com.vmware.vise.util.concurrent.WorkerThreadFactory;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ThreadPoolFactory {
    private static final int FLEXIBLE_THREAD_POOL_COREPOOLSIZE = 0;
    private static final int CACHED_POOL_MAX_THREADS = 20;
    private static final long FLEXIBLE_THREAD_POOL_KEEPALIVETIME = 60L;
    private static final TimeUnit FLEXIBLE_THREAD_POOL_TIMEUNIT = TimeUnit.SECONDS;
    private static final long DYNAMIC_THREAD_POOL_KEEPALIVETIME = 2L;
    private static final TimeUnit DYNAMIC_THREAD_POOL_TIMEUNIT = TimeUnit.MINUTES;
    private static final long CORE_POOL_KEEPALIVETIME = 1L;
    private static final TimeUnit CORE_POOL_TIMEUNIT = TimeUnit.MILLISECONDS;
    private static final Log _logger = LogFactory.getLog(ThreadPoolFactory.class);
    private static final AtomicInteger CACHED_THREADPOOL_COUNTER = new AtomicInteger(0);

    public static ThreadPoolExecutor newThreadPool(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue) {
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(n, n2, l, timeUnit, blockingQueue);
        ThreadPoolManager.getInstance().register(threadPoolExecutor);
        return threadPoolExecutor;
    }

    public static ThreadPoolExecutor newThreadPool(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue, ThreadFactory threadFactory) {
        if (n > 0) {
            l = 1L;
            timeUnit = CORE_POOL_TIMEUNIT;
        }
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(n, n2, l, timeUnit, blockingQueue, threadFactory);
        ThreadPoolManager.getInstance().register(threadPoolExecutor);
        if (l > 0L) {
            threadPoolExecutor.allowCoreThreadTimeOut(true);
        }
        return threadPoolExecutor;
    }

    public static ThreadPoolExecutor newThreadPool(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue, ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(n, n2, l, timeUnit, blockingQueue, threadFactory, rejectedExecutionHandler);
        ThreadPoolManager.getInstance().register(threadPoolExecutor);
        return threadPoolExecutor;
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(ThreadFactory threadFactory) {
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(threadFactory);
        ThreadPoolManager.getInstance().register(scheduledExecutorService);
        return scheduledExecutorService;
    }

    public static ThreadPoolExecutor newDynamicThreadPool(int n, int n2, int n3, ThreadFactory threadFactory) {
        String string = threadFactory.toString();
        if (threadFactory instanceof WorkerThreadFactory) {
            string = ((WorkerThreadFactory)threadFactory).getPoolName();
        }
        LoggingRejectedExecutionHandler loggingRejectedExecutionHandler = new LoggingRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy(), string);
        LinkedBlockingQueue<Runnable> linkedBlockingQueue = new LinkedBlockingQueue<Runnable>(n3);
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(n, n2, 1L, CORE_POOL_TIMEUNIT, linkedBlockingQueue, threadFactory, loggingRejectedExecutionHandler);
        threadPoolExecutor.allowCoreThreadTimeOut(true);
        ThreadPoolManager.getInstance().register(threadPoolExecutor);
        return threadPoolExecutor;
    }

    public static ThreadPoolExecutor newIdleThreadsAwareThreadPool(String string, int n, int n2, int n3, ThreadFactory threadFactory, long l, TimeUnit timeUnit) {
        long l2 = 1L;
        TimeUnit timeUnit2 = CORE_POOL_TIMEUNIT;
        if (n == 0) {
            l2 = 2L;
            timeUnit2 = DYNAMIC_THREAD_POOL_TIMEUNIT;
        }
        IdleThreadsAwareThreadPoolExecutor idleThreadsAwareThreadPoolExecutor = new IdleThreadsAwareThreadPoolExecutor(string, n, n2, l2, timeUnit2, n3, threadFactory, l, timeUnit);
        if (l2 > 0L) {
            idleThreadsAwareThreadPoolExecutor.allowCoreThreadTimeOut(true);
        }
        ThreadPoolManager.getInstance().register(idleThreadsAwareThreadPoolExecutor);
        return idleThreadsAwareThreadPoolExecutor;
    }

    public static QueuingCachedThreadPool newQueingCachedThreadPool(int n, ThreadFactory threadFactory, long l, TimeUnit timeUnit, long l2, TimeUnit timeUnit2, QueuingCachedThreadPool.TaskExpirationPolicy taskExpirationPolicy) {
        QueuingCachedThreadPool queuingCachedThreadPool = new QueuingCachedThreadPool(n, threadFactory, l, timeUnit, l2, timeUnit2, taskExpirationPolicy, true);
        ThreadPoolManager.getInstance().register(queuingCachedThreadPool);
        return queuingCachedThreadPool;
    }

    public static ThreadPoolExecutor newFlexibleThreadPool(int n, ThreadFactory threadFactory) {
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(0, n, 60L, FLEXIBLE_THREAD_POOL_TIMEUNIT, new SynchronousQueue<Runnable>(), threadFactory);
        ThreadPoolManager.getInstance().register(threadPoolExecutor);
        return threadPoolExecutor;
    }

    public static ThreadPoolExecutor newFlexibleThreadPool(int n, int n2, ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        long l = 1L;
        TimeUnit timeUnit = CORE_POOL_TIMEUNIT;
        if (n == 0) {
            l = 2L;
            timeUnit = DYNAMIC_THREAD_POOL_TIMEUNIT;
        }
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(n, n2, l, timeUnit, new SynchronousQueue<Runnable>(), threadFactory, rejectedExecutionHandler);
        ThreadPoolManager.getInstance().register(threadPoolExecutor);
        return threadPoolExecutor;
    }

    public static ThreadPoolExecutor newFixedThreadPool(int n) {
        ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)Executors.newFixedThreadPool(n);
        threadPoolExecutor.setKeepAliveTime(1L, CORE_POOL_TIMEUNIT);
        threadPoolExecutor.allowCoreThreadTimeOut(true);
        ThreadPoolManager.getInstance().register(threadPoolExecutor);
        return threadPoolExecutor;
    }

    public static ThreadPoolExecutor newFixedThreadPool(int n, ThreadFactory threadFactory) {
        ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)Executors.newFixedThreadPool(n, threadFactory);
        threadPoolExecutor.setKeepAliveTime(1L, CORE_POOL_TIMEUNIT);
        threadPoolExecutor.allowCoreThreadTimeOut(true);
        ThreadPoolManager.getInstance().register(threadPoolExecutor);
        return threadPoolExecutor;
    }

    @Deprecated
    public static ThreadPoolExecutor newCachedThreadPool() {
        int n = CACHED_THREADPOOL_COUNTER.incrementAndGet();
        String string = "cachedThreadPool" + n;
        try {
            throw new UnsupportedOperationException();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            _logger.error((Object)("Do not use unbounded threadpools. Creating bounded pool " + string), (Throwable)unsupportedOperationException);
            WorkerThreadFactory workerThreadFactory = new WorkerThreadFactory(string);
            LoggingRejectedExecutionHandler loggingRejectedExecutionHandler = new LoggingRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy(), string);
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(0, 20, 1L, CORE_POOL_TIMEUNIT, new SynchronousQueue<Runnable>(), workerThreadFactory, loggingRejectedExecutionHandler);
            ThreadPoolManager.getInstance().register(threadPoolExecutor);
            return threadPoolExecutor;
        }
    }

    @Deprecated
    public static ThreadPoolExecutor newCachedThreadPool(ThreadFactory threadFactory) {
        String string = null;
        if (threadFactory instanceof WorkerThreadFactory) {
            string = ((WorkerThreadFactory)threadFactory).getPoolName();
        } else {
            int n = CACHED_THREADPOOL_COUNTER.incrementAndGet();
            string = "cachedThreadPool" + n;
        }
        try {
            throw new UnsupportedOperationException();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            _logger.error((Object)("Do not use unbounded threadpools. Creating bounded pool " + string), (Throwable)unsupportedOperationException);
            LoggingRejectedExecutionHandler loggingRejectedExecutionHandler = new LoggingRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy(), string);
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(0, 20, 1L, CORE_POOL_TIMEUNIT, new SynchronousQueue<Runnable>(), threadFactory, loggingRejectedExecutionHandler);
            ThreadPoolManager.getInstance().register(threadPoolExecutor);
            return threadPoolExecutor;
        }
    }
}

