/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.concurrent;

import com.vmware.vise.util.concurrent.ExecutorUtil;
import com.vmware.vise.util.concurrent.ThreadPoolFactory;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ThreadPoolManager {
    private static Set<ExecutorService> servicesToShutdown = new HashSet<ExecutorService>();
    private static boolean isShutdown = false;
    private static ThreadPoolManager _instance = new ThreadPoolManager();
    private static final Log _logger = LogFactory.getLog(ThreadPoolFactory.class);

    private ThreadPoolManager() {
    }

    public static ThreadPoolManager getInstance() {
        return _instance;
    }

    public void register(ExecutorService executorService) {
        if (executorService == null) {
            throw new IllegalArgumentException("Invalid thread pool to register.");
        }
        this.shutdownOnExit(executorService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(ThreadPoolExecutor threadPoolExecutor, boolean bl) {
        if (threadPoolExecutor == null) {
            throw new IllegalArgumentException("Invalid thread pool to unregister.");
        }
        Set<ExecutorService> set = servicesToShutdown;
        synchronized (set) {
            if (!servicesToShutdown.contains(threadPoolExecutor)) {
                return;
            }
            servicesToShutdown.remove(threadPoolExecutor);
            if (bl) {
                threadPoolExecutor.shutdownNow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        Set<ExecutorService> set = servicesToShutdown;
        synchronized (set) {
            if (isShutdown) {
                _logger.warn((Object)"Shutdown called more than once.");
                return;
            }
            isShutdown = true;
            for (ExecutorService executorService : servicesToShutdown) {
                assert (executorService != null);
                _logger.info((Object)("Shutting down thread pool " + ThreadPoolManager.getThreadPoolName(executorService)));
                executorService.shutdownNow();
            }
            servicesToShutdown.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownOnExit(ExecutorService executorService) {
        Set<ExecutorService> set = servicesToShutdown;
        synchronized (set) {
            if (isShutdown) {
                _logger.warn((Object)"Thread pool instantiated after shutdown sequence. Setup to timeout after 10 seconds.");
                executorService.shutdownNow();
                return;
            }
            servicesToShutdown.add(executorService);
        }
    }

    private static String getThreadPoolName(ExecutorService executorService) {
        if (executorService instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)executorService;
            Thread thread = threadPoolExecutor.getThreadFactory().newThread(ExecutorUtil.EMPTY_RUNNABLE);
            return thread.getName();
        }
        if (executorService == null) {
            return null;
        }
        return executorService.toString();
    }
}

