/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.concurrent;

import com.vmware.vise.util.concurrent.WorkerThreadFactory;
import com.vmware.vise.util.session.SessionUtil;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ThreadPoolProfiler {
    private static final Log _logger = LogFactory.getLog(ThreadPoolProfiler.class);
    private static final String USAGE_FORMAT = "Thread pool: %1$s, Core: %2$d, Max: %3$d, Running: %4$d, Active: %5$d, Queued: %6$d  (sessionId: %7$s, clientId: %8$s)";
    private final ThreadPoolExecutor _threadPool;

    public ThreadPoolProfiler(ThreadPoolExecutor threadPoolExecutor) {
        if (threadPoolExecutor == null) {
            throw new IllegalArgumentException("Thread pool cannot be null.");
        }
        this._threadPool = threadPoolExecutor;
    }

    public void profileThreadPoolIfBusy() {
        ThreadPoolProfiler.profileThreadPoolIfBusy(this._threadPool);
    }

    public static void profileThreadPoolIfBusy(ThreadPoolExecutor threadPoolExecutor) {
        if (!_logger.isInfoEnabled() || threadPoolExecutor == null) {
            return;
        }
        try {
            int n = threadPoolExecutor.getQueue().size();
            if (n > 0) {
                ThreadPoolProfiler.logThreadPoolUsage(threadPoolExecutor, threadPoolExecutor.getCorePoolSize(), threadPoolExecutor.getMaximumPoolSize(), threadPoolExecutor.getPoolSize(), threadPoolExecutor.getActiveCount(), n);
            }
        }
        catch (Exception exception) {
            _logger.error((Object)"Error while profiling thread pool", (Throwable)exception);
        }
    }

    private static void logThreadPoolUsage(ThreadPoolExecutor threadPoolExecutor, int n, int n2, int n3, int n4, int n5) {
        ThreadFactory threadFactory = threadPoolExecutor.getThreadFactory();
        String string = "unknown";
        if (threadFactory instanceof WorkerThreadFactory) {
            string = ((WorkerThreadFactory)threadFactory).getPoolName();
        }
        String string2 = SessionUtil.getHashedSessionId();
        String string3 = SessionUtil.getHashedClientId();
        String string4 = String.format(USAGE_FORMAT, string, n, n2, n3, n4, n5, string2, string3);
        _logger.info((Object)string4);
    }
}

