/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.concurrent;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class WorkerThread
extends Thread {
    public static final String DEFAULT_NAME = "WorkerThread";
    private static final AtomicInteger created = new AtomicInteger();
    private static final Log _logger = LogFactory.getLog(WorkerThread.class);

    public WorkerThread(Runnable runnable) {
        this(runnable, DEFAULT_NAME);
    }

    public WorkerThread(Runnable runnable, String string) {
        super(runnable, string + "-" + created.incrementAndGet());
    }

    static {
        WorkerThread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable throwable) {
                _logger.error((Object)(thread.getName() + " terminated with exception: "), throwable);
            }
        });
    }
}

