/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.concurrent.client;

import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.concurrent.BlockingCounter;
import com.vmware.vise.util.concurrent.BlockingUtil;
import com.vmware.vise.util.concurrent.TaskContainer;
import com.vmware.vise.util.concurrent.TaskContainerImpl;
import com.vmware.vise.util.concurrent.client.ClientAuthenticator;
import com.vmware.vise.util.concurrent.client.ClientMonitor;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ClientMonitorImpl<T>
implements ClientMonitor<T> {
    private static final Log _logger = LogFactory.getLog(ClientMonitorImpl.class);
    private static final TimeUnit LOGOUT_WAIT_TIME_UNIT = TimeUnit.MINUTES;
    private static final long LOGOUT_WAIT_TIME = 2L;
    private static final TimeUnit LOGIN_WAIT_TIME_UNIT = TimeUnit.MINUTES;
    private static final long LOGIN_WAIT_TIME = 2L;
    private volatile T _client;
    private final ClientAuthenticator<T> _clientAuthenticator;
    private final BlockingCounter _activeClients = new BlockingCounter();
    private final TaskContainer<Void> _authenticationTask = new TaskContainerImpl<Void>();

    public ClientMonitorImpl(T t, ClientAuthenticator<T> clientAuthenticator) throws Exception {
        ValidationUtil.paramsNotNull(t, clientAuthenticator);
        this._client = t;
        this._clientAuthenticator = clientAuthenticator;
    }

    @Override
    public void authenticate() throws Exception {
        Future<Void> future;
        if (this.isShutdown()) {
            throw new IllegalStateException("Shutdown already initiated.");
        }
        Callable<Void> callable = this.createCallableLoginTask(this._client, this._clientAuthenticator);
        FutureTask<Void> futureTask = new FutureTask<Void>(callable);
        if (futureTask == (future = this._authenticationTask.setRunningTask(futureTask))) {
            futureTask.run();
            this._authenticationTask.setCompletedTask(futureTask);
            futureTask.get();
        } else {
            ClientMonitorImpl.waitForTask(future);
        }
    }

    @Override
    public T checkoutClient() throws Exception {
        boolean bl = this._activeClients.increment();
        if (!bl) {
            throw new IllegalStateException("The monitor has been shutdown.");
        }
        T t = null;
        try {
            this.waitForLogin();
            t = this._client;
        }
        finally {
            if (t == null) {
                this._activeClients.decrement();
            }
        }
        return t;
    }

    @Override
    public void releaseClient(T t) {
        if (t == null) {
            return;
        }
        if (t != this._client) {
            throw new IllegalArgumentException("Attempting to release client not held by this monitor.");
        }
        boolean bl = this._activeClients.decrement();
        if (!bl) {
            throw new IllegalStateException("Unbalanced call to release client.");
        }
    }

    @Override
    public void shutdown() throws Exception {
        try {
            boolean bl = this._activeClients.blockUntilEmpty(2L, LOGOUT_WAIT_TIME_UNIT);
            if (!bl) {
                _logger.warn((Object)"Timed out before all clients released.");
            }
        }
        catch (Exception exception) {
            _logger.warn((Object)"Error waiting for clients to be released. Shutdown proceeding anyway", (Throwable)exception);
        }
        try {
            this.waitForLogin();
        }
        catch (Exception exception) {
            _logger.warn((Object)"Authentication error during shutdown. Proceeding with shutdown anyway", (Throwable)exception);
        }
        this._clientAuthenticator.logout(this._client);
        this._client = null;
    }

    private void waitForLogin() throws Exception {
        Future<Void> future = this._authenticationTask.getLatestTask();
        if (future == null) {
            _logger.info((Object)"Monitor never authenticated.");
            return;
        }
        ClientMonitorImpl.waitForTask(future);
    }

    private static void waitForTask(Future<Void> future) throws Exception {
        try {
            BlockingUtil.get(future, 2L, LOGIN_WAIT_TIME_UNIT);
        }
        catch (TimeoutException timeoutException) {
            _logger.error((Object)"Timeout while logging into client", (Throwable)timeoutException);
            throw timeoutException;
        }
        catch (ExecutionException executionException) {
            _logger.error((Object)"Exception while logging in: ", (Throwable)executionException);
            Throwable throwable = executionException.getCause();
            if (throwable instanceof Exception) {
                Exception exception = (Exception)throwable;
                throw exception;
            }
            throw executionException;
        }
    }

    private Callable<Void> createCallableLoginTask(final T t, final ClientAuthenticator<T> clientAuthenticator) {
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                clientAuthenticator.authenticate(t);
                return null;
            }
        };
        return callable;
    }

    private boolean isShutdown() {
        boolean bl = this._activeClients.isShutdown();
        return bl;
    }
}

