/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.core.dump;

import com.vmware.vise.util.FileUtil;
import com.vmware.vise.util.core.dump.CoreDumpLocator;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CoreDumpRotation
implements Runnable {
    private static final int MAX_DUMPS = 3;
    private static final Log _logger = LogFactory.getLog(CoreDumpRotation.class);
    private String _dumpDirectory;
    private CoreDumpLocator _coreDumpLocator;

    public CoreDumpRotation(CoreDumpLocator coreDumpLocator) {
        this._coreDumpLocator = coreDumpLocator;
    }

    @Override
    public void run() {
        this.compressAndRotate();
    }

    private void compressAndRotate() {
        File[] fileArray;
        this.setDumpDirectory();
        _logger.info((Object)("Performing core dump rotation in " + this._dumpDirectory));
        File file = new File(this._dumpDirectory);
        if (!file.isDirectory()) {
            return;
        }
        for (File file2 : fileArray = file.listFiles()) {
            if (!file2.isDirectory() || file2.list().length != 0) continue;
            file2.delete();
        }
        fileArray = file.listFiles();
        fileArray = this.sortByOldest(fileArray);
        for (int i = 0; i < fileArray.length - 3; ++i) {
            if (fileArray[i].isDirectory()) {
                FileUtil.deleteDir(fileArray[i]);
                continue;
            }
            fileArray[i].delete();
        }
        fileArray = file.listFiles();
        for (File file2 : fileArray = this.sortByOldest(fileArray)) {
            if (!file2.isDirectory()) continue;
            this.compress(file2);
            FileUtil.deleteDir(file2);
        }
    }

    private void setDumpDirectory() {
        this._dumpDirectory = this._coreDumpLocator.getCoreDumpDirectory();
    }

    private File[] sortByOldest(File[] fileArray) {
        Arrays.sort(fileArray, new Comparator<File>(){

            @Override
            public int compare(File file, File file2) {
                long l;
                if (file == null || file2 == null) {
                    return 0;
                }
                long l2 = file.lastModified();
                if (l2 > (l = file2.lastModified())) {
                    return 1;
                }
                if (l2 < l) {
                    return -1;
                }
                return 0;
            }
        });
        return fileArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compress(File file) {
        FileOutputStream fileOutputStream = null;
        ZipOutputStream zipOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file.getPath() + ".zip");
            zipOutputStream = new ZipOutputStream(new BufferedOutputStream(fileOutputStream));
            int n = 2048;
            byte[] byArray = new byte[n];
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                try (BufferedInputStream bufferedInputStream = null;){
                    int n2;
                    FileInputStream fileInputStream = new FileInputStream(stringArray[i]);
                    bufferedInputStream = new BufferedInputStream(fileInputStream, n);
                    ZipEntry zipEntry = new ZipEntry(stringArray[i]);
                    zipOutputStream.putNextEntry(zipEntry);
                    while ((n2 = bufferedInputStream.read(byArray, 0, n)) != -1) {
                        zipOutputStream.write(byArray, 0, n2);
                    }
                    continue;
                }
            }
            zipOutputStream.close();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            _logger.error((Object)("Exception while compressing " + file), (Throwable)exception);
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                if (zipOutputStream != null) {
                    zipOutputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

