/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.feature.impl;

import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.feature.FeatureState;
import com.vmware.vise.util.feature.FeatureStateProvider;
import com.vmware.vise.util.feature.impl.AbstractFeatureStateService;
import com.vmware.vise.util.feature.names.Feature;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import org.apache.commons.lang.Validate;

public class FeatureStateServiceImpl
extends AbstractFeatureStateService {
    private static final String SETTING_LOCAL_DEVELOPMENT_MODE = "local.development";
    private static final String SETTING_FEATURE_STATE_SWITCH_MODE = "featureStateSwitch.mode";
    private final ConfigurationService _configService;
    private final FeatureStateProvider _auxiliaryProvider;
    private final FeatureStateProvider _devEnvProvider;
    private final FeatureStateProvider _productionProvider;
    private final Mode _operationMode;
    private volatile Map<Feature, FeatureState> _featureStateMap;

    public FeatureStateServiceImpl(ConfigurationService configurationService, FeatureStateProvider featureStateProvider, FeatureStateProvider featureStateProvider2, FeatureStateProvider featureStateProvider3) {
        Validate.notNull((Object)configurationService);
        Validate.notNull((Object)featureStateProvider);
        Validate.notNull((Object)featureStateProvider2);
        Validate.notNull((Object)featureStateProvider3);
        this._configService = configurationService;
        this._auxiliaryProvider = featureStateProvider;
        this._operationMode = this.getOperationMode();
        this._devEnvProvider = featureStateProvider2;
        this._productionProvider = featureStateProvider3;
        this._featureStateMap = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected FeatureState getState(Feature feature) {
        Object object;
        Validate.notNull((Object)((Object)feature), (String)"The feature shouldn't be null");
        Map<Feature, FeatureState> map = this._featureStateMap;
        if (map == null) {
            object = this;
            synchronized (object) {
                map = this._featureStateMap;
                if (map == null) {
                    this._featureStateMap = map = this.buildFeatureStateMap();
                }
            }
        }
        return (object = this._featureStateMap.get((Object)feature)) == null ? FeatureState.DISABLED : object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Feature, FeatureState> getAllFeatures() {
        Map<Feature, FeatureState> map = this._featureStateMap;
        if (map == null) {
            FeatureStateServiceImpl featureStateServiceImpl = this;
            synchronized (featureStateServiceImpl) {
                map = this._featureStateMap;
                if (map == null) {
                    this._featureStateMap = map = this.buildFeatureStateMap();
                }
            }
        }
        return Collections.unmodifiableMap(this._featureStateMap);
    }

    private Map<Feature, FeatureState> buildFeatureStateMap() {
        Map<Feature, FeatureState> map;
        EnumMap<Feature, FeatureState> enumMap = new EnumMap<Feature, FeatureState>(Feature.class);
        boolean bl = Mode.production.equals((Object)this._operationMode) || Mode.pipeline.equals((Object)this._operationMode);
        boolean bl2 = Mode.development.equals((Object)this._operationMode) || Mode.pipeline.equals((Object)this._operationMode);
        boolean bl3 = Mode.development.equals((Object)this._operationMode);
        if (bl) {
            map = this._productionProvider.getAllFeatures();
            for (Map.Entry<Feature, FeatureState> entry : map.entrySet()) {
                enumMap.put(entry.getKey(), entry.getValue());
            }
        }
        if (bl2) {
            map = this._auxiliaryProvider.getAllFeatures();
            for (Map.Entry<Feature, FeatureState> entry : map.entrySet()) {
                enumMap.put(entry.getKey(), entry.getValue());
            }
        }
        if (bl3) {
            map = this._devEnvProvider.getAllFeatures();
            for (Map.Entry<Feature, FeatureState> entry : map.entrySet()) {
                enumMap.put(entry.getKey(), entry.getValue());
            }
        }
        return enumMap;
    }

    private boolean isInLocalDevelopmentMode() {
        String string = this._configService.getProperty(SETTING_LOCAL_DEVELOPMENT_MODE);
        return StringUtil.parseBoolean(string, false);
    }

    private Mode getOperationMode() {
        String string = this._configService.getProperty(SETTING_FEATURE_STATE_SWITCH_MODE);
        if (string == null) {
            if (this.isInLocalDevelopmentMode()) {
                return Mode.development;
            }
            return Mode.production;
        }
        try {
            return Mode.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Mode.production;
        }
    }

    private static enum Mode {
        development,
        production,
        pipeline;

    }
}

