/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.feature.impl;

import com.vmware.vise.util.feature.FeatureState;
import com.vmware.vise.util.feature.FeatureStateProvider;
import com.vmware.vise.util.feature.names.Feature;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.EnumMap;
import java.util.Map;

public class StaticUtilityFeatureStateProvider
implements FeatureStateProvider {
    private Map<Feature, FeatureState> buildStatesMap() {
        Feature[] featureArray;
        EnumMap<Feature, FeatureState> enumMap = new EnumMap<Feature, FeatureState>(Feature.class);
        com.vmware.vim.featurestateswitch.FeatureState.init();
        for (Feature feature : featureArray = Feature.values()) {
            String string = feature.value();
            Method method = StaticUtilityFeatureStateProvider.getFeatureStateMethod(string);
            if (method == null) continue;
            FeatureState featureState = FeatureState.DISABLED;
            try {
                Object object = this.getFeatureStateMethodInvocationResult(method);
                if (Boolean.TRUE.equals(object)) {
                    featureState = FeatureState.ENABLED;
                }
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
            enumMap.put(feature, featureState);
        }
        return enumMap;
    }

    private Object getFeatureStateMethodInvocationResult(Method method) throws IllegalAccessException, InvocationTargetException {
        return method.invoke(null, new Object[0]);
    }

    private static Method getFeatureStateMethod(String string) {
        try {
            String string2 = "get" + string;
            return com.vmware.vim.featurestateswitch.FeatureState.class.getMethod(string2, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    @Override
    public Map<Feature, FeatureState> getAllFeatures() {
        return this.buildStatesMap();
    }
}

