/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.http;

import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.http.HttpUtil;
import com.vmware.vise.util.internal.Config;
import com.vmware.vise.util.io.StreamUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ConnectionManager {
    private static final String DEFAULT_CHARACTER_ENCODING = "UTF-8";
    private static final Log logger = LogFactory.getLog(ConnectionManager.class);
    private int statusCode = -1;
    private URLConnection connection;
    private String cookie;
    private final Map<String, String[]> parameters = new HashMap<String, String[]>();
    private final Map<String, String> headers = new HashMap<String, String>();
    private SSLSocketFactory sslSocketFactory;
    private HostnameVerifier hostnameVerifier;
    private long contentLength = -1L;
    private volatile int _connectTimeout;
    private volatile int _readTimeout;

    ConnectionManager() {
        this(Config.SIMPLE_HTTP_CLIENT_CONNECT_TIMEOUT, Config.SIMPLE_HTTP_CLIENT_READ_TIMEOUT);
    }

    ConnectionManager(int n, int n2) {
        this._connectTimeout = n < 0 ? 0 : n;
        this._readTimeout = n2 < 0 ? 0 : n2;
    }

    protected void setReadTimeout(int n) {
        this._readTimeout = n;
    }

    public int getReadTimeout() {
        return this._readTimeout;
    }

    protected void setConnectTimeout(int n) {
        this._connectTimeout = n;
    }

    public int getConnectTimeout() {
        return this._connectTimeout;
    }

    public String getCookie() {
        return this.cookie;
    }

    public void init(String string, Proxy proxy) throws IOException {
        this.init(string, proxy, null);
    }

    public void init(String string, Proxy proxy, String string2) throws IOException {
        this.statusCode = -1;
        URL uRL = new URL(string);
        this.connection = proxy == null ? uRL.openConnection() : uRL.openConnection(proxy);
        this.connection.setConnectTimeout(this._connectTimeout);
        this.connection.setReadTimeout(this._readTimeout);
        if (this.connection instanceof HttpsURLConnection) {
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)this.connection;
            httpsURLConnection.setSSLSocketFactory(this.sslSocketFactory);
            httpsURLConnection.setHostnameVerifier(this.hostnameVerifier);
            if (string2 != null) {
                httpsURLConnection.setRequestMethod(string2);
            }
        }
        if (this.cookie != null) {
            this.connection.addRequestProperty("Cookie", this.cookie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int connect() throws IOException {
        Object object;
        if (!this.headers.isEmpty()) {
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                this.connection.addRequestProperty(entry.getKey(), entry.getValue());
            }
            this.headers.clear();
        }
        if (!this.parameters.isEmpty()) {
            OutputStreamWriter outputStreamWriter;
            this.connection.setDoOutput(true);
            object = new StringBuffer();
            int n = 0;
            for (Map.Entry<String, String[]> object22 : this.parameters.entrySet()) {
                String[] stringArray = object22.getValue();
                if (n > 0) {
                    ((StringBuffer)object).append("&");
                }
                for (String string : stringArray) {
                    if (string == null) continue;
                    ((StringBuffer)object).append(URLEncoder.encode(object22.getKey(), DEFAULT_CHARACTER_ENCODING));
                    ((StringBuffer)object).append("=");
                    ((StringBuffer)object).append(URLEncoder.encode(string, DEFAULT_CHARACTER_ENCODING));
                }
                ++n;
            }
            Object object3 = null;
            Closeable closeable = null;
            try {
                object3 = this.connection.getOutputStream();
                outputStreamWriter = new OutputStreamWriter((OutputStream)object3);
                outputStreamWriter.write(((StringBuffer)object).toString());
                outputStreamWriter.flush();
                this.parameters.clear();
            }
            catch (Throwable throwable) {
                StreamUtil.close(closeable);
                StreamUtil.close((Closeable)object3);
                throw throwable;
            }
            StreamUtil.close(outputStreamWriter);
            StreamUtil.close((Closeable)object3);
        }
        this.statusCode = ((HttpURLConnection)this.connection).getResponseCode();
        this.contentLength = ((HttpURLConnection)this.connection).getContentLengthLong();
        object = this.connection.getHeaderField("Set-Cookie");
        if (object != null) {
            this.cookie = object;
        }
        return this.statusCode;
    }

    public String getResponseBodyAsString() {
        byte[] byArray = this.getResponseBodyAsBytes();
        if (byArray == null) {
            return null;
        }
        String string = HttpUtil.getContentCharSet(this.connection.getContentType());
        if (StringUtil.isNullOrEmpty(string)) {
            string = DEFAULT_CHARACTER_ENCODING;
        }
        try {
            return new String(byArray, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(byArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getResponseBodyAsBytes() {
        ByteArrayOutputStream byteArrayOutputStream = this.getResponse();
        try {
            byte[] byArray;
            byte[] byArray2 = byArray = byteArrayOutputStream.toByteArray();
            return byArray2;
        }
        finally {
            StreamUtil.close(byteArrayOutputStream);
        }
    }

    public InputStream getResponseBodyAsStream() throws IOException {
        return this.connection.getInputStream();
    }

    @CheckForNull
    public InputStream getErrorStream() {
        if (this.connection instanceof HttpURLConnection) {
            return ((HttpURLConnection)this.connection).getErrorStream();
        }
        return null;
    }

    public void close() {
        if (this.connection instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)this.connection;
            try {
                httpURLConnection.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void addParameter(String string, String string2) {
        String[] stringArray = this.parameters.get(string);
        if (stringArray != null) {
            String[] stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray2[stringArray.length] = string2;
            this.parameters.put(string, stringArray2);
        } else {
            this.parameters.put(string, new String[]{string2});
        }
    }

    public void addParameters(Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.addParameter(entry.getKey(), entry.getValue());
        }
    }

    public void addHeader(String string, String string2) {
        this.headers.put(string, string2);
    }

    public void addHeaders(Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.addHeader(entry.getKey(), entry.getValue());
        }
    }

    public SSLSocketFactory getSSLSocketFactory() {
        return this.sslSocketFactory;
    }

    public void setSSLSocketFactory(SSLSocketFactory sSLSocketFactory) {
        this.sslSocketFactory = sSLSocketFactory;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteArrayOutputStream getResponse() {
        ByteArrayOutputStream byteArrayOutputStream;
        block7: {
            byteArrayOutputStream = new ByteArrayOutputStream();
            InputStream inputStream = null;
            BufferedInputStream bufferedInputStream = null;
            try {
                inputStream = this.connection.getInputStream();
                bufferedInputStream = new BufferedInputStream(inputStream);
                byte[] byArray = new byte[1024];
                int n = 0;
                while ((n = bufferedInputStream.read(byArray)) > 0) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                byteArrayOutputStream.flush();
                StreamUtil.close(bufferedInputStream);
            }
            catch (Exception exception) {
                if (logger.isErrorEnabled()) {
                    logger.error((Object)("Error reading from the stream: " + exception.getMessage()));
                }
                break block7;
            }
            finally {
                StreamUtil.close(bufferedInputStream);
                StreamUtil.close(inputStream);
            }
            StreamUtil.close(inputStream);
        }
        return byteArrayOutputStream;
    }
}

