/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.http;

import com.vmware.vise.util.internal.Config;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.NoRouteToHostException;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnegative;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.protocol.HttpContext;
import org.springframework.util.Assert;

@ThreadSafe
public class CustomizedDefaultHttpRequestRetryHandler
implements HttpRequestRetryHandler {
    private static final Log _logger = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final DefaultHttpRequestRetryHandler _defaultHandler;
    private final long _maxRetries;
    private final AtomicLong _retryCounter = new AtomicLong(0L);

    public CustomizedDefaultHttpRequestRetryHandler(@Nonnegative int n) {
        Assert.isTrue((n >= 0 ? 1 : 0) != 0);
        this._defaultHandler = new DefaultHttpRequestRetryHandler(n, false);
        this._maxRetries = n;
    }

    public boolean retryRequest(IOException iOException, int n, HttpContext httpContext) {
        boolean bl = iOException instanceof NoRouteToHostException ? false : this._defaultHandler.retryRequest(iOException, n, httpContext);
        if (!bl) {
            _logger.debug((Object)"Will not retry for exception ", (Throwable)iOException);
            return false;
        }
        boolean bl2 = _logger.isDebugEnabled();
        boolean bl3 = false;
        if (!bl2) {
            long l = this._retryCounter.getAndIncrement();
            boolean bl4 = bl3 = l % (long)Config.CUSTOMIZED_HTTP_REQ_RETRY_LOG_AT_WARN_LEVEL_INTERVAL == 0L;
        }
        if (bl2 || bl3) {
            String string = "Will do retry #" + n + " out of " + this._maxRetries + " for exception ";
            if (bl2) {
                _logger.debug((Object)string, (Throwable)iOException);
            } else {
                _logger.warn((Object)(string + iOException));
            }
        }
        return bl;
    }
}

