/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.http;

import com.vmware.vise.util.EnumerationOverIterator;
import com.vmware.vise.util.StringUtil;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;

public class StubHttpSession
implements HttpSession {
    private final String _id;
    private final long _creationTime;
    private final long _lastAccessedTime;
    private volatile int _maxInactiveInterval;
    private final WeakReference<ServletContext> _servletContextRef;
    private final ConcurrentMap<String, Object> _attributes;

    public StubHttpSession(HttpSession httpSession) {
        int n;
        long l;
        long l2;
        this._id = httpSession.getId();
        this._servletContextRef = new WeakReference<ServletContext>(httpSession.getServletContext());
        this._attributes = new ConcurrentHashMap<String, Object>();
        Enumeration enumeration = httpSession.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object object = httpSession.getAttribute(string);
            if (object == null) continue;
            this._attributes.put(string, object);
        }
        try {
            l2 = httpSession.getCreationTime();
        }
        catch (Exception exception) {
            l2 = 0L;
        }
        this._creationTime = l2;
        try {
            l = httpSession.getLastAccessedTime();
        }
        catch (Exception exception) {
            l = 0L;
        }
        this._lastAccessedTime = l;
        try {
            n = httpSession.getMaxInactiveInterval();
        }
        catch (Exception exception) {
            n = 0;
        }
        this._maxInactiveInterval = n;
    }

    public String getId() {
        return this._id;
    }

    public ServletContext getServletContext() {
        return (ServletContext)this._servletContextRef.get();
    }

    public long getCreationTime() {
        return this._creationTime;
    }

    public long getLastAccessedTime() {
        return this._lastAccessedTime;
    }

    public void setMaxInactiveInterval(int n) {
        this._maxInactiveInterval = n;
    }

    public int getMaxInactiveInterval() {
        return this._maxInactiveInterval;
    }

    public Enumeration<String> getAttributeNames() {
        Iterator iterator = this._attributes.keySet().iterator();
        return new EnumerationOverIterator<String>(iterator);
    }

    public Object getAttribute(String string) {
        Object v = this._attributes.get(string);
        return v;
    }

    public void setAttribute(String string, Object object) {
        this._attributes.putIfAbsent(string, object);
    }

    public void removeAttribute(String string) {
        this._attributes.remove(string);
    }

    public void invalidate() {
    }

    public boolean isNew() {
        return false;
    }

    public Object getValue(String string) {
        return this.getAttribute(string);
    }

    public void putValue(String string, Object object) {
        this.setAttribute(string, object);
    }

    public void removeValue(String string) {
        this.removeAttribute(string);
    }

    public String[] getValueNames() {
        Enumeration<String> enumeration = this.getAttributeNames();
        if (!enumeration.hasMoreElements()) {
            return StringUtil.EMPTY_STRING_ARR;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        return arrayList.toArray(StringUtil.EMPTY_STRING_ARR);
    }

    public HttpSessionContext getSessionContext() {
        throw new UnsupportedOperationException();
    }
}

