/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.i18n;

import com.vmware.vise.util.security.CertificateUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.UrlResource;
import org.springframework.util.ResourceUtils;

public class UrlResourceWithSslSupport
extends UrlResource {
    private static final Log _logger = LogFactory.getLog(UrlResourceWithSslSupport.class);
    private final String[] _sslThumbprints;

    public UrlResourceWithSslSupport(URL uRL, String[] stringArray) {
        super(uRL);
        this._sslThumbprints = stringArray;
    }

    public UrlResourceWithSslSupport(URI uRI, String[] stringArray) throws MalformedURLException {
        super(uRI);
        this._sslThumbprints = stringArray;
    }

    public UrlResourceWithSslSupport(String string, String[] stringArray) throws MalformedURLException {
        super(string);
        this._sslThumbprints = stringArray;
    }

    public boolean exists() {
        try {
            HttpURLConnection httpURLConnection;
            URL uRL = this.getURL();
            if (ResourceUtils.isFileURL((URL)uRL)) {
                return this.getFile().exists();
            }
            URLConnection uRLConnection = uRL.openConnection();
            ResourceUtils.useCachesIfNecessary((URLConnection)uRLConnection);
            HttpURLConnection httpURLConnection2 = httpURLConnection = uRLConnection instanceof HttpURLConnection ? (HttpURLConnection)uRLConnection : null;
            if (httpURLConnection != null) {
                this.processForSSL(httpURLConnection);
                httpURLConnection.setRequestMethod("HEAD");
                int n = httpURLConnection.getResponseCode();
                if (n == 200) {
                    return true;
                }
                if (n == 404) {
                    return false;
                }
            }
            if (uRLConnection.getContentLength() >= 0) {
                return true;
            }
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
                return false;
            }
            InputStream inputStream = this.getInputStream();
            inputStream.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public InputStream getInputStream() throws IOException {
        URLConnection uRLConnection = super.getURL().openConnection();
        ResourceUtils.useCachesIfNecessary((URLConnection)uRLConnection);
        this.processForSSL(uRLConnection);
        try {
            return uRLConnection.getInputStream();
        }
        catch (IOException iOException) {
            if (uRLConnection instanceof HttpURLConnection) {
                ((HttpURLConnection)uRLConnection).disconnect();
            }
            throw iOException;
        }
    }

    private void processForSSL(URLConnection uRLConnection) {
        if (uRLConnection instanceof HttpsURLConnection) {
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRLConnection;
            try {
                httpsURLConnection.setSSLSocketFactory(this.getSSLSocketFactory());
                httpsURLConnection.setHostnameVerifier(this.getHostNameVerifier());
            }
            catch (Exception exception) {
                _logger.error((Object)"Could not set the SSLSocketFactory and HostNameVerifier for the httpsConnection", (Throwable)exception);
            }
        }
    }

    private SSLSocketFactory getSSLSocketFactory() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        TrustManager[] trustManagerArray = new TrustManager[]{new ThumbprintTrustingManager(this._sslThumbprints)};
        sSLContext.init(null, trustManagerArray, new SecureRandom());
        return sSLContext.getSocketFactory();
    }

    private HostnameVerifier getHostNameVerifier() {
        HostnameVerifier hostnameVerifier = new HostnameVerifier(){

            @Override
            public boolean verify(String string, SSLSession sSLSession) {
                return true;
            }
        };
        return hostnameVerifier;
    }

    class ThumbprintTrustingManager
    implements X509TrustManager {
        private final String[] _thumbprints;

        public ThumbprintTrustingManager(String[] stringArray) {
            this._thumbprints = stringArray;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            for (X509Certificate x509Certificate : x509CertificateArray) {
                boolean bl = this.checkThumbprint(x509Certificate);
                if (!bl) continue;
                return;
            }
            String string2 = "Server certificate chain is not trusted and thumbprint doesn't match";
            throw new CertificateException(string2);
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        private boolean checkThumbprint(X509Certificate x509Certificate) {
            String string = "";
            try {
                string = CertificateUtil.getThumbprint(x509Certificate);
            }
            catch (Exception exception) {
                _logger.error((Object)"Failed to extract thumbprint from the certificate", (Throwable)exception);
            }
            for (String string2 : this._thumbprints) {
                if (!string2.equals(string)) continue;
                return true;
            }
            return false;
        }
    }
}

