/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.io;

import com.vmware.vise.util.ExceptionUtil;
import com.vmware.vise.util.Pair;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.util.zip.ZipFile;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StreamUtil {
    private static final Log _logger = LogFactory.getLog(StreamUtil.class);

    public static void close(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            _logger.error((Object)("Failed to close " + closeable.getClass().getName()), (Throwable)iOException);
        }
    }

    public static void close(XMLStreamReader xMLStreamReader) {
        if (xMLStreamReader == null) {
            return;
        }
        try {
            xMLStreamReader.close();
        }
        catch (Exception exception) {
            _logger.error((Object)("Failed to close " + xMLStreamReader.getClass().getName()), (Throwable)exception);
        }
    }

    public static void close(ZipFile zipFile) {
        if (zipFile == null) {
            return;
        }
        try {
            zipFile.close();
        }
        catch (IOException iOException) {
            _logger.error((Object)("Failed to close zip file " + zipFile.getName()), (Throwable)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(InputStream inputStream, String string) throws IOException, UnsupportedEncodingException {
        if (inputStream == null) {
            throw new IllegalArgumentException("Must pass-in non-null inputStream");
        }
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        StringBuilder stringBuilder = new StringBuilder(2000);
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2);
                stringBuilder.append('\n');
            }
        }
        finally {
            StreamUtil.close(bufferedReader);
            StreamUtil.close(inputStreamReader);
            StreamUtil.close(inputStream);
        }
        if (stringBuilder.length() == 0) {
            return null;
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Pair<byte[], IOException> toByteArrayInternal(InputStream inputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException("Must pass-in non-null inputStream");
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2000);
        long l = System.nanoTime();
        try {
            int n;
            while ((n = bufferedInputStream.read()) >= 0) {
                byteArrayOutputStream.write(n);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            Pair<byte[], Object> pair = new Pair<byte[], Object>(byArray, null);
            return pair;
        }
        catch (IOException iOException) {
            IOException iOException2;
            if (iOException instanceof InterruptedIOException) {
                long l2 = (System.nanoTime() - l) / 1000000L;
                String string = iOException.getMessage();
                iOException2 = ExceptionUtil.replaceMessage(iOException, string + " [milliseconds: " + l2 + "]");
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            Pair<byte[], void> pair = new Pair<byte[], void>(byArray, (void)iOException2);
            return pair;
        }
        finally {
            StreamUtil.close(bufferedInputStream);
            StreamUtil.close(inputStream);
        }
    }

    public static byte[] toByteArray(InputStream inputStream) throws IOException {
        Pair<byte[], IOException> pair = StreamUtil.toByteArrayInternal(inputStream);
        IOException iOException = (IOException)pair.second;
        if (iOException != null) {
            throw iOException;
        }
        return (byte[])pair.first;
    }

    public static StreamResult fetchStreamIntoStringAndReturnEquivalentStream(InputStream inputStream, String string) throws UnsupportedEncodingException {
        Pair<byte[], IOException> pair = StreamUtil.toByteArrayInternal(inputStream);
        byte[] byArray = (byte[])pair.first;
        IOException iOException = (IOException)pair.second;
        String string2 = null;
        if (byArray != null && byArray.length > 0) {
            string2 = new String(byArray, string);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        return new StreamResult(byteArrayInputStream, string2, iOException);
    }

    public static class StreamResult {
        private final InputStream _inputStream;
        private final String _streamContent;
        private final IOException _exception;

        public StreamResult(InputStream inputStream, String string, IOException iOException) {
            if (inputStream == null) {
                throw new IllegalArgumentException("The inputStream shouldn't be null");
            }
            this._inputStream = inputStream;
            this._streamContent = string;
            this._exception = iOException;
        }

        public InputStream getInputStream() {
            return this._inputStream;
        }

        public String getStreamContent() {
            return this._streamContent;
        }

        public IOException getException() {
            return this._exception;
        }
    }
}

