/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.reflection;

import com.vmware.vise.util.ExceptionUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.reflection.ReflectionUtil;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProfilingInvocationHandler
implements InvocationHandler {
    private static final Log _logger = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final Object _delegate;
    private final long _warnThresholdNanos;
    private final long _infoThresholdNanos;
    private final long _debugThresholdNanos;

    public ProfilingInvocationHandler(Object object, long l, long l2, long l3) {
        Validate.notNull((Object)object);
        Validate.isTrue((l >= 0L ? 1 : 0) != 0);
        this._delegate = object;
        this._warnThresholdNanos = l;
        this._infoThresholdNanos = l2;
        this._debugThresholdNanos = l3;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        long l = System.nanoTime();
        try {
            Object object2 = method.invoke(this._delegate, objectArray);
            return object2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = ExceptionUtil.unwrap(throwable);
            throw throwable2;
        }
        finally {
            long l2 = System.nanoTime() - l;
            if (l2 > this._warnThresholdNanos) {
                _logger.warn((Object)ProfilingInvocationHandler.buildLogMessage(method, l2));
            } else if (this._infoThresholdNanos > 0L && l2 > this._infoThresholdNanos) {
                _logger.info((Object)ProfilingInvocationHandler.buildLogMessage(method, l2));
            } else if (_logger.isDebugEnabled() && this._debugThresholdNanos > 0L && l2 > this._debugThresholdNanos) {
                _logger.debug((Object)ProfilingInvocationHandler.buildLogMessage(method, l2));
            } else if (_logger.isTraceEnabled()) {
                _logger.trace((Object)ProfilingInvocationHandler.buildLogMessage(method, l2));
            }
        }
    }

    private static String buildLogMessage(Method method, long l) {
        return "Invocation of " + ReflectionUtil.getBasicSignatureInfo(method) + " took too long: " + StringUtil.getGroupByThreeDecimalFormat().format(l) + " nanos";
    }
}

