/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.security;

import com.vmware.vise.util.session.SessionUtil;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.filter.OncePerRequestFilter;

public class NoPermissionsFilter
extends OncePerRequestFilter {
    private static final Log _logger = LogFactory.getLog(NoPermissionsFilter.class);
    public static final String USER_HAS_NO_PERMISSIONS_FOR_ALL_SERVERS = "userHasNoPermissionsForAllServers";
    private static final String LOGOUT_URL = "/logout";

    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        Boolean bl = this.getUserHasNoPermissionsFlag(httpServletRequest);
        if (bl != null) {
            _logger.info((Object)("Logout user without permissions authenticated with session: " + SessionUtil.getSessionInfo(httpServletRequest.getSession())));
            RequestDispatcher requestDispatcher = httpServletRequest.getRequestDispatcher(LOGOUT_URL);
            if (requestDispatcher != null) {
                requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            } else {
                httpServletResponse.sendRedirect(httpServletRequest.getContextPath() + LOGOUT_URL);
            }
        } else {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
    }

    protected Boolean getUserHasNoPermissionsFlag(HttpServletRequest httpServletRequest) {
        return (Boolean)SessionUtil.getData(USER_HAS_NO_PERMISSIONS_FOR_ALL_SERVERS, httpServletRequest.getSession());
    }
}

