/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.serialization;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.jsontype.impl.StdTypeResolverBuilder;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.vmware.vise.util.serialization.CustomTypeResolverBuilder;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;

public class JsonObjectMapper
extends ObjectMapper
implements InitializingBean {
    private static final long serialVersionUID = 1L;
    public static final String TYPE_PROPERTY_NAME = "_type";
    private static Map<Class, JsonSerializer> _proxies;

    public JsonObjectMapper() throws JsonMappingException {
        this(new String[0], null);
    }

    public JsonObjectMapper(String[] stringArray) throws JsonMappingException {
        this(stringArray, null);
    }

    public JsonObjectMapper(String[] stringArray, Map<Class, JsonSerializer> map) throws JsonMappingException {
        _proxies = map;
        StdTypeResolverBuilder stdTypeResolverBuilder = new CustomTypeResolverBuilder(ObjectMapper.DefaultTyping.NON_FINAL, stringArray).init(JsonTypeInfo.Id.CLASS, null).inclusion(JsonTypeInfo.As.PROPERTY).typeProperty(TYPE_PROPERTY_NAME);
        this.setDefaultTyping((TypeResolverBuilder)stdTypeResolverBuilder);
        this.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
    }

    public void afterPropertiesSet() throws Exception {
        this.addCustomSerializers();
    }

    private void addCustomSerializers() throws JsonMappingException {
        if (_proxies == null || _proxies.isEmpty()) {
            return;
        }
        SimpleModule simpleModule = new SimpleModule();
        for (Map.Entry<Class, JsonSerializer> entry : _proxies.entrySet()) {
            simpleModule.addSerializer(entry.getKey(), entry.getValue());
        }
        this.registerModules(new Module[]{simpleModule});
    }
}

