/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.service;

import com.vmware.vise.util.service.ServiceListener;
import com.vmware.vise.util.service.ServiceRegistry;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultServiceRegistry
implements ServiceRegistry {
    private static final Log _logger = LogFactory.getLog(DefaultServiceRegistry.class);
    private Map<String, List<Object>> _servicesByInterface = new HashMap<String, List<Object>>();
    private Map<String, List<ServiceListener>> _listenersByInterface = new HashMap<String, List<ServiceListener>>();

    @Override
    public synchronized void registerService(String string, Object object) {
        _logger.info((Object)("Registering " + object.getClass().getName() + " with interface " + string));
        List<Object> list = this._servicesByInterface.get(string);
        if (list == null) {
            list = new CopyOnWriteArrayList<Object>();
            this._servicesByInterface.put(string, list);
        }
        list.add(object);
        this.invokeAllListenersForService(string, object, true);
    }

    public synchronized List<Object> getServices(String string) {
        List<Object> list = this._servicesByInterface.get(string);
        if (list == null) {
            list = Collections.emptyList();
        }
        return list;
    }

    public synchronized Object getService(String string) {
        return this.getServices(string).get(0);
    }

    @Override
    public synchronized void registerServiceListener(String string, ServiceListener serviceListener) {
        _logger.info((Object)("Registering listener " + serviceListener.getClass().getName() + " with interface " + string));
        List<ServiceListener> list = this._listenersByInterface.get(string);
        if (list == null) {
            list = new CopyOnWriteArrayList<ServiceListener>();
            this._listenersByInterface.put(string, list);
        }
        list.add(serviceListener);
        this.invokeListenerForAllServices(string, serviceListener, true);
    }

    @Override
    public boolean unregisterServiceListener(String string, ServiceListener serviceListener) {
        return false;
    }

    private synchronized void invokeAllListenersForService(String string, Object object, boolean bl) {
        List<ServiceListener> list = this._listenersByInterface.get(string);
        if (list == null) {
            return;
        }
        for (ServiceListener serviceListener : list) {
            if (bl) {
                serviceListener.serviceAdded(object);
                continue;
            }
            serviceListener.serviceRemoved(object);
        }
    }

    private synchronized void invokeListenerForAllServices(String string, ServiceListener serviceListener, boolean bl) {
        List<Object> list = this._servicesByInterface.get(string);
        if (list == null) {
            return;
        }
        for (Object object : list) {
            if (bl) {
                serviceListener.serviceAdded(object);
                continue;
            }
            serviceListener.serviceRemoved(object);
        }
    }
}

