/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.dvs.commands;

import com.vmware.vim.binding.vim.DistributedVirtualSwitch;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPort;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.client.common.impl.ClientFutureImpl;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.common.compositecommand.FutureCommand;
import com.vmware.vsphere.client.common.compositecommand.api.spec.BaseCommandSpec;
import com.vmware.vsphere.client.dvs.api.spec.FetchDvPortsCommandSpec;
import java.util.ArrayList;
import java.util.HashMap;

public class FetchDvPortsCommand
extends FutureCommand {
    public FetchDvPortsCommand(FetchDvPortsCommandSpec commandSpec) {
        this.setCommandSpec((BaseCommandSpec)commandSpec);
    }

    protected ClientFutureImpl<?> launch() throws Exception {
        FetchDvPortsCommandSpec commandSpec = (FetchDvPortsCommandSpec)this.getCommandSpec();
        DistributedVirtualSwitch dvs = (DistributedVirtualSwitch)ManagedObjectUtil.getManagedObject((ManagedObjectReference)commandSpec.mor);
        ClientFutureImpl future = new ClientFutureImpl();
        dvs.fetchPorts(commandSpec.portCriteria, (Future)future);
        return future;
    }

    protected Object getFormedResult() {
        if (this.runtimeInfo.result != null && this.runtimeInfo.result instanceof DistributedVirtualPort[]) {
            HashMap<ManagedObjectReference, ArrayList<DistributedVirtualPort>> hostToPortsMap = new HashMap<ManagedObjectReference, ArrayList<DistributedVirtualPort>>();
            DistributedVirtualPort[] dvPorts = (DistributedVirtualPort[])this.runtimeInfo.result;
            if (dvPorts.length > 0) {
                for (DistributedVirtualPort port : dvPorts) {
                    if (port.proxyHost == null) continue;
                    ArrayList<DistributedVirtualPort> hostDvPorts = (ArrayList<DistributedVirtualPort>)hostToPortsMap.get(port.proxyHost);
                    if (hostDvPorts == null) {
                        hostDvPorts = new ArrayList<DistributedVirtualPort>();
                        hostToPortsMap.put(port.proxyHost, hostDvPorts);
                    }
                    hostDvPorts.add(port);
                }
            }
            return hostToPortsMap;
        }
        return null;
    }
}

