/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.network.impl;

import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.host.ConfigChange;
import com.vmware.vim.binding.vim.host.ConfigManager;
import com.vmware.vim.binding.vim.host.HostProxySwitch;
import com.vmware.vim.binding.vim.host.NetworkConfig;
import com.vmware.vim.binding.vim.host.NetworkPolicy;
import com.vmware.vim.binding.vim.host.NetworkSystem;
import com.vmware.vim.binding.vim.host.PciPassthruConfig;
import com.vmware.vim.binding.vim.host.PciPassthruSystem;
import com.vmware.vim.binding.vim.host.PortGroup;
import com.vmware.vim.binding.vim.host.VirtualNic;
import com.vmware.vim.binding.vim.host.VirtualNicManager;
import com.vmware.vim.binding.vim.host.VsanSystem;
import com.vmware.vim.binding.vim.vsan.host.ConfigInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationEffect;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.modules.api.network.PortGroupEditSpec;
import com.vmware.vsphere.client.modules.api.network.VirtualNicRemoveSpec;
import com.vmware.vsphere.client.modules.api.network.VmkernelSettingsSpec;
import com.vmware.vsphere.client.network.DnsAndRoutingSpec;
import com.vmware.vsphere.client.network.GhostProxySwitchRemoveSpec;
import com.vmware.vsphere.client.network.HostNetworkingAddSpec;
import com.vmware.vsphere.client.network.NetworkConfigSpec;
import com.vmware.vsphere.client.network.NetworkSystemRefreshSpec;
import com.vmware.vsphere.client.network.PhysicalNicEditSpec;
import com.vmware.vsphere.client.network.PhysicalNicsReconfigureSpec;
import com.vmware.vsphere.client.network.PortGroupRemoveSpec;
import com.vmware.vsphere.client.network.VirtualNicAddSpec;
import com.vmware.vsphere.client.network.VirtualNicEditSpec;
import com.vmware.vsphere.client.network.VirtualSwitchEditSpec;
import com.vmware.vsphere.client.network.VirtualSwitchRemoveSpec;
import com.vmware.vsphere.client.network.VssVirtualNicMigrateSpec;
import com.vmware.vsphere.client.network.impl.HostNetworkUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostNetworkMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(HostNetworkMutationProvider.class);
    private final DataService _dataService;

    public HostNetworkMutationProvider(DataService dataService) {
        this._dataService = dataService;
    }

    public OperationResult apply(ManagedObjectReference entity, PhysicalNicEditSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = entity;
        if (spec == null) {
            _logger.error((Object)"PhysicalNicEditSpec cannot be null");
            opResult.error = MixedUtil.getInvalidEntityFault();
            return opResult;
        }
        try {
            NetworkSystem networkSystem = this.getNetworkSystem(entity);
            networkSystem.updatePhysicalNicLinkSpeed(spec.device, spec.linkSpeed);
            if (spec.sriovConfig != null) {
                HostSystem host = (HostSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)entity);
                if (host == null) {
                    _logger.error((Object)"HostSystem is null");
                    opResult.error = MixedUtil.getInvalidEntityFault();
                    return opResult;
                }
                ConfigManager configMgr = host.getConfigManager();
                if (configMgr == null) {
                    _logger.error((Object)"Config manager is null");
                    opResult.error = MixedUtil.getInvalidEntityFault();
                    return opResult;
                }
                PciPassthruSystem system = (PciPassthruSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)configMgr.pciPassthruSystem);
                if (system == null) {
                    _logger.error((Object)"PciPassthruSystem is null");
                    opResult.error = MixedUtil.getInvalidEntityFault();
                    return opResult;
                }
                spec.sriovConfig.passthruEnabled = false;
                PciPassthruConfig[] pciPassThroughItem = new PciPassthruConfig[]{spec.sriovConfig};
                system.updatePassthruConfig(pciPassThroughItem);
                system.refresh();
                opResult.effect = OperationEffect.newDelayedEffect();
            }
        }
        catch (Exception e) {
            _logger.error((Object)("Error when updating the pnic: " + e.getMessage()));
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference entity, HostNetworkingAddSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = entity;
        if (spec == null) {
            _logger.error((Object)"HostNetworkingAddSpec cannot be null");
            opResult.error = MixedUtil.getInvalidEntityFault();
            return opResult;
        }
        if (spec.networkConfig == null) {
            _logger.error((Object)"NetworkConfig cannot be null");
            opResult.error = MixedUtil.getInvalidEntityFault();
            return opResult;
        }
        try {
            NetworkSystem networkSystem = this.getNetworkSystem(entity);
            NetworkConfig.Result result = networkSystem.updateNetworkConfig(spec.networkConfig, ConfigChange.Mode.modify.name());
            if (result.vnicDevice != null && result.vnicDevice.length > 0) {
                String vnicDevice = result.vnicDevice[0];
                if (spec.vmkernelSettingsSpec != null) {
                    this.setVmkernelSettings(entity, spec.vmkernelSettingsSpec, vnicDevice);
                }
            }
            opResult.effect = OperationEffect.newDelayedEffect();
        }
        catch (Exception ex) {
            _logger.error((Object)("Error when adding host networking: " + ex.getMessage()));
            opResult.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference hostRef, VssVirtualNicMigrateSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = hostRef;
        if (spec == null) {
            _logger.error((Object)"VssVirtualNicMigrateSpec cannot be null");
            opResult.error = MixedUtil.getInvalidEntityFault();
            return opResult;
        }
        try {
            NetworkSystem networkSystem = this.getNetworkSystem(hostRef);
            PortGroup.Specification portGroupSpec = new PortGroup.Specification();
            portGroupSpec.name = spec.portGroupToAdd;
            portGroupSpec.vswitchName = spec.switchName;
            portGroupSpec.vlanId = spec.vlanId;
            portGroupSpec.policy = new NetworkPolicy();
            networkSystem.addPortGroup(portGroupSpec);
            VirtualNic.Specification nicSpec = new VirtualNic.Specification();
            nicSpec.portgroup = spec.portGroupToAdd;
            if (spec.isServiceConsoleNic) {
                networkSystem.updateServiceConsoleVirtualNic(spec.nicName, nicSpec);
            } else {
                networkSystem.updateVirtualNic(spec.nicName, nicSpec);
            }
            if (spec.portGroupToRemove != null) {
                networkSystem.removePortGroup(spec.portGroupToRemove);
            }
        }
        catch (Exception ex) {
            opResult.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference entity, VirtualNicEditSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = entity;
        if (spec == null) {
            _logger.error((Object)"VirtualNicEditSpec cannot be null");
            opResult.error = MixedUtil.getInvalidEntityFault();
            return opResult;
        }
        try {
            NetworkSystem networkSystem = this.getNetworkSystem(entity);
            if (spec.isServiceConsoleVirtualNic) {
                networkSystem.updateServiceConsoleVirtualNic(spec.virtualNicName, spec.spec);
            } else {
                networkSystem.updateVirtualNic(spec.virtualNicName, spec.spec);
            }
            this.updateVmkernelSettings(entity, spec);
            opResult.effect = OperationEffect.newDelayedEffect();
        }
        catch (Exception ex) {
            _logger.error((Object)("Error when updating the settings of the virtual adapter: " + ex.getMessage()));
            opResult.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference entity, VirtualNicAddSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = entity;
        if (spec == null) {
            _logger.error((Object)"VirtualNicAddSpec cannot be null");
            opResult.error = MixedUtil.getInvalidEntityFault();
            return opResult;
        }
        if (spec.vnicConfig == null) {
            _logger.error((Object)"VirtualNicConfig cannot be null");
            opResult.error = MixedUtil.getInvalidEntityFault();
            return opResult;
        }
        try {
            NetworkSystem networkSystem = this.getNetworkSystem(entity);
            if (spec.isServiceConsoleVnic.booleanValue()) {
                networkSystem.addServiceConsoleVirtualNic("", spec.vnicConfig.spec);
            } else {
                String vnicDevice = networkSystem.addVirtualNic("", spec.vnicConfig.spec);
                if (vnicDevice != null && spec.vmkernelSettingsSpec != null) {
                    this.setVmkernelSettings(entity, spec.vmkernelSettingsSpec, vnicDevice);
                }
            }
            opResult.effect = OperationEffect.newDelayedEffect();
        }
        catch (Exception ex) {
            _logger.error((Object)("Error when adding new virtual adapter: " + ex.getMessage()));
            opResult.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference entity, VirtualNicRemoveSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = entity;
        if (spec == null) {
            _logger.error((Object)"VirtualNicRemoveSpec cannot be null");
            opResult.error = MixedUtil.getInvalidEntityFault();
            return opResult;
        }
        try {
            NetworkSystem networkSystem = this.getNetworkSystem(entity);
            if (spec.virtualNicName != null) {
                if (spec.isServiceConsoleVirtualNic.booleanValue()) {
                    networkSystem.removeServiceConsoleVirtualNic(spec.virtualNicName);
                } else {
                    networkSystem.removeVirtualNic(spec.virtualNicName);
                }
            }
            if (!StringUtil.isNullOrEmpty((String)spec.portgroupName)) {
                networkSystem.removePortGroup(spec.portgroupName);
            }
        }
        catch (Exception ex) {
            _logger.error((Object)("Error when removing virtual adapter: " + ex.getMessage()));
            opResult.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference entity, PortGroupEditSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = entity;
        if (spec == null) {
            _logger.error((Object)"PortGroupEditSpec cannot be null");
            opResult.error = MixedUtil.getInvalidEntityFault();
            return opResult;
        }
        try {
            NetworkSystem networkSystem = this.getNetworkSystem(entity);
            if (spec.portGroupName == null) {
                spec.portGroupName = "";
            }
            networkSystem.updatePortGroup(spec.portGroupName, spec.spec);
        }
        catch (Exception ex) {
            _logger.error((Object)("Error when updating the port group settings: " + ex.getMessage()));
            opResult.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference entity, PortGroupRemoveSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = entity;
        if (spec == null) {
            _logger.error((Object)"PortGroupRemoveSpec cannot be null");
            opResult.error = MixedUtil.getInvalidEntityFault();
            return opResult;
        }
        try {
            NetworkSystem networkSystem = this.getNetworkSystem(entity);
            if (spec.virtualNicSpec != null) {
                if (spec.virtualNicSpec.isServiceConsoleVirtualNic.booleanValue()) {
                    networkSystem.removeServiceConsoleVirtualNic(spec.virtualNicSpec.virtualNicName);
                } else {
                    networkSystem.removeVirtualNic(spec.virtualNicSpec.virtualNicName);
                }
            }
            if (spec.portgroupName != null) {
                networkSystem.removePortGroup(spec.portgroupName);
            }
        }
        catch (Exception ex) {
            _logger.error((Object)("Error when removing port group: " + ex.getMessage()));
            opResult.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference entity, VirtualSwitchEditSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = entity;
        if (spec == null) {
            _logger.error((Object)"VirtualSwitchEditSpec cannot be null");
            opResult.error = MixedUtil.getInvalidEntityFault();
            return opResult;
        }
        try {
            NetworkSystem networkSystem = this.getNetworkSystem(entity);
            networkSystem.updateVirtualSwitch(spec.virtualSwitchName, spec.spec);
        }
        catch (Exception ex) {
            _logger.error((Object)("Error when updating the virtual switch settings: " + ex.getMessage()));
            opResult.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference entity, VirtualSwitchRemoveSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = entity;
        if (spec == null) {
            _logger.error((Object)"VirtualSwitchRemoveSpec cannot be null");
            opResult.error = MixedUtil.getInvalidEntityFault();
            return opResult;
        }
        try {
            NetworkSystem networkSystem = this.getNetworkSystem(entity);
            networkSystem.updateNetworkConfig(spec.networkConfig, ConfigChange.Mode.modify.toString());
            networkSystem.removeVirtualSwitch(spec.switchId);
        }
        catch (Exception ex) {
            _logger.error((Object)("Error when removing a virtual standard switch: " + ex.getMessage()));
            opResult.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference entity, NetworkConfigSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = entity;
        if (spec == null) {
            _logger.error((Object)"NetworkConfigSpec cannot be null");
            return opResult;
        }
        try {
            NetworkSystem networkSystem = this.getNetworkSystem(entity);
            networkSystem.updateNetworkConfig(spec.config, ConfigChange.Mode.modify.toString());
        }
        catch (Exception e) {
            _logger.error((Object)("Error when updating the network configuration of the host: " + e.getMessage()));
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference hostRef, NetworkSystemRefreshSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = hostRef;
        try {
            NetworkSystem networkSystem = this.getNetworkSystem(hostRef);
            networkSystem.refresh();
        }
        catch (Exception e) {
            _logger.error((Object)("Error when refreshing the network system of the host: " + e.getMessage()));
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference entity, DnsAndRoutingSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = entity;
        try {
            NetworkSystem networkSystem = this.getNetworkSystem(entity);
            if (spec.networkConfigSpec != null) {
                networkSystem.updateNetworkConfig(spec.networkConfigSpec.config, ConfigChange.Mode.modify.toString());
            }
            if (spec.routingSpec != null) {
                if (spec.routingSpec.consoleIpRouteConfig != null) {
                    networkSystem.updateConsoleIpRouteConfig(spec.routingSpec.consoleIpRouteConfig);
                }
                if (spec.routingSpec.ipRouteConfig != null) {
                    networkSystem.updateIpRouteConfig(spec.routingSpec.ipRouteConfig);
                }
            }
            if (spec.dnsSpec != null) {
                networkSystem.updateDnsConfig(spec.dnsSpec.config);
            }
        }
        catch (Exception e) {
            _logger.error((Object)("Error when updating the dns and routing configuration: " + e.getMessage()));
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference entity, PhysicalNicsReconfigureSpec spec) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = entity;
        if (spec == null) {
            _logger.error((Object)"Parameter 'spec' cannot be null");
            operationResult.error = MixedUtil.getInvalidEntityFault();
            return operationResult;
        }
        try {
            NetworkSystem networkSystem = this.getNetworkSystem(entity);
            operationResult.result = networkSystem.updateNetworkConfig(spec.networkConfig, ConfigChange.Mode.modify.name());
        }
        catch (Exception ex) {
            _logger.error((Object)("Error when adding new virtual adapter: " + ex.getMessage()));
            operationResult.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return operationResult;
    }

    public OperationResult apply(ManagedObjectReference hostRef, GhostProxySwitchRemoveSpec spec) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = hostRef;
        try {
            NetworkSystem networkSystem = this.getNetworkSystem(hostRef);
            NetworkConfig networkConfig = this.createGhostProxySwitchRemovalSpec(spec);
            operationResult.result = networkSystem.updateNetworkConfig(networkConfig, ConfigChange.Mode.modify.name());
        }
        catch (Exception ex) {
            _logger.error((Object)("Error when removing ghost proxy: " + ex.getMessage()));
            operationResult.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return operationResult;
    }

    private NetworkConfig createGhostProxySwitchRemovalSpec(GhostProxySwitchRemoveSpec spec) {
        HostProxySwitch.Config hpsConfig = new HostProxySwitch.Config();
        hpsConfig.changeOperation = ConfigChange.Operation.remove.name();
        hpsConfig.uuid = spec.dvsUuid;
        NetworkConfig networkConfig = new NetworkConfig();
        networkConfig.proxySwitch = new HostProxySwitch.Config[]{hpsConfig};
        return networkConfig;
    }

    private void updateVmkernelSettings(ManagedObjectReference hostSystemRef, VirtualNicEditSpec spec) throws Exception {
        if (spec.changedVmkSettings != null && spec.changedVmkSettings.length > 0) {
            ManagedObjectReference vnicManagerRef = (ManagedObjectReference)QueryUtil.getProperty((DataService)this._dataService, (Object)hostSystemRef, (String)"virtualNicManager");
            VirtualNicManager vnicManager = (VirtualNicManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vnicManagerRef);
            ArrayList<String> vsanRemovedAdapters = new ArrayList<String>();
            ArrayList<String> vsanAddedAdapters = new ArrayList<String>();
            block9: for (VirtualNicManager.NicType type2 : spec.changedVmkSettings) {
                switch (type2) {
                    case vmotion: {
                        if (spec.isVmotionEnabled.booleanValue()) {
                            vnicManager.selectVnic(VirtualNicManager.NicType.vmotion.toString(), spec.virtualNicName);
                            continue block9;
                        }
                        vnicManager.deselectVnic(VirtualNicManager.NicType.vmotion.toString(), spec.virtualNicName);
                        continue block9;
                    }
                    case faultToleranceLogging: {
                        if (spec.isFtEnabled.booleanValue()) {
                            vnicManager.selectVnic(VirtualNicManager.NicType.faultToleranceLogging.toString(), spec.virtualNicName);
                            continue block9;
                        }
                        vnicManager.deselectVnic(VirtualNicManager.NicType.faultToleranceLogging.toString(), spec.virtualNicName);
                        continue block9;
                    }
                    case management: {
                        if (spec.isHaEnabled.booleanValue()) {
                            vnicManager.selectVnic(VirtualNicManager.NicType.management.toString(), spec.virtualNicName);
                            continue block9;
                        }
                        vnicManager.deselectVnic(VirtualNicManager.NicType.management.toString(), spec.virtualNicName);
                        continue block9;
                    }
                    case vSphereReplication: {
                        if (spec.isVRTrafficEnabled.booleanValue()) {
                            vnicManager.selectVnic(VirtualNicManager.NicType.vSphereReplication.toString(), spec.virtualNicName);
                            continue block9;
                        }
                        vnicManager.deselectVnic(VirtualNicManager.NicType.vSphereReplication.toString(), spec.virtualNicName);
                        continue block9;
                    }
                    case vSphereReplicationNFC: {
                        if (spec.isVrNfcTrafficEnabled.booleanValue()) {
                            vnicManager.selectVnic(VirtualNicManager.NicType.vSphereReplicationNFC.toString(), spec.virtualNicName);
                            continue block9;
                        }
                        vnicManager.deselectVnic(VirtualNicManager.NicType.vSphereReplicationNFC.toString(), spec.virtualNicName);
                        continue block9;
                    }
                    case vSphereProvisioning: {
                        if (spec.isProvisioningNfcTrafficEnabled.booleanValue()) {
                            vnicManager.selectVnic(VirtualNicManager.NicType.vSphereProvisioning.toString(), spec.virtualNicName);
                            continue block9;
                        }
                        vnicManager.deselectVnic(VirtualNicManager.NicType.vSphereProvisioning.toString(), spec.virtualNicName);
                        continue block9;
                    }
                    case vsan: {
                        if (spec.isVsanEnabled.booleanValue()) {
                            vsanAddedAdapters.add(spec.virtualNicName);
                            continue block9;
                        }
                        vsanRemovedAdapters.add(spec.virtualNicName);
                        continue block9;
                    }
                }
            }
            if (vsanRemovedAdapters.size() + vsanAddedAdapters.size() > 0) {
                HostSystem hostSystem = (HostSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hostSystemRef);
                ConfigManager configManager = hostSystem.getConfigManager();
                ManagedObjectReference vsanSystemRef = configManager.getVsanSystem();
                VsanSystem vsanSystem = (VsanSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vsanSystemRef);
                this.applyVsanSettings(vsanSystem, vsanRemovedAdapters, vsanAddedAdapters);
            }
        }
    }

    private void setVmkernelSettings(ManagedObjectReference hostSystemRef, VmkernelSettingsSpec spec, String vnicDevice) throws Exception {
        if (hostSystemRef == null) {
            return;
        }
        ManagedObjectReference vnicManagerRef = (ManagedObjectReference)QueryUtil.getProperty((DataService)this._dataService, (Object)hostSystemRef, (String)"virtualNicManager");
        VirtualNicManager vnicManager = (VirtualNicManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vnicManagerRef);
        if (vnicManager == null) {
            return;
        }
        if (spec.vnicDeviceName == null) {
            spec.vnicDeviceName = vnicDevice;
        }
        if (spec.isVmotionEnabled) {
            vnicManager.selectVnic(VirtualNicManager.NicType.vmotion.toString(), spec.vnicDeviceName);
        }
        if (spec.isHaEnabled) {
            vnicManager.selectVnic(VirtualNicManager.NicType.management.toString(), spec.vnicDeviceName);
        }
        if (spec.isFtEnabled) {
            vnicManager.selectVnic(VirtualNicManager.NicType.faultToleranceLogging.toString(), spec.vnicDeviceName);
        }
        if (spec.isVRTrafficEnabled) {
            vnicManager.selectVnic(VirtualNicManager.NicType.vSphereReplication.toString(), spec.vnicDeviceName);
        }
        if (spec.isVrNfcTrafficEnabled) {
            vnicManager.selectVnic(VirtualNicManager.NicType.vSphereReplicationNFC.toString(), spec.vnicDeviceName);
        }
        if (spec.isProvisioningNfcTrafficEnabled) {
            vnicManager.selectVnic(VirtualNicManager.NicType.vSphereProvisioning.toString(), spec.vnicDeviceName);
        }
        if (spec.isVsanEnabled) {
            HostSystem hostSystem = (HostSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hostSystemRef);
            ConfigManager configManager = hostSystem.getConfigManager();
            ManagedObjectReference vsanSystemRef = configManager.getVsanSystem();
            VsanSystem vsanSystem = (VsanSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vsanSystemRef);
            ArrayList<String> enabled = new ArrayList<String>();
            enabled.add(spec.vnicDeviceName);
            List<String> emptyList = Collections.emptyList();
            this.applyVsanSettings(vsanSystem, emptyList, enabled);
        }
    }

    private NetworkSystem getNetworkSystem(ManagedObjectReference hostSystemRef) throws Exception {
        ManagedObjectReference networkSystemRef = (ManagedObjectReference)QueryUtil.getProperty((DataService)this._dataService, (Object)hostSystemRef, (String)"networkSystem");
        NetworkSystem networkSystem = (NetworkSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)networkSystemRef);
        return networkSystem;
    }

    private void applyVsanSettings(VsanSystem vsanSystem, Collection<String> disabledAdapters, Collection<String> enabledAdapters) {
        ConfigInfo vsanConfig = vsanSystem.getConfig();
        ConfigInfo newVsanConfig = HostNetworkUtil.applyVsanSettings(vsanConfig, disabledAdapters, enabledAdapters);
        vsanSystem.update(newVsanConfig);
    }
}

