/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.network.impl;

import com.vmware.vim.binding.vim.host.NetworkSystem;
import com.vmware.vim.binding.vim.host.VirtualNic;
import com.vmware.vim.binding.vim.host.VirtualNicManager;
import com.vmware.vim.binding.vim.host.VsanSystem;
import com.vmware.vim.binding.vim.vsan.host.ConfigInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.client.common.impl.ClientFutureImpl;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostNetworkUtil {
    private static final Log _logger = LogFactory.getLog(HostNetworkUtil.class);

    public static ClientFutureImpl<String> addVirtualNetworkAdapter(ManagedObjectReference networkSystemReference, VirtualNic.Specification vnicSpec, Boolean isServiceConsole) {
        ClientFutureImpl future = new ClientFutureImpl();
        try {
            NetworkSystem networkSystem = (NetworkSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)networkSystemReference);
            if (isServiceConsole.booleanValue()) {
                networkSystem.addServiceConsoleVirtualNic("", vnicSpec, (Future)future);
            } else {
                networkSystem.addVirtualNic("", vnicSpec, (Future)future);
            }
        }
        catch (Exception exception) {
            _logger.warn((Object)"Unable to add new virtual network adapter.", (Throwable)exception);
            future.setException(exception);
        }
        return future;
    }

    public static ClientFutureImpl<Void> updateVirtualNetworkAdater(ManagedObjectReference networkSystemReference, VirtualNic.Specification vnicSpec, String virtualNetworkAdapterName) {
        ClientFutureImpl future = new ClientFutureImpl();
        try {
            NetworkSystem networkSystem = (NetworkSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)networkSystemReference);
            networkSystem.updateVirtualNic(virtualNetworkAdapterName, vnicSpec, (Future)future);
        }
        catch (Exception exception) {
            _logger.warn((Object)"Unable to update virtual network adapter.", (Throwable)exception);
            future.setException(exception);
        }
        return future;
    }

    public static ClientFutureImpl<Void> removeVirtualNetworkAdater(ManagedObjectReference networkSystemReference, String virtualNetworkAdapterName) {
        ClientFutureImpl future = new ClientFutureImpl();
        try {
            NetworkSystem networkSystem = (NetworkSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)networkSystemReference);
            networkSystem.removeVirtualNic(virtualNetworkAdapterName, (Future)future);
        }
        catch (Exception exception) {
            _logger.warn((Object)"Unable to remove virtual network adapter.", (Throwable)exception);
            future.setException(exception);
        }
        return future;
    }

    public static ClientFutureImpl<Void> setVirtualNicService(ManagedObjectReference virtualNicManagerReference, VirtualNicManager.NicType nicType, String virtualNetworkAdapterName, Boolean enable) {
        ClientFutureImpl future = new ClientFutureImpl();
        try {
            if (nicType == VirtualNicManager.NicType.vsan) {
                _logger.warn((Object)"Enabling/disabling vsan is done through the VsanSystem object");
            }
            VirtualNicManager vnicManager = (VirtualNicManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)virtualNicManagerReference);
            if (enable.booleanValue()) {
                vnicManager.selectVnic(nicType.toString(), virtualNetworkAdapterName, (Future)future);
            } else {
                vnicManager.deselectVnic(nicType.toString(), virtualNetworkAdapterName, (Future)future);
            }
        }
        catch (Exception exception) {
            _logger.warn((Object)("Unable to toggle vmkernel for service: " + nicType.toString()), (Throwable)exception);
            future.setException(exception);
        }
        return future;
    }

    public static ManagedObjectReference setVirtualNicVsanService(ManagedObjectReference vsanSystemReference, String virtualNetworkAdapterName, Boolean enable) {
        try {
            List<String> emptyList = Collections.emptyList();
            Set<String> device = Collections.singleton(virtualNetworkAdapterName);
            VsanSystem vsanSystem = (VsanSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vsanSystemReference);
            ConfigInfo currentConfigInfo = vsanSystem.getConfig();
            ConfigInfo newConfigInfo = enable != false ? HostNetworkUtil.applyVsanSettings(currentConfigInfo, emptyList, device) : HostNetworkUtil.applyVsanSettings(currentConfigInfo, device, emptyList);
            ManagedObjectReference taskReference = vsanSystem.update(newConfigInfo);
            return taskReference;
        }
        catch (Exception exception) {
            _logger.warn((Object)"Unable to toggle vmkernel for vsan.", (Throwable)exception);
            return null;
        }
    }

    public static ConfigInfo applyVsanSettings(ConfigInfo vsanConfig, Collection<String> disabledAdapters, Collection<String> enabledAdapters) {
        HashSet<String> disabledAdaptersSet = new HashSet<String>();
        HashSet<String> enabledAdaptersSet = new HashSet<String>();
        if (disabledAdapters != null) {
            disabledAdaptersSet.addAll(disabledAdapters);
        }
        if (enabledAdapters != null) {
            enabledAdaptersSet.addAll(enabledAdapters);
        }
        ArrayList<ConfigInfo.NetworkInfo.PortConfig> current = new ArrayList<ConfigInfo.NetworkInfo.PortConfig>();
        if (vsanConfig != null && vsanConfig.networkInfo != null && !ArrayUtil.isNullOrEmpty((Object[])vsanConfig.networkInfo.port)) {
            for (ConfigInfo.NetworkInfo.PortConfig portConfig : vsanConfig.networkInfo.port) {
                current.add(portConfig);
            }
        }
        Iterator portConfigIterator = current.iterator();
        while (portConfigIterator.hasNext()) {
            ConfigInfo.NetworkInfo.PortConfig next = (ConfigInfo.NetworkInfo.PortConfig)portConfigIterator.next();
            if (disabledAdaptersSet.contains(next.device)) {
                portConfigIterator.remove();
            }
            if (!enabledAdaptersSet.contains(next.device)) continue;
            enabledAdaptersSet.remove(next.device);
        }
        for (String adapter : enabledAdaptersSet) {
            ConfigInfo.NetworkInfo.PortConfig portConfig;
            portConfig = new ConfigInfo.NetworkInfo.PortConfig();
            portConfig.device = adapter;
            current.add(portConfig);
        }
        ConfigInfo newVsanConfig = new ConfigInfo();
        newVsanConfig.networkInfo = new ConfigInfo.NetworkInfo();
        newVsanConfig.networkInfo.port = current.toArray(new ConfigInfo.NetworkInfo.PortConfig[current.size()]);
        return newVsanConfig;
    }
}

