/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.networkselector.impl;

import com.vmware.vim.binding.vim.Network;
import com.vmware.vim.binding.vim.NumericRange;
import com.vmware.vim.binding.vim.OpaqueNetwork;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPort;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vim.dvs.NetworkResourcePool;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vim.vm.device.VirtualDevice;
import com.vmware.vim.binding.vim.vm.device.VirtualEthernetCard;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.OrderingCriteria;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.modules.api.networkselector.NetworkSelectorFilterSpec;
import com.vmware.vsphere.client.modules.api.networkselector.NetworkSelectorPortgroupData;
import com.vmware.vsphere.client.modules.api.networkselector.NetworkSelectorResult;
import com.vmware.vsphere.client.networkselector.NetworkAdapterNetworkMatch;
import com.vmware.vsphere.client.networkselector.NetworkSelectorDvsData;
import com.vmware.vsphere.client.networkselector.NetworkSelectorNetworkMatch;
import com.vmware.vsphere.client.networkselector.NetworkSelectorOpaqueNetworkTypeData;
import com.vmware.vsphere.client.networkselector.NetworkSelectorUtil;
import com.vmware.vsphere.client.networkselector.impl.NetworkSelectorMatcherService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NetworkSelectorPropertyProvider
implements PropertyProviderBean {
    private static final int CHUNK_SIZE = 4096;
    private static final String NRP_NOT_ASSOCIATED = "-1";
    private static final String UPLINKS_DELIMITER = ", ";
    private static final String NAME_PROPERTY = "name";
    private static final String ACCESSIBLE_PROPERTY = "summary.accessible";
    private static final String OPAQUE_NETWORK_TYPE_PROPERTY = "summary[@type='OpaqueNetworkSummary'].opaqueNetworkType";
    private static final String NSX_NETWORK_TYPE_PROPERTY_VALUE = "nsx.LogicalSwitch";
    private static final String OPAQUE_NETWORK_ID_PROPERTY = "summary[@type='OpaqueNetworkSummary'].opaqueNetworkId";
    private static final String NETWORK_NAME_PROPERTY = "name";
    private static final String DVS_PROPERTY = "config.distributedVirtualSwitch";
    private static final String DVS_NAME_PROPERTY = "dvsName";
    private static final String PORTGROUP_DVS_NAME_PROPERTY = "dvsName";
    private static final String DEFAULT_PORT_CONFIG_PROPERTY = "config.defaultPortConfig";
    private static final String VM_LENGTH_PROPERTY = "vm._length";
    private static final String NUM_PORTS_PROPERTY = "config.numPorts";
    private static final String TYPE_PROPERTY = "config.type";
    private static final String IP_POOL_NAME_PROPERTY = "summary.ipPoolName";
    private static final String[] STD_NETWORK_PROPS_BASIC = new String[]{"name"};
    private static final String[] STD_NETWORK_PROPS_ADVANCED = new String[]{"name", "summary.accessible", "summary.ipPoolName", "vm._length"};
    private static final String[] OPAQUE_NETWORK_PROPS_BASIC = new String[]{"name"};
    private static final String[] OPAQUE_NETWORK_PROPS_ADVANCED = new String[]{"name", "summary.accessible", "summary.ipPoolName", "vm._length", "summary[@type='OpaqueNetworkSummary'].opaqueNetworkType"};
    private static final String DVPG_KEY_PROPERTY = "key";
    private static final String DVPG_DVS_UUID_PROPERTY = "dvsUuid";
    private static final String DVS_UUID_PROPERTY = "uuid";
    private static final String DVS_NETWORK_RESOURCE_POOL_PROPERTY = "networkResourcePool";
    private static final String DVS_UPLINK_PORT_POLICY_PROPERTY = "config.uplinkPortPolicy[@type=\"DVSNameArrayUplinkPortPolicy\"].uplinkPortName";
    private static final String DVS_PVLAN_CONFIG = "config[@type='VMwareDVSConfigInfo'].pvlanConfig";
    private static final String VM_DEVICES_PROPERTY = "config.hardware.device";
    private static final String VM_NETWORK_RELATION = "allNetwork";
    private static final String ANY_NETWORK_TYPE = "AnyNetwork";
    private static final String NETWORK_NAME_UI_FIELD = "name";
    private static final String PORTGROUP_DVSNAME_UI_FIELD = "dvsName";
    private static Log _logger = LogFactory.getLog(NetworkSelectorPropertyProvider.class);
    private final DataService _dataService;
    private final NetworkSelectorMatcherService _networkSelectorMatcherService;

    public NetworkSelectorPropertyProvider(DataService dataService, NetworkSelectorMatcherService networkSelectorMatcherService) {
        this._dataService = dataService;
        this._networkSelectorMatcherService = networkSelectorMatcherService;
    }

    @type(value="VmwareDistributedVirtualSwitch,DistributedVirtualSwitch,Datacenter,HostSystem,VirtualMachine,Folder,ClusterComputeResource,com.vmware.vcenter.vdcs.Vdc")
    public NetworkSelectorPortgroupData[] getNetworkSelectorFilteredNetworksByRefs(Object target, Object[] networkRefs) throws Exception {
        networkRefs = this.getRelatedNetworksByRefs(target, networkRefs, false);
        return this.getNetworkSelectorFilteredNetworksByRefs(networkRefs, false);
    }

    @type(value="VmwareDistributedVirtualSwitch,DistributedVirtualSwitch,Datacenter,HostSystem,VirtualMachine,Folder,ClusterComputeResource,com.vmware.vcenter.vdcs.Vdc")
    public NetworkSelectorResult getNetworkSelectorFilteredNetworks(Object target, NetworkSelectorFilterSpec filterSpec) throws Exception {
        long startTimeNs = System.nanoTime();
        NetworkSelectorResult networks = this.getNetworkSelectorFilteredNetworksInternal(target, filterSpec);
        if (_logger.isDebugEnabled()) {
            long stopTimeNs = System.nanoTime();
            long durationNs = stopTimeNs - startTimeNs;
            double durationS = (double)durationNs / 1.0E9;
            int netCount = networks.networks == null ? 0 : networks.networks.length;
            _logger.debug((Object)String.format("getNetworkSelectorFilteredNetworks() - %.3fs - %d networks.", durationS, netCount));
        }
        return networks;
    }

    @type(value="VmwareDistributedVirtualSwitch,DistributedVirtualSwitch,Datacenter,HostSystem,VirtualMachine,Folder,ClusterComputeResource")
    public NetworkAdapterNetworkMatch[] getDestinationNetworksForVms(ManagedObjectReference destination, Object[] vms) throws Exception {
        Object[] vmRefs = NetworkSelectorUtil.getMorsOfType(vms, VirtualMachine.class.getSimpleName());
        if (ArrayUtil.isNullOrEmpty((Object[])vmRefs)) {
            return new NetworkAdapterNetworkMatch[0];
        }
        HashMap<String, ManagedObjectReference> networksByKey = new HashMap<String, ManagedObjectReference>();
        ArrayList<Object> sourceNetworks = new ArrayList<Object>();
        this.populateSourceNetworkData((ManagedObjectReference[])vmRefs, networksByKey, sourceNetworks);
        List<NetworkAdapterNetworkMatch> matches = this.getAdaptersDataForVms((ManagedObjectReference[])vmRefs, networksByKey);
        NetworkSelectorPortgroupData[] sourceData = this.getNetworkSelectorFilteredNetworksByRefs(sourceNetworks.toArray(new Object[sourceNetworks.size()]), false);
        Object[] matchedDestinationNetworks = this._networkSelectorMatcherService.getMatchingNetworks(destination, sourceData);
        NetworkSelectorPortgroupData[] destinationNetworksData = this.getNetworkSelectorFilteredNetworksByRefs(matchedDestinationNetworks, false);
        NetworkMatchFactory networkMatchFactory = new NetworkMatchFactory(destinationNetworksData);
        NetworkSelectorNetworkMatch[] networkMatches = new NetworkSelectorNetworkMatch[sourceData.length];
        for (int index = 0; index < networkMatches.length; ++index) {
            networkMatches[index] = networkMatchFactory.newNetworkMatch(sourceData[index]);
        }
        HashMap<ManagedObjectReference, ManagedObjectReference> destinationNetworkBySource = new HashMap<ManagedObjectReference, ManagedObjectReference>(networkMatches.length);
        for (NetworkSelectorNetworkMatch networkMatch : networkMatches) {
            destinationNetworkBySource.put(networkMatch.source, networkMatch.destination);
        }
        this.populateDestinationNetworkData(destinationNetworkBySource, matches);
        return matches.toArray(new NetworkAdapterNetworkMatch[matches.size()]);
    }

    @type(value="VmwareDistributedVirtualSwitch,DistributedVirtualSwitch,Datacenter,HostSystem,VirtualMachine,Folder,ClusterComputeResource")
    public NetworkSelectorNetworkMatch[] getDestinationNetworksByContext(ManagedObjectReference destination, Object[] sources) throws Exception {
        return this.getDestinationNetworksByContextInternal(destination, sources);
    }

    @type(value="VmwareDistributedVirtualSwitch,DistributedVirtualSwitch,Datacenter,HostSystem,VirtualMachine,Folder,ClusterComputeResource")
    public NetworkSelectorOpaqueNetworkTypeData[] getOpaqueNetworkTypes(ManagedObjectReference destination, Object[] opaqueNetworks) throws Exception {
        if (ArrayUtil.isNullOrEmpty((Object[])opaqueNetworks)) {
            return null;
        }
        Object[] propertyValues = null;
        try {
            propertyValues = QueryUtil.getProperty((DataService)this._dataService, (Object[])opaqueNetworks, (String)OPAQUE_NETWORK_TYPE_PROPERTY);
        }
        catch (Exception e) {
            _logger.error((Object)("Retrieval of opaque network types failed:" + e.getLocalizedMessage()));
        }
        if (ArrayUtil.isNullOrEmpty((Object[])propertyValues)) {
            return null;
        }
        LinkedList<NetworkSelectorOpaqueNetworkTypeData> networkTypes = new LinkedList<NetworkSelectorOpaqueNetworkTypeData>();
        for (Object prop : propertyValues) {
            networkTypes.add(new NetworkSelectorOpaqueNetworkTypeData((ManagedObjectReference)((PropertyValue)prop).resourceObject, (String)((PropertyValue)prop).value));
        }
        return networkTypes.toArray(new NetworkSelectorOpaqueNetworkTypeData[networkTypes.size()]);
    }

    private NetworkSelectorResult getNetworkSelectorFilteredNetworksInternal(Object target, NetworkSelectorFilterSpec filterSpec) throws Exception {
        List<NetworkSelectorPortgroupData> unsortedNetworks;
        Object[] requiredNetworks;
        if (ArrayUtil.isNullOrEmpty((Object[])filterSpec.networks) || filterSpec.networksCount == null) {
            requiredNetworks = new NetworkSelectorPortgroupData[]{};
        } else {
            Object[] relatedFilterNetworks = this.getRelatedNetworksByRefs(target, filterSpec.networks, filterSpec.includeInaccessibleNetworks);
            requiredNetworks = this.getNetworkSelectorFilteredNetworksByRefs(relatedFilterNetworks, filterSpec.includeAdvancedData);
            if (!ArrayUtil.isNullOrEmpty((Object[])requiredNetworks) && filterSpec.networksCount > 0) {
                filterSpec.networksCount = Math.max(0, filterSpec.networksCount - requiredNetworks.length);
                if (filterSpec.networksCount == 0) {
                    return new NetworkSelectorResult((NetworkSelectorPortgroupData[])requiredNetworks, requiredNetworks.length);
                }
            }
        }
        QuerySpec networksQuerySpec = this.buildQuerySpecForNetworks(target, filterSpec);
        ResultSet networkPropsResultSet = this.requestNetworks(networksQuerySpec);
        if (networkPropsResultSet == null || ArrayUtil.isNullOrEmpty((Object[])networkPropsResultSet.items)) {
            return new NetworkSelectorResult((NetworkSelectorPortgroupData[])requiredNetworks, requiredNetworks.length);
        }
        HashMap<Object, Integer> resultsOrder = new HashMap<Object, Integer>(networkPropsResultSet.items.length);
        for (int i = 0; i < networkPropsResultSet.items.length; ++i) {
            Object ref = networkPropsResultSet.items[i].resourceObject;
            resultsOrder.put(ref, i);
        }
        List<NetworkSelectorPortgroupData> retrievedNetworks = this.retrieveNetworkProperties(filterSpec, networkPropsResultSet.items, filterSpec.includeAdvancedData);
        if (requiredNetworks.length == 0) {
            unsortedNetworks = retrievedNetworks;
        } else {
            unsortedNetworks = new ArrayList<NetworkSelectorPortgroupData>(requiredNetworks.length + retrievedNetworks.size());
            unsortedNetworks.addAll(Arrays.asList(requiredNetworks));
            unsortedNetworks.addAll(retrievedNetworks);
        }
        NetworkSelectorPortgroupData[] result = this.processResultNetworks(unsortedNetworks, resultsOrder, filterSpec.includeAdvancedData);
        return new NetworkSelectorResult(result, networkPropsResultSet.totalMatchedObjectCount.intValue());
    }

    private NetworkSelectorPortgroupData[] processResultNetworks(List<NetworkSelectorPortgroupData> retrievedNetworks, final Map<Object, Integer> resultsOrder, boolean includeAdvancedData) {
        NetworkSelectorPortgroupData[] result = retrievedNetworks.toArray(new NetworkSelectorPortgroupData[retrievedNetworks.size()]);
        Arrays.sort(result, new java.util.Comparator<NetworkSelectorPortgroupData>(){

            @Override
            public int compare(NetworkSelectorPortgroupData lhs, NetworkSelectorPortgroupData rhs) {
                Integer leftIdx = (Integer)resultsOrder.get(lhs.networkRef);
                Integer rightIdx = (Integer)resultsOrder.get(rhs.networkRef);
                if (leftIdx == null) {
                    if (rightIdx == null) {
                        return 0;
                    }
                    return 1;
                }
                if (rightIdx == null) {
                    return -1;
                }
                return leftIdx - rightIdx;
            }
        });
        for (NetworkSelectorPortgroupData item : result) {
            item.isExtendedData = includeAdvancedData;
        }
        return result;
    }

    private List<NetworkSelectorPortgroupData> retrieveNetworkProperties(NetworkSelectorFilterSpec filterSpec, ResultItem[] networks, boolean includeExtendedProperties) {
        long startTimeNs = System.nanoTime();
        ManagedObjectReference[] standardNetworkRefs = NetworkSelectorUtil.getEntitiesOfType(networks, Network.class.getSimpleName());
        Collection<NetworkSelectorPortgroupData> standardNetworks = this.retrieveStandardNetworkProperties(standardNetworkRefs, includeExtendedProperties);
        ManagedObjectReference[] opaqueNetworkRefs = NetworkSelectorUtil.getEntitiesOfType(networks, OpaqueNetwork.class.getSimpleName());
        Collection<NetworkSelectorPortgroupData> opaqueNetworks = this.retrieveOpaqueNetworkProperties(opaqueNetworkRefs, includeExtendedProperties, filterSpec.includeOpaqueNetworkTypes);
        HashSet<ManagedObjectReference> distributedPortGroupsSet = new HashSet<ManagedObjectReference>();
        HashSet<ManagedObjectReference> uplinkPortGroupsSet = new HashSet<ManagedObjectReference>();
        this.populatePortGroupSets(distributedPortGroupsSet, uplinkPortGroupsSet, networks);
        ManagedObjectReference[] portGroupRefs = this.getPortGroupRefs(filterSpec, distributedPortGroupsSet, uplinkPortGroupsSet);
        Collection<NetworkSelectorPortgroupData> distributedPortGroups = this.retrieveDistributedPortGroupPropertiesInChunks(portGroupRefs, 4096, distributedPortGroupsSet, uplinkPortGroupsSet, false, filterSpec.includeAdvancedData);
        ArrayList<NetworkSelectorPortgroupData> unsortedNetworks = new ArrayList<NetworkSelectorPortgroupData>(standardNetworks.size() + opaqueNetworks.size() + distributedPortGroups.size());
        unsortedNetworks.addAll(standardNetworks);
        unsortedNetworks.addAll(opaqueNetworks);
        unsortedNetworks.addAll(distributedPortGroups);
        if (_logger.isDebugEnabled()) {
            long stopTimeNs = System.nanoTime();
            long durationNs = stopTimeNs - startTimeNs;
            double durationS = (double)durationNs / 1.0E9;
            int netCount = networks == null ? 0 : networks.length;
            _logger.debug((Object)String.format("additional property retrieval - %.3fs.", durationS, netCount));
        }
        return unsortedNetworks;
    }

    private final void populateSourceNetworkData(ManagedObjectReference[] vmRefs, Map<String, ManagedObjectReference> networksByPortgroupKey, List<Object> sourceNetworks) throws Exception {
        CompositeConstraint sourceNetworksConstraint = new CompositeConstraint();
        sourceNetworksConstraint.conjoiner = Conjoiner.OR;
        sourceNetworksConstraint.targetType = ANY_NETWORK_TYPE;
        sourceNetworksConstraint.nestedConstraints = new Constraint[vmRefs.length];
        for (int i = 0; i < vmRefs.length; ++i) {
            Constraint networkRelation;
            ManagedObjectReference vmRef = vmRefs[i];
            sourceNetworksConstraint.nestedConstraints[i] = networkRelation = QueryUtil.createConstraintForRelationship((Object)vmRef, (String)VM_NETWORK_RELATION, (String)ANY_NETWORK_TYPE);
        }
        QuerySpec sourceNetworksQuerySpec = QueryUtil.buildQuerySpec((Constraint)sourceNetworksConstraint, (String[])new String[]{DVPG_KEY_PROPERTY, OPAQUE_NETWORK_ID_PROPERTY, OPAQUE_NETWORK_TYPE_PROPERTY});
        ResultSet resultSet = QueryUtil.getData((DataService)this._dataService, (QuerySpec)sourceNetworksQuerySpec);
        for (ResultItem sourceNetworkItem : resultSet.items) {
            sourceNetworks.add(sourceNetworkItem.resourceObject);
            if (!(sourceNetworkItem.resourceObject instanceof ManagedObjectReference)) continue;
            ManagedObjectReference mor = (ManagedObjectReference)sourceNetworkItem.resourceObject;
            if (DistributedVirtualPortgroup.class.getSimpleName().equals(mor.getType())) {
                String portgroupKey = null;
                for (PropertyValue pv : sourceNetworkItem.properties) {
                    if (!DVPG_KEY_PROPERTY.equals(pv.propertyName)) continue;
                    portgroupKey = (String)pv.value;
                    break;
                }
                networksByPortgroupKey.put(portgroupKey, mor);
                continue;
            }
            if (!OpaqueNetwork.class.getSimpleName().equals(mor.getType())) continue;
            String opaqueNetworkId = null;
            String opaqueNetworkType = null;
            for (PropertyValue pv : sourceNetworkItem.properties) {
                if (OPAQUE_NETWORK_ID_PROPERTY.equals(pv.propertyName)) {
                    opaqueNetworkId = (String)pv.value;
                    continue;
                }
                if (!OPAQUE_NETWORK_TYPE_PROPERTY.equals(pv.propertyName)) continue;
                opaqueNetworkType = (String)pv.value;
            }
            networksByPortgroupKey.put(NetworkSelectorUtil.getOpaqueNetworkKey(opaqueNetworkId, opaqueNetworkType), mor);
        }
    }

    private final List<NetworkAdapterNetworkMatch> getAdaptersDataForVms(ManagedObjectReference[] vmRefs, Map<String, ManagedObjectReference> networksByPortgroupKey) throws Exception {
        QuerySpec sourceAdaptersQuerySpec = QueryUtil.buildQuerySpec((Object[])vmRefs, (String[])new String[]{VM_DEVICES_PROPERTY});
        ResultSet resultSet = QueryUtil.getData((DataService)this._dataService, (QuerySpec)sourceAdaptersQuerySpec);
        ArrayList<NetworkAdapterNetworkMatch> matches = new ArrayList<NetworkAdapterNetworkMatch>();
        for (ResultItem vmItem : resultSet.items) {
            VirtualDevice[] virtualDevices;
            if (ArrayUtil.isNullOrEmpty((Object[])vmItem.properties) || vmItem.properties[0] == null || !(vmItem.properties[0].value instanceof VirtualDevice[])) continue;
            for (VirtualDevice vmDevice : virtualDevices = (VirtualDevice[])vmItem.properties[0].value) {
                if (!(vmDevice instanceof VirtualEthernetCard)) continue;
                NetworkAdapterNetworkMatch match = new NetworkAdapterNetworkMatch();
                match.sourceAdapter = (VirtualEthernetCard)vmDevice;
                match.sourceVm = (ManagedObjectReference)vmItem.resourceObject;
                VirtualDevice.BackingInfo backing = vmDevice.backing;
                if (backing instanceof VirtualEthernetCard.NetworkBackingInfo) {
                    ManagedObjectReference sourceNetwork;
                    match.sourceNetwork = sourceNetwork = ((VirtualEthernetCard.NetworkBackingInfo)backing).network;
                } else if (backing instanceof VirtualEthernetCard.OpaqueNetworkBackingInfo) {
                    String opaqueNetKey = NetworkSelectorUtil.getOpaqueNetworkKey((VirtualEthernetCard.OpaqueNetworkBackingInfo)backing);
                    match.sourceNetwork = networksByPortgroupKey.get(opaqueNetKey);
                } else if (backing instanceof VirtualEthernetCard.DistributedVirtualPortBackingInfo) {
                    String portgroupKey = ((VirtualEthernetCard.DistributedVirtualPortBackingInfo)backing).port.portgroupKey;
                    match.sourceNetwork = networksByPortgroupKey.get(portgroupKey);
                }
                matches.add(match);
            }
        }
        return matches;
    }

    private final void populateDestinationNetworkData(Map<ManagedObjectReference, ManagedObjectReference> destinationNetworkBySource, List<NetworkAdapterNetworkMatch> matches) throws Exception {
        ArrayList<ManagedObjectReference> destinationNetworksList = new ArrayList<ManagedObjectReference>(destinationNetworkBySource.values());
        destinationNetworksList.removeAll(Collections.singleton(null));
        Object[] destinationNetworks = destinationNetworksList.toArray();
        if (ArrayUtil.isNullOrEmpty((Object[])destinationNetworks)) {
            return;
        }
        PropertyValue[] destinationNetworkProperties = QueryUtil.getProperties((DataService)this._dataService, (Object[])destinationNetworks, (String[])new String[]{"name", DVPG_KEY_PROPERTY, DVPG_DVS_UUID_PROPERTY, OPAQUE_NETWORK_ID_PROPERTY, OPAQUE_NETWORK_TYPE_PROPERTY});
        String networkName = null;
        String portgroupKey = null;
        String switchUuid = null;
        String opaqueId = null;
        String opaqueType = null;
        ManagedObjectReference destinationNetwork = null;
        HashMap<ManagedObjectReference, String> networkNamesByNetworkRef = new HashMap<ManagedObjectReference, String>(destinationNetworks.length);
        HashMap<ManagedObjectReference, String> portgroupKeysByNetworkRef = new HashMap<ManagedObjectReference, String>(destinationNetworks.length);
        HashMap<ManagedObjectReference, String> switchUuidsByNetworkRef = new HashMap<ManagedObjectReference, String>(destinationNetworks.length);
        HashMap<ManagedObjectReference, String> opaqueIdsByNetworkRef = new HashMap<ManagedObjectReference, String>(destinationNetworks.length);
        HashMap<ManagedObjectReference, String> opaqueTypesByNetworkRef = new HashMap<ManagedObjectReference, String>(destinationNetworks.length);
        for (PropertyValue propertyValue : destinationNetworkProperties) {
            if (propertyValue == null || !(propertyValue.value instanceof String) || !(propertyValue.resourceObject instanceof ManagedObjectReference)) {
                _logger.debug((Object)"Could not parse data results for some destination network.");
                continue;
            }
            destinationNetwork = (ManagedObjectReference)propertyValue.resourceObject;
            if ("name".equals(propertyValue.propertyName)) {
                networkName = (String)propertyValue.value;
                networkNamesByNetworkRef.put(destinationNetwork, networkName);
                continue;
            }
            if (DVPG_KEY_PROPERTY.equals(propertyValue.propertyName)) {
                portgroupKey = (String)propertyValue.value;
                portgroupKeysByNetworkRef.put(destinationNetwork, portgroupKey);
                continue;
            }
            if (DVPG_DVS_UUID_PROPERTY.equals(propertyValue.propertyName)) {
                switchUuid = (String)propertyValue.value;
                switchUuidsByNetworkRef.put(destinationNetwork, switchUuid);
                continue;
            }
            if (OPAQUE_NETWORK_ID_PROPERTY.equals(propertyValue.propertyName)) {
                opaqueId = (String)propertyValue.value;
                opaqueIdsByNetworkRef.put(destinationNetwork, opaqueId);
                continue;
            }
            if (!OPAQUE_NETWORK_TYPE_PROPERTY.equals(propertyValue.propertyName)) continue;
            opaqueType = (String)propertyValue.value;
            opaqueTypesByNetworkRef.put(destinationNetwork, opaqueType);
        }
        for (NetworkAdapterNetworkMatch match : matches) {
            match.destinationNetwork = destinationNetworkBySource.get(match.sourceNetwork);
            match.destinationNetworkName = (String)networkNamesByNetworkRef.get(match.destinationNetwork);
            match.destinationPortgroupKey = (String)portgroupKeysByNetworkRef.get(match.destinationNetwork);
            match.destinationSwitchUuid = (String)switchUuidsByNetworkRef.get(match.destinationNetwork);
            match.destinationOpaqueId = (String)opaqueIdsByNetworkRef.get(match.destinationNetwork);
            match.destinationOpaqueType = (String)opaqueTypesByNetworkRef.get(match.destinationNetwork);
        }
    }

    private NetworkSelectorNetworkMatch[] getDestinationNetworksByContextInternal(ManagedObjectReference destination, Object[] sources) throws Exception {
        NetworkSelectorFilterSpec filterSpec = new NetworkSelectorFilterSpec();
        filterSpec.includeStandardNetworks = true;
        filterSpec.includeOpaqueNetworks = true;
        filterSpec.includeDistributedPortGroups = true;
        NetworkSelectorResult destinationData = this.getNetworkSelectorFilteredNetworksInternal(destination, filterSpec);
        NetworkMatchFactory networkMatchFactory = new NetworkMatchFactory(destinationData.networks);
        NetworkSelectorPortgroupData[] sourceData = this.getNetworkSelectorFilteredNetworksByRefs(sources, false);
        ArrayList<NetworkSelectorNetworkMatch> networkMatches = new ArrayList<NetworkSelectorNetworkMatch>();
        for (NetworkSelectorPortgroupData data2 : sourceData) {
            networkMatches.add(networkMatchFactory.newNetworkMatch(data2));
        }
        return networkMatches.toArray(new NetworkSelectorNetworkMatch[networkMatches.size()]);
    }

    private NetworkSelectorPortgroupData[] getNetworkSelectorFilteredNetworksByRefs(Object[] networkRefs, boolean advancedData) throws Exception {
        long startTimeMs = System.currentTimeMillis();
        ManagedObjectReference[] standardNetworkRefs = NetworkSelectorUtil.getMorsOfType(networkRefs, Network.class.getSimpleName());
        ManagedObjectReference[] opaqueNetworkRefs = NetworkSelectorUtil.getMorsOfType(networkRefs, OpaqueNetwork.class.getSimpleName());
        ManagedObjectReference[] distributedPortGroupRefs = NetworkSelectorUtil.getMorsOfType(networkRefs, DistributedVirtualPortgroup.class.getSimpleName());
        Collection<NetworkSelectorPortgroupData> rawStandardNetworks = this.retrieveStandardNetworkProperties(standardNetworkRefs, advancedData);
        NetworkSelectorPortgroupData[] standardNetworks = rawStandardNetworks.toArray(new NetworkSelectorPortgroupData[rawStandardNetworks.size()]);
        Collection<NetworkSelectorPortgroupData> rawOpaqueNetworks = this.retrieveOpaqueNetworkProperties(opaqueNetworkRefs, advancedData, false);
        NetworkSelectorPortgroupData[] opaqueNetworks = rawOpaqueNetworks.toArray(new NetworkSelectorPortgroupData[rawOpaqueNetworks.size()]);
        Collection<NetworkSelectorPortgroupData> rawDistributedPortGroups = this.retrieveDistributedPortGroupPropertiesInChunks(distributedPortGroupRefs, 4096, null, null, true, advancedData);
        NetworkSelectorPortgroupData[] distributedPortGroups = rawDistributedPortGroups.toArray(new NetworkSelectorPortgroupData[rawDistributedPortGroups.size()]);
        NetworkSelectorPortgroupData[] result = new NetworkSelectorPortgroupData[standardNetworks.length + opaqueNetworks.length + distributedPortGroups.length];
        System.arraycopy(standardNetworks, 0, result, 0, standardNetworks.length);
        System.arraycopy(opaqueNetworks, 0, result, standardNetworks.length, opaqueNetworks.length);
        System.arraycopy(distributedPortGroups, 0, result, standardNetworks.length + opaqueNetworks.length, distributedPortGroups.length);
        for (NetworkSelectorPortgroupData item : result) {
            item.isExtendedData = advancedData;
        }
        if (_logger.isDebugEnabled()) {
            long stopTimeMs = System.currentTimeMillis();
            long durationMs = stopTimeMs - startTimeMs;
            double durationS = (double)durationMs / 1000.0;
            _logger.debug((Object)String.format("Retrieved in %.3fs (networks %d)", durationS, result.length));
        }
        return result;
    }

    private Object[] getRelatedNetworksByRefs(Object target, Object[] networkRefs, boolean includeInaccessibleNetworks) {
        ArrayList<Object> resultNetworkRefs = new ArrayList<Object>();
        Constraint allNetworksConstraint = NetworkSelectorUtil.createConstraintForAllNetworks(target);
        Constraint searchedNetworksConstraint = NetworkSelectorUtil.createConstraintForNetworks(networkRefs);
        CompositeConstraint compositeConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{allNetworksConstraint, searchedNetworksConstraint}, (Conjoiner)Conjoiner.AND);
        QuerySpec querySpec = NetworkSelectorUtil.createEmptyQuerySpecForConstraint((Constraint)compositeConstraint);
        ResultSet resultSet = null;
        try {
            resultSet = QueryUtil.getData((DataService)this._dataService, (QuerySpec)querySpec);
        }
        catch (Exception e) {
            _logger.error((Object)("Data retrieval of network references failed: " + e.getMessage()));
        }
        HashSet<ManagedObjectReference> networkSet = new HashSet<ManagedObjectReference>();
        if (resultSet != null && resultSet.items != null) {
            for (ResultItem resultItem : resultSet.items) {
                if (resultItem == null || !(resultItem.resourceObject instanceof ManagedObjectReference)) continue;
                resultNetworkRefs.add(resultItem.resourceObject);
                networkSet.add((ManagedObjectReference)resultItem.resourceObject);
            }
        }
        if (includeInaccessibleNetworks && !ArrayUtil.isNullOrEmpty((Object[])networkRefs)) {
            for (Object object : networkRefs) {
                if (!(object instanceof ManagedObjectReference) || networkSet.contains(object)) continue;
                resultNetworkRefs.add(object);
            }
        }
        return resultNetworkRefs.toArray(new Object[resultNetworkRefs.size()]);
    }

    private ManagedObjectReference[] getPortGroupRefs(NetworkSelectorFilterSpec filterSpec, Set<ManagedObjectReference> distributedPortGroupsSet, Set<ManagedObjectReference> uplinkPortGroupsSet) {
        LinkedList<ManagedObjectReference> portGroupRefs = new LinkedList<ManagedObjectReference>();
        if (filterSpec.includeDistributedPortGroups) {
            portGroupRefs.addAll(distributedPortGroupsSet);
        }
        if (filterSpec.includeUplinkPortGroups) {
            portGroupRefs.addAll(uplinkPortGroupsSet);
        }
        return portGroupRefs.toArray(new ManagedObjectReference[portGroupRefs.size()]);
    }

    private QuerySpec buildQuerySpecForNetworks(Object target, NetworkSelectorFilterSpec filterSpec) {
        Constraint identifyingConstraint = this.buildNetworkIdentificationConstraint(target, filterSpec);
        Constraint filteringConstraint = null;
        if (filterSpec.filterText != null && filterSpec.filteredFields != null) {
            filteringConstraint = this.buildTextFilterConstraint(filterSpec);
        } else if (!ArrayUtil.isNullOrEmpty((Object[])filterSpec.fieldFilterSpecs)) {
            filteringConstraint = this.buildFieldFilterConstraint(filterSpec.fieldFilterSpecs);
        }
        Constraint finalConstraint = filteringConstraint != null ? QueryUtil.combineIntoSingleConstraint((Constraint[])new Constraint[]{identifyingConstraint, filteringConstraint}, (Conjoiner)Conjoiner.AND) : identifyingConstraint;
        QuerySpec networksQuerySpec = NetworkSelectorUtil.createPortgroupTypeQuerySpec(finalConstraint);
        networksQuerySpec.resultSpec = this.buildResultSpec(filterSpec);
        return networksQuerySpec;
    }

    private Constraint buildNetworkIdentificationConstraint(Object target, NetworkSelectorFilterSpec filterSpec) {
        ArrayList<Constraint> constraints = new ArrayList<Constraint>();
        if (filterSpec.includeStandardNetworks) {
            Constraint standardNetworksConstraint = NetworkSelectorUtil.createConstraintForStandardNetworks(target);
            constraints.add(standardNetworksConstraint);
        }
        if (filterSpec.includeOpaqueNetworks) {
            Constraint opaqueNetworksConstraint = NetworkSelectorUtil.createConstraintForOpaqueNetworks(target);
            constraints.add(opaqueNetworksConstraint);
        }
        if (filterSpec.includeDistributedPortGroups && filterSpec.includeUplinkPortGroups) {
            Constraint portGroupsConstraint = NetworkSelectorUtil.createConstraintForDistributedPortGroups(target);
            constraints.add(portGroupsConstraint);
        } else {
            if (filterSpec.includeDistributedPortGroups) {
                Constraint nonUplinkPortGroupsConstraint = NetworkSelectorUtil.createConstraintForDistributedPortGroups(target, false);
                constraints.add(nonUplinkPortGroupsConstraint);
            }
            if (filterSpec.includeUplinkPortGroups) {
                Constraint uplinkPortGroupsConstraint = NetworkSelectorUtil.createConstraintForDistributedPortGroups(target, true);
                constraints.add(uplinkPortGroupsConstraint);
            }
        }
        Constraint compositeConstraint = QueryUtil.combineIntoSingleConstraint((Constraint[])constraints.toArray(new Constraint[constraints.size()]), (Conjoiner)Conjoiner.OR);
        int preFetchedNetCount = filterSpec.networks == null ? 0 : filterSpec.networks.length;
        int networksToOmitCount = filterSpec.networksToExclude == null ? 0 : filterSpec.networksToExclude.length;
        int networksToExcludeCount = preFetchedNetCount + networksToOmitCount;
        if (networksToExcludeCount > 0) {
            Object[] networksToExclude = new ManagedObjectReference[networksToExcludeCount];
            if (preFetchedNetCount > 0) {
                System.arraycopy(filterSpec.networks, 0, networksToExclude, 0, preFetchedNetCount);
            }
            if (networksToOmitCount > 0) {
                System.arraycopy(filterSpec.networksToExclude, 0, networksToExclude, preFetchedNetCount, networksToOmitCount);
            }
            Constraint requiredNetworksConstraint = NetworkSelectorUtil.createConstraintForNetworks(networksToExclude);
            compositeConstraint = QueryUtil.combineIntoSingleConstraint((Constraint[])new Constraint[]{compositeConstraint, requiredNetworksConstraint}, (Conjoiner)Conjoiner.EXCEPT);
        }
        return compositeConstraint;
    }

    private Constraint buildTextFilterConstraint(NetworkSelectorFilterSpec filterSpec) {
        Constraint[] filterConstraints = new Constraint[filterSpec.filteredFields.length];
        for (int i = 0; i < filterSpec.filteredFields.length; ++i) {
            if ("name".equals(filterSpec.filteredFields[i])) {
                filterConstraints[i] = QueryUtil.createPropertyConstraint((String)ANY_NETWORK_TYPE, (String)"name", (Comparator)Comparator.TEXTUALLY_MATCHES, (Object)filterSpec.filterText);
                continue;
            }
            if (!"dvsName".equals(filterSpec.filteredFields[i])) continue;
            filterConstraints[i] = QueryUtil.createPropertyConstraint((String)DistributedVirtualPortgroup.class.getSimpleName(), (String)"dvsName", (Comparator)Comparator.TEXTUALLY_MATCHES, (Object)filterSpec.filterText);
        }
        Constraint combinedFilteringConstraint = QueryUtil.combineIntoSingleConstraint((Constraint[])filterConstraints, (Conjoiner)Conjoiner.OR);
        return combinedFilteringConstraint;
    }

    private Constraint buildFieldFilterConstraint(NetworkSelectorFilterSpec.FieldFilterSpec[] fieldFilterSpecs) {
        ArrayList<PropertyConstraint> filterConstraints = new ArrayList<PropertyConstraint>();
        for (NetworkSelectorFilterSpec.FieldFilterSpec fieldFilterSpec : fieldFilterSpecs) {
            if ("name".equals(fieldFilterSpec.filterField)) {
                filterConstraints.add(QueryUtil.createPropertyConstraint((String)ANY_NETWORK_TYPE, (String)"name", (Comparator)Comparator.TEXTUALLY_MATCHES, (Object)fieldFilterSpec.filterText));
                continue;
            }
            if ("dvsName".equals(fieldFilterSpec.filterField)) {
                filterConstraints.add(QueryUtil.createPropertyConstraint((String)DistributedVirtualPortgroup.class.getSimpleName(), (String)"dvsName", (Comparator)Comparator.TEXTUALLY_MATCHES, (Object)fieldFilterSpec.filterText));
                continue;
            }
            _logger.error((Object)"Unsupported filter field.");
        }
        CompositeConstraint combinedFilteringConstraint = QueryUtil.createCompositeConstraint((Constraint[])filterConstraints.toArray(new Constraint[filterConstraints.size()]), (Conjoiner)Conjoiner.AND);
        return combinedFilteringConstraint;
    }

    private ResultSpec buildResultSpec(NetworkSelectorFilterSpec filterSpec) {
        if (filterSpec.networksCount == null || filterSpec.networksCount == 0) {
            return null;
        }
        ResultSpec resultSpec = new ResultSpec();
        resultSpec.maxResultCount = filterSpec.networksCount;
        resultSpec.offset = filterSpec.offset;
        if (filterSpec.order != null) {
            resultSpec.order = new OrderingCriteria();
            resultSpec.order.orderingProperties = filterSpec.order;
        }
        return resultSpec;
    }

    private ResultSet requestNetworks(QuerySpec networksQuerySpec) {
        long startTimeNs = System.nanoTime();
        ResultSet networks = null;
        try {
            networks = QueryUtil.getData((DataService)this._dataService, (QuerySpec)networksQuerySpec);
        }
        catch (Exception e) {
            _logger.error((Object)"Data retrieval of related ntworks failed.", (Throwable)e);
        }
        if (_logger.isDebugEnabled()) {
            long stopTimeNs = System.nanoTime();
            long durationNs = stopTimeNs - startTimeNs;
            double durationS = (double)durationNs / 1.0E9;
            int netCount = networks == null || networks.items == null ? 0 : networks.items.length;
            _logger.debug((Object)String.format("requestNetworks() - %.3fs - %d networks.", durationS, netCount));
        }
        return networks;
    }

    private void populateNetworkResoucePoolData(NetworkSelectorPortgroupData ns, NetworkSelectorDvsData dvsData, String networkResourcePoolKey) {
        if (networkResourcePoolKey == null || networkResourcePoolKey.isEmpty()) {
            ns.isNetworkResourcePoolAssociated = true;
        } else if (networkResourcePoolKey.equals(NRP_NOT_ASSOCIATED)) {
            ns.isNetworkResourcePoolAssociated = false;
        } else if (dvsData != null && !ArrayUtil.isNullOrEmpty((Object[])dvsData.networkResourcePool)) {
            for (NetworkResourcePool nrp : dvsData.networkResourcePool) {
                if (nrp == null || nrp.key == null || !nrp.key.equals(networkResourcePoolKey)) continue;
                ns.isNetworkResourcePoolAssociated = true;
                ns.networkResourcePoolName = nrp.name;
                break;
            }
        }
    }

    private void populatePortGroupSets(Set<ManagedObjectReference> distributedPortGroupsSet, Set<ManagedObjectReference> uplinkPortGroupsSet, ResultItem[] resultItems) {
        if (!ArrayUtil.isNullOrEmpty((Object[])resultItems)) {
            for (ResultItem ri : resultItems) {
                ManagedObjectReference mor;
                if (!(ri.resourceObject instanceof ManagedObjectReference) || !ManagedObjectUtil.isOfType((ManagedObjectReference)(mor = (ManagedObjectReference)ri.resourceObject), DistributedVirtualPortgroup.class) || ArrayUtil.isNullOrEmpty((Object[])ri.properties)) continue;
                for (PropertyValue pv : ri.properties) {
                    if (!pv.propertyName.equals("isUplinkPortgroup") || !(pv.value instanceof Boolean)) continue;
                    Boolean isUplink = (Boolean)pv.value;
                    if (!isUplink.booleanValue() && distributedPortGroupsSet != null) {
                        distributedPortGroupsSet.add(mor);
                        continue;
                    }
                    if (!isUplink.booleanValue() || uplinkPortGroupsSet == null) continue;
                    uplinkPortGroupsSet.add(mor);
                }
            }
        }
    }

    private Collection<NetworkSelectorPortgroupData> retrieveDistributedPortGroupPropertiesInChunks(ManagedObjectReference[] portgroups, int chunkSize, Set<ManagedObjectReference> distributedPortGroupsSet, Set<ManagedObjectReference> uplinkPortGroupsSet, boolean retrieveIsUplinkProperty, boolean includeExtendedProperties) {
        if (ArrayUtil.isNullOrEmpty((Object[])portgroups) || chunkSize <= 0) {
            return Collections.emptyList();
        }
        HashMap<ManagedObjectReference, NetworkSelectorPortgroupData> portGroupsMap = new HashMap<ManagedObjectReference, NetworkSelectorPortgroupData>();
        HashMap<ManagedObjectReference, NetworkSelectorDvsData> dvsMap = new HashMap<ManagedObjectReference, NetworkSelectorDvsData>();
        HashMap<ManagedObjectReference, ManagedObjectReference> pgToDvsMap = new HashMap<ManagedObjectReference, ManagedObjectReference>();
        int numberOfChunks = (int)Math.ceil((double)portgroups.length / (double)chunkSize);
        for (int i = 0; i < numberOfChunks; ++i) {
            Object[] mors = null;
            mors = i < numberOfChunks - 1 ? Arrays.copyOfRange(portgroups, chunkSize * i, chunkSize * i + chunkSize) : Arrays.copyOfRange(portgroups, chunkSize * i, portgroups.length);
            PropertyValue[] propertyValues = null;
            try {
                ArrayList<String> properties = new ArrayList<String>();
                properties.add("name");
                if (retrieveIsUplinkProperty) {
                    properties.add("isUplinkPortgroup");
                }
                if (includeExtendedProperties) {
                    properties.add(DVS_PROPERTY);
                    properties.add(VM_LENGTH_PROPERTY);
                    properties.add(DEFAULT_PORT_CONFIG_PROPERTY);
                    properties.add(NUM_PORTS_PROPERTY);
                    properties.add(TYPE_PROPERTY);
                } else {
                    properties.add(DVPG_DVS_UUID_PROPERTY);
                    properties.add("dvsName");
                }
                String[] propertyNames = properties.toArray(new String[properties.size()]);
                propertyValues = QueryUtil.getProperties((DataService)this._dataService, (Object[])mors, (String[])propertyNames);
            }
            catch (Exception e) {
                _logger.error((Object)"Retrieval of distributed network properties failed.", (Throwable)e);
            }
            this.updateDvsMap(propertyValues, dvsMap);
            this.updatePortGroupsMap(propertyValues, portGroupsMap, dvsMap, distributedPortGroupsSet, uplinkPortGroupsSet, pgToDvsMap);
        }
        return portGroupsMap.values();
    }

    private void updatePortGroupsMap(PropertyValue[] properties, Map<ManagedObjectReference, NetworkSelectorPortgroupData> portGroupsMap, Map<ManagedObjectReference, NetworkSelectorDvsData> dvsMap, Set<ManagedObjectReference> distributedPortGroupsSet, Set<ManagedObjectReference> uplinkPortGroupsSet, Map<ManagedObjectReference, ManagedObjectReference> pgToDvsMap) {
        this.populatePgToDvsMap(properties, pgToDvsMap);
        if (!ArrayUtil.isNullOrEmpty((Object[])properties)) {
            for (PropertyValue pv : properties) {
                ManagedObjectReference pgRef = (ManagedObjectReference)pv.resourceObject;
                NetworkSelectorPortgroupData networkData = portGroupsMap.get(pgRef);
                if (networkData == null) {
                    networkData = new NetworkSelectorPortgroupData();
                    networkData.networkRef = pgRef;
                    portGroupsMap.put(pgRef, networkData);
                }
                if (distributedPortGroupsSet != null && distributedPortGroupsSet.contains(pgRef)) {
                    networkData.isUplink = false;
                } else if (uplinkPortGroupsSet != null && uplinkPortGroupsSet.contains(pgRef)) {
                    networkData.isUplink = true;
                }
                ManagedObjectReference dvsRef = pgToDvsMap.get(pgRef);
                NetworkSelectorDvsData dvsData = dvsMap.get(dvsRef);
                if (dvsData != null) {
                    networkData.dvsName = dvsData.name;
                }
                if (pv.propertyName.equals("name") && pv.value instanceof String) {
                    networkData.name = (String)pv.value;
                    continue;
                }
                if (pv.propertyName.equals(VM_LENGTH_PROPERTY) && pv.value != null) {
                    networkData.vmCount = Integer.parseInt(pv.value.toString());
                    continue;
                }
                if (pv.propertyName.equals("dvsName") && pv.value instanceof String) {
                    networkData.dvsName = (String)pv.value;
                    continue;
                }
                if (pv.propertyName.equals(DVPG_DVS_UUID_PROPERTY) && pv.value instanceof String) {
                    networkData.dvsUuid = (String)pv.value;
                    continue;
                }
                if (pv.propertyName.equals(NUM_PORTS_PROPERTY) && pv.value instanceof Integer) {
                    networkData.portCount = (Integer)pv.value;
                    continue;
                }
                if (pv.propertyName.equals(TYPE_PROPERTY) && pv.value instanceof String) {
                    networkData.type = (String)pv.value;
                    continue;
                }
                if (pv.propertyName.equals(IP_POOL_NAME_PROPERTY) && pv.value instanceof String) {
                    networkData.ipPoolName = (String)pv.value;
                    continue;
                }
                if (pv.propertyName.equals(DEFAULT_PORT_CONFIG_PROPERTY) && pv.value instanceof DistributedVirtualPort.Setting) {
                    this.populatePortConfigSettings(networkData, (DistributedVirtualPort.Setting)pv.value, dvsData);
                    continue;
                }
                if (!pv.propertyName.equals("isUplinkPortgroup") || !(pv.value instanceof Boolean)) continue;
                networkData.isUplink = (Boolean)pv.value;
            }
        }
    }

    private void populatePortConfigSettings(NetworkSelectorPortgroupData networkData, DistributedVirtualPort.Setting portSetting, NetworkSelectorDvsData dvsData) {
        if (portSetting == null || networkData == null) {
            return;
        }
        VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy vmwarePolicy = null;
        if (portSetting instanceof VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy) {
            vmwarePolicy = (VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy)portSetting;
        }
        if (vmwarePolicy != null) {
            if (vmwarePolicy.securityPolicy != null) {
                if (vmwarePolicy.securityPolicy.allowPromiscuous != null) {
                    networkData.securityAllowPromiscuous = vmwarePolicy.securityPolicy.allowPromiscuous.value;
                }
                if (vmwarePolicy.securityPolicy.macChanges != null) {
                    networkData.securityMacChanges = vmwarePolicy.securityPolicy.macChanges.value;
                }
                if (vmwarePolicy.securityPolicy.forgedTransmits != null) {
                    networkData.securityForgedTransmits = vmwarePolicy.securityPolicy.forgedTransmits.value;
                }
            }
            if (vmwarePolicy.uplinkTeamingPolicy != null) {
                if (vmwarePolicy.uplinkTeamingPolicy.policy != null) {
                    networkData.failoverLoadBalancing = vmwarePolicy.uplinkTeamingPolicy.policy.value;
                }
                if (vmwarePolicy.uplinkTeamingPolicy.failureCriteria != null) {
                    networkData.failoverFailureDetection = vmwarePolicy.uplinkTeamingPolicy.failureCriteria.checkBeacon.value;
                }
                if (vmwarePolicy.uplinkTeamingPolicy.notifySwitches != null) {
                    networkData.failoverNotifySwitches = vmwarePolicy.uplinkTeamingPolicy.notifySwitches.value;
                }
                if (vmwarePolicy.uplinkTeamingPolicy.rollingOrder != null) {
                    networkData.failoverFailback = vmwarePolicy.uplinkTeamingPolicy.rollingOrder.value;
                }
                if (vmwarePolicy.uplinkTeamingPolicy.uplinkPortOrder != null) {
                    if (vmwarePolicy.uplinkTeamingPolicy.uplinkPortOrder.activeUplinkPort != null) {
                        networkData.failoverActiveUplinksText = NetworkSelectorUtil.convertArrayToString(vmwarePolicy.uplinkTeamingPolicy.uplinkPortOrder.activeUplinkPort, UPLINKS_DELIMITER);
                    }
                    if (vmwarePolicy.uplinkTeamingPolicy.uplinkPortOrder.standbyUplinkPort != null) {
                        networkData.failoverStandbyUplinksText = NetworkSelectorUtil.convertArrayToString(vmwarePolicy.uplinkTeamingPolicy.uplinkPortOrder.standbyUplinkPort, UPLINKS_DELIMITER);
                    }
                    networkData.failoverUnusedUplinksText = this.getUnusedUplinkText(dvsData, vmwarePolicy.uplinkTeamingPolicy.uplinkPortOrder);
                }
            }
            if (vmwarePolicy.ipfixEnabled != null) {
                networkData.monitoringStatus = vmwarePolicy.ipfixEnabled.value;
            }
            if (vmwarePolicy.blocked != null) {
                networkData.portBlockingStatus = vmwarePolicy.blocked.value;
            }
            if (vmwarePolicy.vlan != null) {
                this.populateVlanData(networkData, dvsData, vmwarePolicy.vlan);
            }
        }
        if (portSetting.inShapingPolicy != null) {
            if (portSetting.inShapingPolicy.enabled != null) {
                networkData.trafficShapingInStatus = portSetting.inShapingPolicy.enabled.value;
            }
            if (portSetting.inShapingPolicy.averageBandwidth != null) {
                networkData.trafficShapingInAvgBw = portSetting.inShapingPolicy.averageBandwidth.value;
            }
            if (portSetting.inShapingPolicy.peakBandwidth != null) {
                networkData.trafficShapingInPeakBw = portSetting.inShapingPolicy.peakBandwidth.value;
            }
            if (portSetting.inShapingPolicy.burstSize != null) {
                networkData.trafficShapingInBurstSize = portSetting.inShapingPolicy.burstSize.value;
            }
        }
        if (portSetting.outShapingPolicy != null) {
            if (portSetting.outShapingPolicy.enabled != null) {
                networkData.trafficShapingOutStatus = portSetting.outShapingPolicy.enabled.value;
            }
            if (portSetting.outShapingPolicy.averageBandwidth != null) {
                networkData.trafficShapingOutAvgBw = portSetting.outShapingPolicy.averageBandwidth.value;
            }
            if (portSetting.outShapingPolicy.peakBandwidth != null) {
                networkData.trafficShapingOutPeakBw = portSetting.outShapingPolicy.peakBandwidth.value;
            }
            if (portSetting.outShapingPolicy.burstSize != null) {
                networkData.trafficShapingOutBurstSize = portSetting.outShapingPolicy.burstSize.value;
            }
        }
        this.populateNetworkResoucePoolData(networkData, dvsData, portSetting.networkResourcePoolKey.value);
    }

    private void populateVlanData(NetworkSelectorPortgroupData ns, NetworkSelectorDvsData dvsData, VmwareDistributedVirtualSwitch.VlanSpec vlanSpec) {
        if (vlanSpec instanceof VmwareDistributedVirtualSwitch.PvlanSpec) {
            VmwareDistributedVirtualSwitch.PvlanSpec pvlanSpec = (VmwareDistributedVirtualSwitch.PvlanSpec)vlanSpec;
            ns.vlanType = "privateVlan";
            ns.vlanId = "";
            if (dvsData != null && !ArrayUtil.isNullOrEmpty((Object[])dvsData.pvlanConfig)) {
                for (VmwareDistributedVirtualSwitch.PvlanMapEntry pvlanMapEntry : dvsData.pvlanConfig) {
                    if (pvlanMapEntry.secondaryVlanId != pvlanSpec.pvlanId) continue;
                    ns.vlanId = Integer.toString(pvlanMapEntry.primaryVlanId);
                    ns.secondaryVlanId = Integer.toString(pvlanMapEntry.secondaryVlanId);
                    ns.pvlanType = pvlanMapEntry.pvlanType;
                }
            }
        } else if (vlanSpec instanceof VmwareDistributedVirtualSwitch.TrunkVlanSpec) {
            VmwareDistributedVirtualSwitch.TrunkVlanSpec trunkVlanSpec = (VmwareDistributedVirtualSwitch.TrunkVlanSpec)vlanSpec;
            ns.vlanType = "vlanTrunk";
            ns.vlanId = NetworkSelectorPropertyProvider.formatVlanTrunkRange(trunkVlanSpec.vlanId);
        } else if (vlanSpec instanceof VmwareDistributedVirtualSwitch.VlanIdSpec) {
            VmwareDistributedVirtualSwitch.VlanIdSpec vlanIdSpec = (VmwareDistributedVirtualSwitch.VlanIdSpec)vlanSpec;
            ns.vlanType = "vlanAccess";
            ns.vlanId = Integer.toString(vlanIdSpec.vlanId);
        }
    }

    private static String formatVlanTrunkRange(NumericRange[] vlanTrunkRange) {
        StringBuilder vlanId = new StringBuilder();
        if (!ArrayUtil.isNullOrEmpty((Object[])vlanTrunkRange)) {
            for (int i = 0; i < vlanTrunkRange.length; ++i) {
                NumericRange nr = vlanTrunkRange[i];
                if (nr != null) {
                    if (nr.start == nr.end) {
                        vlanId.append(nr.start);
                    } else {
                        vlanId.append(nr.start);
                        vlanId.append("-");
                        vlanId.append(nr.end);
                    }
                } else {
                    _logger.error((Object)"Null NumericRange detected!");
                }
                if (i >= vlanTrunkRange.length - 1) continue;
                vlanId.append(UPLINKS_DELIMITER);
            }
        }
        return vlanId.toString();
    }

    private String getUnusedUplinkText(NetworkSelectorDvsData dvsData, VmwareDistributedVirtualSwitch.UplinkPortOrderPolicy policy) {
        if (policy == null || dvsData == null) {
            return null;
        }
        HashSet<String> usedUplinks = new HashSet<String>();
        ArrayList<String> result = new ArrayList<String>();
        if (!ArrayUtil.isNullOrEmpty((Object[])policy.activeUplinkPort)) {
            for (String uplink : policy.activeUplinkPort) {
                usedUplinks.add(uplink);
            }
        }
        if (!ArrayUtil.isNullOrEmpty((Object[])policy.standbyUplinkPort)) {
            for (String uplink : policy.standbyUplinkPort) {
                usedUplinks.add(uplink);
            }
        }
        if (!ArrayUtil.isNullOrEmpty((Object[])dvsData.uplinkPortName)) {
            for (String uplink : dvsData.uplinkPortName) {
                if (usedUplinks.contains(uplink)) continue;
                result.add(uplink);
            }
        }
        return NetworkSelectorUtil.convertArrayToString(result.toArray(new String[result.size()]), UPLINKS_DELIMITER);
    }

    private void populatePgToDvsMap(PropertyValue[] properties, Map<ManagedObjectReference, ManagedObjectReference> pgToDvsMap) {
        if (!ArrayUtil.isNullOrEmpty((Object[])properties)) {
            for (PropertyValue pv : properties) {
                if (!pv.propertyName.equals(DVS_PROPERTY) || !(pv.value instanceof ManagedObjectReference)) continue;
                pgToDvsMap.put((ManagedObjectReference)pv.resourceObject, (ManagedObjectReference)pv.value);
            }
        }
    }

    private void updateDvsMap(PropertyValue[] properties, Map<ManagedObjectReference, NetworkSelectorDvsData> dvsMap) {
        Object[] dvsProperties;
        ArrayList<ManagedObjectReference> missingDvses = this.getRefsForMissingDvses(properties, dvsMap);
        if (!ArrayUtil.isNullOrEmpty(missingDvses) && !ArrayUtil.isNullOrEmpty((Object[])(dvsProperties = this.retrieveDvsProperties(missingDvses.toArray(new ManagedObjectReference[missingDvses.size()]))))) {
            for (Object pv : dvsProperties) {
                ManagedObjectReference dvsRef = (ManagedObjectReference)((PropertyValue)pv).resourceObject;
                NetworkSelectorDvsData dvsData = null;
                dvsData = dvsMap.get(dvsRef);
                if (dvsData == null) {
                    dvsData = new NetworkSelectorDvsData();
                    dvsMap.put(dvsRef, dvsData);
                }
                if (((PropertyValue)pv).propertyName.equals("name") && ((PropertyValue)pv).value instanceof String) {
                    dvsData.name = (String)((PropertyValue)pv).value;
                    continue;
                }
                if (((PropertyValue)pv).propertyName.equals(DVS_UUID_PROPERTY) && ((PropertyValue)pv).value instanceof String) {
                    dvsData.uuid = (String)((PropertyValue)pv).value;
                    continue;
                }
                if (((PropertyValue)pv).propertyName.equals(DVS_NETWORK_RESOURCE_POOL_PROPERTY) && ((PropertyValue)pv).value instanceof NetworkResourcePool[]) {
                    dvsData.networkResourcePool = (NetworkResourcePool[])((PropertyValue)pv).value;
                    continue;
                }
                if (((PropertyValue)pv).propertyName.equals(DVS_UPLINK_PORT_POLICY_PROPERTY) && ((PropertyValue)pv).value instanceof String[]) {
                    dvsData.uplinkPortName = (String[])((PropertyValue)pv).value;
                    continue;
                }
                if (!((PropertyValue)pv).propertyName.equals(DVS_PVLAN_CONFIG) || !(((PropertyValue)pv).value instanceof VmwareDistributedVirtualSwitch.PvlanMapEntry[])) continue;
                dvsData.pvlanConfig = (VmwareDistributedVirtualSwitch.PvlanMapEntry[])((PropertyValue)pv).value;
            }
        }
    }

    private ArrayList<ManagedObjectReference> getRefsForMissingDvses(PropertyValue[] properties, Map<ManagedObjectReference, NetworkSelectorDvsData> dvsMap) {
        ArrayList<ManagedObjectReference> missingDvses = new ArrayList<ManagedObjectReference>();
        if (!ArrayUtil.isNullOrEmpty((Object[])properties)) {
            for (PropertyValue pv : properties) {
                ManagedObjectReference dvsRef;
                if (!pv.propertyName.equals(DVS_PROPERTY) || !(pv.value instanceof ManagedObjectReference) || dvsMap.get(dvsRef = (ManagedObjectReference)pv.value) != null) continue;
                missingDvses.add(dvsRef);
            }
        }
        return missingDvses;
    }

    private PropertyValue[] retrieveDvsProperties(ManagedObjectReference[] dvsRefs) {
        PropertyValue[] propertyValues = null;
        try {
            propertyValues = QueryUtil.getProperties((DataService)this._dataService, (Object[])dvsRefs, (String[])new String[]{"name", DVS_UUID_PROPERTY, DVS_NETWORK_RESOURCE_POOL_PROPERTY, DVS_UPLINK_PORT_POLICY_PROPERTY, DVS_PVLAN_CONFIG});
        }
        catch (Exception e) {
            _logger.error((Object)("Retrieval of dvs properties failed: " + e.getLocalizedMessage()));
        }
        return propertyValues;
    }

    private Collection<NetworkSelectorPortgroupData> retrieveStandardNetworkProperties(ManagedObjectReference[] networks, boolean includeExtendedProperties) {
        if (ArrayUtil.isNullOrEmpty((Object[])networks)) {
            return Collections.emptyList();
        }
        Object[] propertyValues = null;
        try {
            String[] properties = includeExtendedProperties ? STD_NETWORK_PROPS_ADVANCED : STD_NETWORK_PROPS_BASIC;
            propertyValues = QueryUtil.getProperties((DataService)this._dataService, (Object[])networks, (String[])properties);
        }
        catch (Exception e) {
            _logger.error((Object)"Retrieval of standard network properties failed.", (Throwable)e);
        }
        HashMap<String, NetworkSelectorPortgroupData> standardNetworksData = new HashMap<String, NetworkSelectorPortgroupData>();
        if (!ArrayUtil.isNullOrEmpty((Object[])propertyValues)) {
            for (Object pv : propertyValues) {
                if (((PropertyValue)pv).resourceObject == null || !(((PropertyValue)pv).resourceObject instanceof ManagedObjectReference)) continue;
                NetworkSelectorPortgroupData networkData = (NetworkSelectorPortgroupData)standardNetworksData.get(((PropertyValue)pv).resourceObject.toString());
                if (networkData == null) {
                    networkData = new NetworkSelectorPortgroupData();
                    networkData.networkRef = (ManagedObjectReference)((PropertyValue)pv).resourceObject;
                    networkData.isStandardNetwork = true;
                    standardNetworksData.put(((PropertyValue)pv).resourceObject.toString(), networkData);
                }
                if ("name".equals(((PropertyValue)pv).propertyName) && ((PropertyValue)pv).value instanceof String) {
                    networkData.name = (String)((PropertyValue)pv).value;
                    continue;
                }
                if (ACCESSIBLE_PROPERTY.equals(((PropertyValue)pv).propertyName) && ((PropertyValue)pv).value instanceof Boolean) {
                    networkData.isAccessible = (Boolean)((PropertyValue)pv).value;
                    continue;
                }
                if (VM_LENGTH_PROPERTY.equals(((PropertyValue)pv).propertyName) && ((PropertyValue)pv).value instanceof Integer) {
                    networkData.vmCount = (Integer)((PropertyValue)pv).value;
                    continue;
                }
                if (!IP_POOL_NAME_PROPERTY.equals(((PropertyValue)pv).propertyName) || !(((PropertyValue)pv).value instanceof String)) continue;
                networkData.ipPoolName = (String)((PropertyValue)pv).value;
            }
        }
        return standardNetworksData.values();
    }

    private Collection<NetworkSelectorPortgroupData> retrieveOpaqueNetworkProperties(ManagedObjectReference[] opaqueNetworks, boolean includeExtendedProperties, boolean includeOpaqueNetworkTypes) {
        if (ArrayUtil.isNullOrEmpty((Object[])opaqueNetworks)) {
            return Collections.emptyList();
        }
        Object[] propertyValues = null;
        try {
            String[] properties = includeExtendedProperties ? OPAQUE_NETWORK_PROPS_ADVANCED : (includeOpaqueNetworkTypes ? (String[])ArrayUtils.add((Object[])OPAQUE_NETWORK_PROPS_BASIC, (Object)OPAQUE_NETWORK_TYPE_PROPERTY) : OPAQUE_NETWORK_PROPS_BASIC);
            propertyValues = QueryUtil.getProperties((DataService)this._dataService, (Object[])opaqueNetworks, (String[])properties);
        }
        catch (Exception e) {
            _logger.error((Object)("Retrieval of opaque network properties failed:" + e.getLocalizedMessage()));
        }
        if (ArrayUtil.isNullOrEmpty((Object[])propertyValues)) {
            return Collections.emptyList();
        }
        HashMap<String, NetworkSelectorPortgroupData> opaqueNetworksData = new HashMap<String, NetworkSelectorPortgroupData>();
        for (Object pv : propertyValues) {
            if (((PropertyValue)pv).resourceObject == null || !(((PropertyValue)pv).resourceObject instanceof ManagedObjectReference)) continue;
            NetworkSelectorPortgroupData networkData = (NetworkSelectorPortgroupData)opaqueNetworksData.get(((PropertyValue)pv).resourceObject.toString());
            if (networkData == null) {
                networkData = new NetworkSelectorPortgroupData();
                networkData.networkRef = (ManagedObjectReference)((PropertyValue)pv).resourceObject;
                networkData.isOpaqueNetwork = true;
                opaqueNetworksData.put(((PropertyValue)pv).resourceObject.toString(), networkData);
            }
            if ("name".equals(((PropertyValue)pv).propertyName) && ((PropertyValue)pv).value instanceof String) {
                networkData.name = (String)((PropertyValue)pv).value;
                continue;
            }
            if (ACCESSIBLE_PROPERTY.equals(((PropertyValue)pv).propertyName) && ((PropertyValue)pv).value instanceof Boolean) {
                networkData.isAccessible = (Boolean)((PropertyValue)pv).value;
                continue;
            }
            if (VM_LENGTH_PROPERTY.equals(((PropertyValue)pv).propertyName) && ((PropertyValue)pv).value instanceof Integer) {
                networkData.vmCount = (Integer)((PropertyValue)pv).value;
                continue;
            }
            if (IP_POOL_NAME_PROPERTY.equals(((PropertyValue)pv).propertyName) && ((PropertyValue)pv).value instanceof String) {
                networkData.ipPoolName = (String)((PropertyValue)pv).value;
                continue;
            }
            if (!OPAQUE_NETWORK_TYPE_PROPERTY.equals(((PropertyValue)pv).propertyName) || !(((PropertyValue)pv).value instanceof String)) continue;
            networkData.opaqueNetworkType = (String)((PropertyValue)pv).value;
            if (!NSX_NETWORK_TYPE_PROPERTY_VALUE.equals(networkData.opaqueNetworkType)) continue;
            networkData.isNsxNetwork = true;
        }
        return opaqueNetworksData.values();
    }

    private static class NetworkMatchFactory {
        private final HashMap<String, List<ManagedObjectReference>> networksByName = new HashMap();

        public NetworkMatchFactory(NetworkSelectorPortgroupData[] networks) {
            this.initializeNetworksMap(networks);
        }

        private void initializeNetworksMap(NetworkSelectorPortgroupData[] networks) {
            if (!ArrayUtil.isNullOrEmpty((Object[])networks)) {
                for (NetworkSelectorPortgroupData network : networks) {
                    List<ManagedObjectReference> networkMorefs = this.networksByName.get(network.name);
                    if (networkMorefs == null) {
                        networkMorefs = new ArrayList<ManagedObjectReference>();
                        this.networksByName.put(network.name, networkMorefs);
                    }
                    networkMorefs.add(network.networkRef);
                }
            }
        }

        public NetworkSelectorNetworkMatch newNetworkMatch(NetworkSelectorPortgroupData networkData) {
            List<ManagedObjectReference> destinationNetworks = this.networksByName.get(networkData.name);
            if (destinationNetworks == null) {
                if (ManagedObjectUtil.isOfType((ManagedObjectReference)networkData.networkRef, Network.class)) {
                    return new NetworkSelectorNetworkMatch(networkData.networkRef, networkData.networkRef);
                }
                if (this.networksByName.size() == 1 && this.networksByName.values().iterator().next().size() == 1) {
                    return new NetworkSelectorNetworkMatch(networkData.networkRef, this.networksByName.values().iterator().next().get(0));
                }
                return new NetworkSelectorNetworkMatch(networkData.networkRef, null);
            }
            ManagedObjectReference destinationNetworkMoref = null;
            for (ManagedObjectReference mor : destinationNetworks) {
                if (!mor.equals((Object)networkData.networkRef)) continue;
                destinationNetworkMoref = mor;
                break;
            }
            if (destinationNetworkMoref != null) {
                return new NetworkSelectorNetworkMatch(networkData.networkRef, destinationNetworkMoref);
            }
            return new NetworkSelectorNetworkMatch(networkData.networkRef, destinationNetworks.get(0));
        }
    }
}

