/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.store.impl;

import com.vmware.vim.zeppelin.cr.auth.CRAccessControl;
import com.vmware.vim.zeppelin.cr.auth.CRAuthManager;
import com.vmware.vim.zeppelin.cr.auth.CRUser;
import com.vmware.vise.store.AuthService;
import com.vmware.vise.store.CRUtil;
import com.vmware.vise.store.GroupPermission;
import java.util.Set;

public class AuthManagerAdapter
implements CRAuthManager {
    private AuthService _authService;

    public AuthManagerAdapter() {
    }

    public AuthManagerAdapter(AuthService authService) {
        this.setAuthService(authService);
    }

    public void setAuthService(AuthService authService) {
        this._authService = authService;
    }

    public CRUser getCurrentUser() {
        CRUser cRUser = null;
        if (this._authService != null) {
            cRUser = CRUtil.getCRUser(this._authService.getCurrentUser());
        }
        return cRUser;
    }

    public CRUser getUser(String string, boolean bl) {
        CRUser cRUser = null;
        if (this._authService != null) {
            cRUser = CRUtil.getCRUser(this._authService.getUser(string));
        }
        return cRUser;
    }

    public boolean isAllowed(CRUser cRUser, Set<CRAccessControl> set, int n) {
        if (cRUser == null && (cRUser = this.getCurrentUser()) == null) {
            throw new RuntimeException("cannot obtain current user.");
        }
        if (CRAccessControl.PERMISSION_READ_ONLY == n) {
            return true;
        }
        if (set == null) {
            return false;
        }
        for (CRAccessControl cRAccessControl : set) {
            CRUser cRUser2 = cRAccessControl.getUser();
            String string = cRUser2.getName();
            if (cRUser2.isGroup() && string.equals(GroupPermission.ALL.getName())) {
                return true;
            }
            if (!string.equals(cRUser.getName()) || cRAccessControl.getPermission() < n) continue;
            return true;
        }
        return false;
    }
}

