/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.store.impl;

import com.vmware.vim.zeppelin.cr.CRSession;
import com.vmware.vim.zeppelin.cr.ContentRepoService;
import com.vmware.vim.zeppelin.cr.auth.CRAccessControl;
import com.vmware.vim.zeppelin.cr.auth.CRUser;
import com.vmware.vim.zeppelin.cr.exception.CRAccessDeniedException;
import com.vmware.vim.zeppelin.cr.fs.CRFileData;
import com.vmware.vim.zeppelin.cr.node.CRFileNode;
import com.vmware.vim.zeppelin.cr.node.CRFolderNode;
import com.vmware.vim.zeppelin.cr.node.CRNode;
import com.vmware.vim.zeppelin.cr.search.CRSearchCriteria;
import com.vmware.vim.zeppelin.cr.search.CRSearchQuery;
import com.vmware.vim.zeppelin.cr.versionctrl.CRChangeset;
import com.vmware.vim.zeppelin.cr.versionctrl.CRFileRevision;
import com.vmware.vise.store.Access;
import com.vmware.vise.store.AuxillaryUserData;
import com.vmware.vise.store.CRUtil;
import com.vmware.vise.store.GroupPermission;
import com.vmware.vise.store.NoPermissionException;
import com.vmware.vise.store.Permission;
import com.vmware.vise.store.PersistenceStore;
import com.vmware.vise.store.SearchCondition;
import com.vmware.vise.store.SearchCriteria;
import com.vmware.vise.store.User;
import com.vmware.vise.store.UserData;
import com.vmware.vise.store.UserDataMetadata;
import com.vmware.vise.store.UserPermission;
import com.vmware.vise.store.impl.AuthManagerAdapter;
import com.vmware.vise.store.internal.Config;
import com.vmware.vise.util.ObjectUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PersistenceStoreImpl
implements PersistenceStore {
    private static final String PERSISTENCE_STORE_BASEDIR = "PS_BASEDIR";
    private static final String FS_DIR = "FS_DIR";
    private static final String SERVER_GUIDS = "guids";
    private ContentRepoService _crService;
    private Map<String, Object> _config;
    private String _namespace = null;
    private static Log _logger = LogFactory.getLog(PersistenceStoreImpl.class);

    @Override
    public void setNamespace(String string) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("Invalid namespace");
        }
        this._namespace = string;
    }

    public void setCrService(ContentRepoService contentRepoService) {
        this._crService = contentRepoService;
    }

    @Override
    public void setConfiguration(Map<String, Object> map) {
        this._config = map;
    }

    @Override
    public void init() {
        String string = System.getProperty(PERSISTENCE_STORE_BASEDIR);
        if (string != null) {
            this._config.put(FS_DIR, String.format("%s%s%s", string, File.separator, this._config.get(FS_DIR)));
        }
        this._crService.setConfiguration(this._config);
        this._crService.init();
    }

    @Override
    public void close() {
        this._crService.close();
    }

    @Override
    public UserData create(User user, String string, UserData userData) throws NoPermissionException {
        CRFileData cRFileData = new CRFileData(ObjectUtil.toByteArray((Object)userData.value));
        CRUser cRUser = CRUtil.getCRUser(user);
        CRSession cRSession = this._crService.newSession(cRUser);
        try {
            CRChangeset cRChangeset = cRSession.beginTransaction(null);
            String string2 = this.getQualifiedPath(user.getName(), string);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            if (userData.metadata != null) {
                hashMap.putAll(userData.metadata.additionalData);
            }
            List<CRAccessControl> list = this.buildACL(user, userData.sharedPermissions);
            cRChangeset.addFile(string2, list, cRFileData, hashMap);
            CRFileNode cRFileNode = cRSession.getFileNode(string2);
            Permission permission = this.getPermission(user, (CRNode)cRFileNode);
            CRFileRevision cRFileRevision = cRFileNode.getLatestRevision();
            if (cRFileRevision.getFileData() != null) {
                userData.value = new String(cRFileRevision.getFileData().getObjData());
            }
            userData.metadata = this.createMetadata(user, cRFileNode, cRFileRevision, permission);
            userData.sharedPermissions = this.getSharedPermissions(user, (CRNode)cRFileNode);
            cRSession.endTransaction();
        }
        catch (CRAccessDeniedException cRAccessDeniedException) {
            _logger.error((Object)("Not enough permission to persist user data: " + cRAccessDeniedException.getMessage()), (Throwable)cRAccessDeniedException);
            if (cRSession != null) {
                cRSession.discardTransaction();
            }
            throw new NoPermissionException(cRAccessDeniedException.getMessage());
        }
        catch (Exception exception) {
            _logger.error((Object)("Failed to persist user data: " + exception.getMessage()), (Throwable)exception);
            if (cRSession != null) {
                cRSession.discardTransaction();
            }
            throw new NoPermissionException(exception);
        }
        finally {
            if (cRSession != null) {
                cRSession.logout();
            }
        }
        return userData;
    }

    @Override
    public UserData read(User user, String string, String string2, List<String> list) throws NoPermissionException {
        UserData userData = null;
        CRUser cRUser = CRUtil.getCRUser(user);
        CRSession cRSession = this._crService.newSession(cRUser);
        try {
            cRSession.beginTransaction(null);
            String string3 = this.getQualifiedPath(user.getName(), string);
            CRFileNode cRFileNode = cRSession.getFileNode(string3);
            if (cRFileNode == null && !GroupPermission.ALL.group.equals(user.getName())) {
                string3 = this.getQualifiedPath(GroupPermission.ALL.group, string);
                cRFileNode = cRSession.getFileNode(string3);
            }
            if (cRFileNode == null) {
                cRSession.endTransaction();
                UserData userData2 = userData;
                return userData2;
            }
            Permission permission = this.getPermission(user, (CRNode)cRFileNode);
            if (permission.access == Access.None) {
                cRSession.endTransaction();
                UserData userData3 = userData;
                return userData3;
            }
            CRFileRevision cRFileRevision = null;
            cRFileRevision = string2 == null ? cRFileNode.getLatestRevision() : cRSession.getRevision(string3, Integer.parseInt(string2));
            if (cRFileRevision == null) {
                cRSession.endTransaction();
                UserData userData4 = userData;
                return userData4;
            }
            String string4 = cRFileRevision.getFileMetaDataForKey(SERVER_GUIDS);
            if (!this.matchServerGuids(list, string4)) {
                UserData userData5 = userData;
                return userData5;
            }
            userData = new UserData();
            if (cRFileRevision.getFileData() != null) {
                userData.value = ObjectUtil.fromByteArray((byte[])cRFileRevision.getFileData().getObjData());
            }
            userData.metadata = this.createMetadata(user, cRFileNode, cRFileRevision, permission);
            userData.sharedPermissions = this.getSharedPermissions(user, (CRNode)cRFileNode);
            cRSession.endTransaction();
        }
        catch (CRAccessDeniedException cRAccessDeniedException) {
            _logger.error((Object)("Not enough permission to read user data: " + cRAccessDeniedException.getMessage()), (Throwable)cRAccessDeniedException);
            if (cRSession != null) {
                cRSession.discardTransaction();
            }
            throw new NoPermissionException(cRAccessDeniedException.getMessage());
        }
        catch (Exception exception) {
            _logger.error((Object)("Failed to retrieve user data: " + exception.getMessage()), (Throwable)exception);
            if (cRSession != null) {
                cRSession.discardTransaction();
            }
            throw new NoPermissionException(exception.getMessage());
        }
        finally {
            if (cRSession != null) {
                cRSession.logout();
            }
        }
        return userData;
    }

    @Override
    public UserData[] search(User user, String string, SearchCriteria searchCriteria, List<String> list) throws NoPermissionException {
        CRSearchQuery cRSearchQuery = this.buildSearchQuery(searchCriteria);
        ArrayList<Object> arrayList = this.runSearch(user, string, cRSearchQuery, list, false);
        return arrayList.toArray(new UserData[0]);
    }

    @Override
    public UserDataMetadata[] searchForMetadata(User user, String string, SearchCriteria searchCriteria, List<String> list) throws NoPermissionException {
        CRSearchQuery cRSearchQuery = this.buildSearchQuery(searchCriteria);
        ArrayList<Object> arrayList = this.runSearch(user, string, cRSearchQuery, list, true);
        return arrayList.toArray(new UserDataMetadata[0]);
    }

    @Override
    public void save(User user, UserData userData, boolean bl, List<String> list) throws NoPermissionException {
        CRFileData cRFileData = new CRFileData(ObjectUtil.toByteArray((Object)userData.value));
        if (userData.sharedPermissions != null) {
            for (Object object : userData.sharedPermissions) {
                if (!((Permission)object).isGroup() || !GroupPermission.ALL.group.equals(((Permission)object).getName())) continue;
                user = new User(((Permission)object).getName(), ((Permission)object).isGroup());
                break;
            }
        }
        CRUser cRUser = CRUtil.getCRUser(user);
        CRSession cRSession = this._crService.newSession(cRUser);
        try {
            Object object;
            CRChangeset cRChangeset = cRSession.beginTransaction(null);
            object = this.getQualifiedPath(user.getName(), userData.metadata.uid);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            if (userData.metadata != null && userData.metadata.additionalData != null) {
                hashMap.putAll(userData.metadata.additionalData);
            }
            if (list != null && !list.isEmpty()) {
                hashMap.put(SERVER_GUIDS, list.toString());
            }
            if (!cRSession.exists((String)object)) {
                List<CRAccessControl> list2 = this.buildACL(user, userData.sharedPermissions);
                cRChangeset.addFile((String)object, list2, cRFileData, hashMap);
            } else {
                Permission permission = this.getPermission(user, (CRNode)cRSession.getFileNode((String)object));
                if (permission.access != Access.ReadWrite) {
                    throw new NoPermissionException("Not enough permission for the path " + (String)object);
                }
                cRChangeset.updateFile((String)object, cRFileData, hashMap, bl);
            }
            cRSession.endTransaction();
        }
        catch (CRAccessDeniedException cRAccessDeniedException) {
            _logger.error((Object)("Not enough permission to persist user data: " + cRAccessDeniedException.getMessage()), (Throwable)cRAccessDeniedException);
            if (cRSession != null) {
                cRSession.discardTransaction();
            }
            throw new NoPermissionException(cRAccessDeniedException.getMessage());
        }
        catch (Exception exception) {
            _logger.error((Object)("Failed to persist user data: " + exception.getMessage()), (Throwable)exception);
            if (cRSession != null) {
                cRSession.discardTransaction();
            }
            throw new NoPermissionException(exception.getMessage());
        }
        finally {
            if (cRSession != null) {
                cRSession.logout();
            }
        }
    }

    @Override
    public void remove(User user, String string, String string2, List<String> list) throws NoPermissionException {
        CRUser cRUser = CRUtil.getCRUser(user);
        CRSession cRSession = this._crService.newSession(cRUser);
        try {
            CRChangeset cRChangeset = cRSession.beginTransaction(null);
            String string3 = this.getQualifiedPath(user.getName(), string);
            if (!cRSession.exists(string3)) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("Invalid path to remove " + string));
                }
                throw new IllegalArgumentException("Invalid path " + string);
            }
            CRFileNode cRFileNode = cRSession.getFileNode(string3);
            CRFileRevision cRFileRevision = string2 == null ? cRFileNode.getLatestRevision() : cRFileNode.getRevision(Integer.parseInt(string2));
            String string4 = cRFileRevision.getFileMetaDataForKey(SERVER_GUIDS);
            if (!this.matchServerGuids(list, string4)) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("Server guids doesn't match for path " + string));
                }
                throw new IllegalArgumentException("Invalid path " + string);
            }
            Permission permission = this.getPermission(user, (CRNode)cRSession.getFileNode(string3));
            if (permission.access != Access.ReadWrite) {
                throw new NoPermissionException("Not enough permission for the path " + string);
            }
            cRChangeset.deleteFile(string3);
            cRSession.endTransaction();
        }
        catch (CRAccessDeniedException cRAccessDeniedException) {
            _logger.error((Object)("Not enough permission to delete user data: " + cRAccessDeniedException.getMessage()), (Throwable)cRAccessDeniedException);
            if (cRSession != null) {
                cRSession.discardTransaction();
            }
            throw new NoPermissionException(cRAccessDeniedException.getMessage());
        }
        catch (Exception exception) {
            _logger.error((Object)("Failed to delete user data: " + exception.getMessage()), (Throwable)exception);
            if (cRSession != null) {
                cRSession.discardTransaction();
            }
            throw new NoPermissionException(exception.getMessage());
        }
        finally {
            if (cRSession != null) {
                cRSession.logout();
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ArrayList<Object> runSearch(User var1_1, String var2_2, CRSearchQuery var3_3, List<String> var4_4, boolean var5_5) throws NoPermissionException {
        block19: {
            block18: {
                block17: {
                    var10_7 = var12_6 = System.currentTimeMillis();
                    var8_8 = var12_6;
                    var6_9 = var12_6;
                    var14_10 = new ArrayList<Object>();
                    var15_11 = CRUtil.getCRUser(var1_1);
                    var16_12 = this._crService.newSession(var15_11);
                    var8_8 = System.currentTimeMillis();
                    try {
                        var16_12.beginTransaction(null);
                        var17_13 = CRNode.NODE_ROOT;
                        if (this._namespace != null) {
                            var17_13 = var17_13 + this._namespace;
                        }
                        if (!var16_12.exists(var17_13)) {
                            var16_12.endTransaction();
                            var18_16 = var14_10;
                            if (var16_12 == null) break block17;
                        }
                        ** GOTO lbl-1000
                    }
                    catch (CRAccessDeniedException var17_14) {
                        try {
                            PersistenceStoreImpl._logger.error((Object)("Not enough permission to read user data: " + var17_14.getMessage()), (Throwable)var17_14);
                            if (var16_12 == null) throw new NoPermissionException(var17_14.getMessage());
                            var16_12.discardTransaction();
                            throw new NoPermissionException(var17_14.getMessage());
                            catch (Exception var17_15) {
                                PersistenceStoreImpl._logger.error((Object)("Failed to retrieve user data: " + var17_15.getMessage()), (Throwable)var17_15);
                                if (var16_12 == null) throw new NoPermissionException(var17_15.getMessage());
                                var16_12.discardTransaction();
                                throw new NoPermissionException(var17_15.getMessage());
                            }
                        }
                        catch (Throwable var30_30) {
                            if (var16_12 != null) {
                                var16_12.logout();
                            }
                            if ((var12_6 = System.currentTimeMillis()) - var6_9 <= (long)Config.PERSISTENCE_STORE_READ_LOG_TIMEOUT) throw var30_30;
                            PersistenceStoreImpl._logger.info((Object)String.format("runSearch took too long (ms) = %d, user = %d, folders = %d, file processing = %d", new Object[]{var12_6 - var6_9, var8_8 - var6_9, var10_7 - var8_8, var12_6 - var10_7}));
                            throw var30_30;
                        }
                    }
                    var16_12.logout();
                }
                if ((var12_6 = System.currentTimeMillis()) - var6_9 <= (long)Config.PERSISTENCE_STORE_READ_LOG_TIMEOUT) return var18_16;
                PersistenceStoreImpl._logger.info((Object)String.format("runSearch took too long (ms) = %d, user = %d, folders = %d, file processing = %d", new Object[]{var12_6 - var6_9, var8_8 - var6_9, var10_7 - var8_8, var12_6 - var10_7}));
                return var18_16;
lbl-1000:
                // 1 sources

                {
                    var18_17 = var16_12.listFolders(var17_13, false);
                    if (var18_17 != null) ** GOTO lbl-1000
                    var16_12.endTransaction();
                    var19_18 = var14_10;
                    if (var16_12 == null) break block18;
                }
                var16_12.logout();
            }
            if ((var12_6 = System.currentTimeMillis()) - var6_9 <= (long)Config.PERSISTENCE_STORE_READ_LOG_TIMEOUT) return var19_18;
            PersistenceStoreImpl._logger.info((Object)String.format("runSearch took too long (ms) = %d, user = %d, folders = %d, file processing = %d", new Object[]{var12_6 - var6_9, var8_8 - var6_9, var10_7 - var8_8, var12_6 - var10_7}));
            return var19_18;
lbl-1000:
            // 1 sources

            {
                var10_7 = System.currentTimeMillis();
                for (CRFolderNode var20_20 : var18_17) {
                    var21_21 = this.getQualifiedPath(var20_20.getNodePath(), var2_2);
                    var22_22 = null;
                    if (!var16_12.exists(var21_21)) continue;
                    if (var16_12.isFile(var21_21)) {
                        var23_23 = var16_12.getFileNode(var21_21);
                        if (var23_23 != null) {
                            var22_22 = new ArrayList<Object>();
                            var22_22.add(var23_23);
                        }
                    } else {
                        var22_22 = var16_12.listFiles(var21_21, true, var3_3);
                    }
                    if (var22_22 == null) continue;
                    for (CRFileNode var24_24 : var22_22) {
                        var25_25 = this.getPermission(var1_1, (CRNode)var24_24);
                        if (var25_25.access == Access.None || (var26_26 = var24_24.getLatestRevision()) == null || !this.matchServerGuids(var4_4, var27_27 = var26_26.getFileMetaDataForKey("guids"))) continue;
                        var28_28 = this.createMetadata(var1_1, var24_24, var26_26, var25_25);
                        if (var5_5) {
                            var14_10.add(var28_28);
                            continue;
                        }
                        var29_29 = new UserData();
                        var29_29.metadata = var28_28;
                        if (var26_26.getFileData() != null) {
                            var29_29.value = ObjectUtil.fromByteArray((byte[])var26_26.getFileData().getObjData());
                        }
                        var29_29.sharedPermissions = this.getSharedPermissions(var1_1, (CRNode)var24_24);
                        var14_10.add(var29_29);
                    }
                }
                var16_12.endTransaction();
                if (var16_12 == null) break block19;
            }
            var16_12.logout();
        }
        if ((var12_6 = System.currentTimeMillis()) - var6_9 <= (long)Config.PERSISTENCE_STORE_READ_LOG_TIMEOUT) return var14_10;
        PersistenceStoreImpl._logger.info((Object)String.format("runSearch took too long (ms) = %d, user = %d, folders = %d, file processing = %d", new Object[]{var12_6 - var6_9, var8_8 - var6_9, var10_7 - var8_8, var12_6 - var10_7}));
        return var14_10;
    }

    @Override
    public void reset(User user) throws NoPermissionException {
        _logger.info((Object)String.format("The store is reset by the user %s at %s ", user.getName(), new Date()));
        CRUser cRUser = CRUtil.getCRUser(user);
        CRSession cRSession = this._crService.newSession(cRUser);
        try {
            CRChangeset cRChangeset = cRSession.beginTransaction(null);
            String string = this.getQualifiedPath(user.getName(), null);
            if (!cRSession.exists(string)) {
                cRSession.endTransaction();
                return;
            }
            CRFolderNode cRFolderNode = (CRFolderNode)cRSession.getFolderNode(string);
            if (cRFolderNode != null) {
                List list = cRSession.listFiles(cRFolderNode.getNodePath(), true);
                if (list == null) {
                    cRSession.endTransaction();
                    return;
                }
                for (CRFileNode cRFileNode : list) {
                    Permission permission = this.getPermission(user, (CRNode)cRFileNode);
                    if (permission.access != Access.ReadWrite) continue;
                    cRChangeset.deleteFile(cRFileNode.getNodePath());
                }
                this.removeFolders(user, cRSession, cRChangeset, cRFolderNode);
            }
            cRSession.endTransaction();
        }
        catch (CRAccessDeniedException cRAccessDeniedException) {
            _logger.error((Object)("Not enough permission to reset user data: " + cRAccessDeniedException.getMessage()), (Throwable)cRAccessDeniedException);
            if (cRSession != null) {
                cRSession.discardTransaction();
            }
            throw new NoPermissionException(cRAccessDeniedException.getMessage());
        }
        catch (Exception exception) {
            _logger.error((Object)("Failed to reset user data: " + exception.getMessage()), (Throwable)exception);
            if (cRSession != null) {
                cRSession.discardTransaction();
            }
            throw new NoPermissionException(exception.getMessage());
        }
        finally {
            if (cRSession != null) {
                cRSession.logout();
            }
        }
    }

    private void removeFolders(User user, CRSession cRSession, CRChangeset cRChangeset, CRFolderNode cRFolderNode) throws Exception {
        List list = cRSession.listFolders(cRFolderNode.getNodePath(), false);
        if (list == null || list.isEmpty()) {
            return;
        }
        for (CRFolderNode cRFolderNode2 : list) {
            Permission permission = this.getPermission(user, (CRNode)cRFolderNode2);
            if (permission.access != Access.ReadWrite) continue;
            String string = cRFolderNode2.getNodePath();
            if (cRSession.hasChildren(string)) {
                this.removeFolders(user, cRSession, cRChangeset, cRFolderNode2);
            }
            cRChangeset.deleteFolder(string);
        }
    }

    private UserDataMetadata createMetadata(User user, CRFileNode cRFileNode, CRFileRevision cRFileRevision, Permission permission) throws CRAccessDeniedException {
        UserDataMetadata userDataMetadata = new UserDataMetadata();
        userDataMetadata.uid = cRFileNode.getNodePath();
        userDataMetadata.permission = permission;
        if (cRFileRevision != null) {
            Map map = cRFileRevision.getFileMetaData();
            if (map != null) {
                userDataMetadata.additionalData = new HashMap<String, String>();
                userDataMetadata.additionalData.putAll(map);
            }
            userDataMetadata.auxillaryData = new AuxillaryUserData();
            userDataMetadata.auxillaryData.createTime = cRFileNode.getCreateTime();
            userDataMetadata.auxillaryData.modifyBy = user.getName();
            userDataMetadata.auxillaryData.modifyTime = cRFileNode.getModifyTime();
            userDataMetadata.auxillaryData.version = String.valueOf(cRFileRevision.getRevisionNumber());
        }
        return userDataMetadata;
    }

    private List<CRAccessControl> buildACL(User user, Permission[] permissionArray) {
        if (permissionArray == null || permissionArray.length == 0) {
            return null;
        }
        ArrayList<CRAccessControl> arrayList = new ArrayList<CRAccessControl>(1);
        AuthManagerAdapter authManagerAdapter = (AuthManagerAdapter)this._crService.getAuthManager();
        for (Permission permission : permissionArray) {
            if (permission.access == Access.None) continue;
            int n = permission.access == Access.ReadWrite ? CRAccessControl.PERMISSION_READ_WRITE : CRAccessControl.PERMISSION_READ_ONLY;
            CRUser cRUser = authManagerAdapter.getUser(permission.getName(), permission.isGroup());
            arrayList.add(new CRAccessControl(cRUser, n));
        }
        return arrayList;
    }

    private Permission getPermission(User user, CRNode cRNode) {
        String string = user.getName();
        Permission permission = this.newPermission(CRUtil.getCRUser(user), Access.None);
        if (cRNode == null) {
            return permission;
        }
        if (string.equals(GroupPermission.ALL.group) && user.isGroup()) {
            permission.access = Access.ReadWrite;
            return permission;
        }
        Set set = cRNode.getAcls();
        if (set == null) {
            return permission;
        }
        for (CRAccessControl cRAccessControl : set) {
            CRUser cRUser = cRAccessControl.getUser();
            String string2 = cRUser.getName();
            if (!string2.equals(GroupPermission.ALL.group) && !string.equals(string2)) continue;
            Access access = cRAccessControl.getPermission() == CRAccessControl.PERMISSION_READ_ONLY ? Access.ReadOnly : Access.ReadWrite;
            permission = this.newPermission(cRUser, access);
            break;
        }
        return permission;
    }

    private Permission newPermission(CRUser cRUser, Access access) {
        Permission permission = null;
        permission = !cRUser.isGroup() ? new UserPermission(cRUser.getName(), access) : new GroupPermission(cRUser.getName(), access);
        return permission;
    }

    private Permission[] getSharedPermissions(User user, CRNode cRNode) {
        HashSet<GroupPermission> hashSet = new HashSet<GroupPermission>();
        Set set = cRNode.getAcls();
        if (set == null) {
            return new Permission[0];
        }
        String string = user.getName();
        for (CRAccessControl cRAccessControl : set) {
            Permission permission = null;
            CRUser cRUser = cRAccessControl.getUser();
            if (string.equals(cRUser.getName())) continue;
            Access access = CRAccessControl.PERMISSION_READ_WRITE == cRAccessControl.getPermission() ? Access.ReadWrite : Access.ReadOnly;
            permission = cRUser.isGroup() ? new GroupPermission(cRUser.getName(), access) : new UserPermission(cRUser.getName(), access);
            hashSet.add((GroupPermission)permission);
        }
        return hashSet.toArray(new Permission[0]);
    }

    private CRSearchQuery buildSearchQuery(SearchCriteria searchCriteria) {
        CRSearchQuery cRSearchQuery = null;
        if (searchCriteria != null && searchCriteria.conditions != null) {
            cRSearchQuery = new CRSearchQuery();
            cRSearchQuery.setType(searchCriteria.matchAll ? CRSearchQuery.SEARCH_TYPE_ALL : CRSearchQuery.SEARCH_TYPE_ANY);
            for (SearchCondition searchCondition : searchCriteria.conditions) {
                CRSearchCriteria cRSearchCriteria = new CRSearchCriteria();
                cRSearchCriteria.setField(searchCondition.key);
                cRSearchCriteria.setModifier(searchCondition.op);
                cRSearchCriteria.setValue(searchCondition.value);
                cRSearchQuery.addCriteria(cRSearchCriteria);
            }
        }
        return cRSearchQuery;
    }

    private String getQualifiedPath(String string, String string2) {
        int n;
        String string3;
        int n2;
        if (string == null || string.length() == 0) {
            return string2 != null ? string2 : CRNode.NODE_ROOT;
        }
        if (string2 == null) {
            string2 = "";
        }
        String string4 = String.format("%s%s%s%s", CRNode.NODE_ROOT, this._namespace, CRNode.NODE_ROOT, string);
        if (string2.toLowerCase().startsWith(string4.toLowerCase())) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = n2 = string.startsWith(CRNode.NODE_ROOT) ? 1 : 0;
        if (this._namespace != null && !this._namespace.equals(string.substring(n2, Math.min(string.length(), n2 + this._namespace.length())))) {
            stringBuilder.append(CRNode.NODE_ROOT);
            stringBuilder.append(this._namespace);
        }
        if (!(string3 = string2.substring(n = string2.startsWith(CRNode.NODE_ROOT) ? 1 : 0, Math.min(string2.length(), n + string.length()))).equals(string)) {
            if (n2 == 0) {
                stringBuilder.append(CRNode.NODE_ROOT);
            }
            stringBuilder.append(string);
        }
        if (n == 0 && string2.length() > 0) {
            stringBuilder.append(CRNode.NODE_ROOT);
        }
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    private boolean matchServerGuids(List<String> list, String string) {
        if ((list == null || list.isEmpty()) && string == null) {
            return true;
        }
        if (list == null || list.isEmpty() || string == null) {
            return false;
        }
        String string2 = string.substring(1, string.length() - 1);
        String[] stringArray = string2.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].trim();
        }
        List<String> list2 = Arrays.asList(stringArray);
        return list.containsAll(list2);
    }
}

