/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.customfield;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.SortCriterion;
import com.vmware.cis.data.internal.adapters.customfield.CustomFieldRepository;
import com.vmware.cis.data.internal.adapters.customfield.VimCustomFieldsManagerRepository;
import com.vmware.cis.data.internal.provider.ext.aggregated.AggregatedModelLookup;
import com.vmware.cis.data.internal.provider.util.filter.PredicateEvaluator;
import com.vmware.cis.data.provider.DataProvider;
import com.vmware.vim.binding.impl.vmodl.TypeNameImpl;
import com.vmware.vim.binding.vim.CustomFieldsManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.TypeName;
import com.vmware.vim.vmomi.client.Client;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;

public final class CustomFieldDefDataProvider
implements DataProvider {
    private static final Map<String, String> _vimBaseTypeByDerivedType = CustomFieldDefDataProvider.getVimBaseTypeByDerivedType();
    private final CustomFieldRepository _customFields;
    private final String _serverGuid;
    private final AggregatedModelLookup _aggregatedModels;

    public CustomFieldDefDataProvider(Client vlsiClient, String serverGuid, AggregatedModelLookup aggregatedModels) {
        this(new VimCustomFieldsManagerRepository(vlsiClient), serverGuid, aggregatedModels);
    }

    CustomFieldDefDataProvider(CustomFieldRepository customFields, String serverGuid, AggregatedModelLookup aggregatedModels) {
        Validate.notNull((Object)customFields);
        Validate.notNull((Object)serverGuid);
        Validate.notNull((Object)aggregatedModels);
        this._customFields = customFields;
        this._serverGuid = serverGuid;
        this._aggregatedModels = aggregatedModels;
    }

    public ResultSet executeQuery(Query query) {
        this.validateQuery(query);
        Collection<CustomFieldsManager.FieldDef> customFieldDefs = this._customFields.getCustomFieldDefs();
        List properties = query.getProperties();
        Filter filter = query.getFilter();
        ResultSet.Builder resultSetBuilder = ResultSet.Builder.properties((List)properties);
        int totalCount = 0;
        for (CustomFieldsManager.FieldDef fieldDef : customFieldDefs) {
            if (!this.evalFilter(filter, fieldDef)) continue;
            ++totalCount;
            resultSetBuilder.item((Object)this.buildKey(fieldDef), this.getPropertyValues(properties, fieldDef));
        }
        if (query.getWithTotalCount()) {
            resultSetBuilder.totalCount(Integer.valueOf(totalCount));
        }
        return resultSetBuilder.build();
    }

    public QuerySchema getSchema() {
        LinkedHashMap<String, QuerySchema.PropertyInfo> props = new LinkedHashMap<String, QuerySchema.PropertyInfo>();
        props.put("CustomFieldDef/key", QuerySchema.PropertyInfo.forFilterableProperty((QuerySchema.PropertyType)QuerySchema.PropertyType.INT));
        props.put("CustomFieldDef/name", QuerySchema.PropertyInfo.forFilterableProperty((QuerySchema.PropertyType)QuerySchema.PropertyType.STRING));
        props.put("CustomFieldDef/managedObjectType", QuerySchema.PropertyInfo.forFilterableProperty((QuerySchema.PropertyType)QuerySchema.PropertyType.STRING));
        props.put("CustomFieldDef/applicableType", QuerySchema.PropertyInfo.forFilterableProperty((QuerySchema.PropertyType)QuerySchema.PropertyType.STRING));
        return QuerySchema.forProperties(props);
    }

    private ManagedObjectReference buildKey(CustomFieldsManager.FieldDef fieldDef) {
        assert (fieldDef != null);
        return new ManagedObjectReference("CustomFieldDef", "field-" + String.valueOf(fieldDef.getKey()), this._serverGuid);
    }

    private void validateQuery(Query query) {
        int limit;
        Validate.notNull((Object)query);
        for (String model : query.getResourceModels()) {
            if ("CustomFieldDef".equals(model)) continue;
            throw new IllegalArgumentException("Unsupported resource model: " + model);
        }
        List sortCriteria = query.getSortCriteria();
        if (!sortCriteria.isEmpty()) {
            for (SortCriterion sortCriterion : sortCriteria) {
                if (!sortCriterion.getProperty().equals("@modelKey")) {
                    throw new IllegalArgumentException("Cannot order by property: " + sortCriterion.getProperty());
                }
                if (sortCriterion.getSortDirection().equals((Object)SortCriterion.SortDirection.ASCENDING)) continue;
                throw new IllegalArgumentException("Sort direction not allowed: " + sortCriterion.getSortDirection());
            }
        }
        if ((limit = query.getLimit()) >= 0) {
            throw new IllegalArgumentException("Limit is not allowed.");
        }
        int offset = query.getOffset();
        if (offset > 0) {
            throw new IllegalArgumentException("Offset is not allowed.");
        }
    }

    private boolean evalFilter(Filter filter, CustomFieldsManager.FieldDef fieldDef) {
        if (filter == null) {
            return true;
        }
        LogicalOperator logicalOperator = filter.getOperator();
        List criteria = filter.getCriteria();
        switch (logicalOperator) {
            case AND: {
                return this.operatorAnd(criteria, fieldDef);
            }
            case OR: {
                return this.operatorOr(criteria, fieldDef);
            }
        }
        throw new IllegalArgumentException("Unsupported logical operator: " + logicalOperator);
    }

    private boolean operatorAnd(List<PropertyPredicate> criteria, CustomFieldsManager.FieldDef fieldDef) {
        for (PropertyPredicate propertyPredicate : criteria) {
            if (this.evalPredicate(propertyPredicate, fieldDef)) continue;
            return false;
        }
        return true;
    }

    private boolean operatorOr(List<PropertyPredicate> criteria, CustomFieldsManager.FieldDef fieldDef) {
        for (PropertyPredicate propertyPredicate : criteria) {
            if (!this.evalPredicate(propertyPredicate, fieldDef)) continue;
            return true;
        }
        return false;
    }

    private boolean evalPredicate(PropertyPredicate propertyPredicate, CustomFieldsManager.FieldDef fieldDef) {
        PropertyPredicate.ComparisonOperator operator = propertyPredicate.getOperator();
        if (operator != PropertyPredicate.ComparisonOperator.IN && operator != PropertyPredicate.ComparisonOperator.EQUAL && operator != PropertyPredicate.ComparisonOperator.UNSET) {
            throw new IllegalArgumentException("Operator " + operator + " is not supported.");
        }
        Object comparableValue = propertyPredicate.getComparableValue();
        String property = propertyPredicate.getProperty();
        Object propertyValue = this.getPropertyValue(property, fieldDef);
        if ("CustomFieldDef/applicableType".equals(property)) {
            if (operator != PropertyPredicate.ComparisonOperator.EQUAL) {
                throw new IllegalArgumentException("Operator " + operator + " is not supported for filtering by " + property + ".");
            }
            if (CustomFieldDefDataProvider.isCollection(comparableValue)) {
                throw new IllegalArgumentException("Collection comparable value for property " + property + " is not supported.");
            }
            if (propertyValue == null) {
                return true;
            }
            propertyPredicate = this.replaceComparableValueIfNeeded(propertyPredicate);
        }
        return PredicateEvaluator.eval((PropertyPredicate)propertyPredicate, (Object)propertyValue);
    }

    private PropertyPredicate replaceComparableValueIfNeeded(PropertyPredicate originalPredicate) {
        String parentModel;
        LinkedHashSet<String> newComparableValues = null;
        String model = (String)originalPredicate.getComparableValue();
        if (this.isAggregatedType(model)) {
            newComparableValues = new LinkedHashSet<String>(this._aggregatedModels.getChildrenOfAggregatedModel(model));
        }
        if ((parentModel = _vimBaseTypeByDerivedType.get(model)) != null) {
            newComparableValues = new LinkedHashSet<String>(Arrays.asList(model, parentModel));
        }
        this.addBaseModels(newComparableValues);
        String propertyName = originalPredicate.getProperty();
        return newComparableValues == null ? originalPredicate : new PropertyPredicate(propertyName, PropertyPredicate.ComparisonOperator.IN, newComparableValues);
    }

    private void addBaseModels(Set<String> models) {
        if (models == null || models.isEmpty()) {
            return;
        }
        Set<String> baseModels = this.getBaseModelsOf(models);
        while (!baseModels.isEmpty()) {
            models.addAll(baseModels);
            baseModels = this.getBaseModelsOf(baseModels);
        }
    }

    private Set<String> getBaseModelsOf(Set<String> models) {
        LinkedHashSet<String> baseModels = new LinkedHashSet<String>();
        for (String model : models) {
            String baseModel = _vimBaseTypeByDerivedType.get(model);
            if (baseModel == null) continue;
            baseModels.add(baseModel);
        }
        return baseModels;
    }

    private boolean isAggregatedType(Object comparableValue) {
        return comparableValue instanceof String && this._aggregatedModels.getAllAggregatedModels().contains(comparableValue);
    }

    private static boolean isCollection(Object obj) {
        return obj instanceof Collection || obj.getClass().isArray();
    }

    private List<Object> getPropertyValues(List<String> properties, CustomFieldsManager.FieldDef fieldDef) {
        ArrayList<Object> result = new ArrayList<Object>(properties.size());
        for (String property : properties) {
            result.add(this.getPropertyValue(property, fieldDef));
        }
        return result;
    }

    private Object getPropertyValue(String property, CustomFieldsManager.FieldDef fieldDef) {
        assert (fieldDef != null);
        switch (property) {
            case "@modelKey": {
                return this.buildKey(fieldDef);
            }
            case "@type": {
                return "CustomFieldDef";
            }
            case "CustomFieldDef/key": {
                return fieldDef.getKey();
            }
            case "CustomFieldDef/name": {
                return fieldDef.getName();
            }
            case "CustomFieldDef/managedObjectType": 
            case "CustomFieldDef/applicableType": {
                TypeName moType = fieldDef.getManagedObjectType();
                return moType == null ? null : ((TypeNameImpl)moType).getWsdlName();
            }
        }
        throw new IllegalArgumentException("No such property: " + property + " for model " + "CustomFieldDef");
    }

    private static Map<String, String> getVimBaseTypeByDerivedType() {
        LinkedHashMap<String, String> vimBaseTypeByDerivedType = new LinkedHashMap<String, String>();
        vimBaseTypeByDerivedType.put("OpaqueNetwork", "Network");
        vimBaseTypeByDerivedType.put("DistributedVirtualPortgroup", "Network");
        vimBaseTypeByDerivedType.put("VmwareDistributedVirtualSwitch", "DistributedVirtualSwitch");
        vimBaseTypeByDerivedType.put("VirtualApp", "ResourcePool");
        vimBaseTypeByDerivedType.put("ClusterComputeResource", "ComputeResource");
        vimBaseTypeByDerivedType.put("StoragePod", "Folder");
        return Collections.unmodifiableMap(vimBaseTypeByDerivedType);
    }
}

