/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.federation;

import com.vmware.cis.data.internal.adapters.federation.IdentifiableServiceInstance;
import com.vmware.cis.data.internal.adapters.federation.MajorMinorVersion;
import com.vmware.cis.data.internal.adapters.federation.VcServiceInstanceIdentifier;
import com.vmware.cis.data.internal.adapters.federation.VersionAnalyzer;
import com.vmware.cis.data.internal.adapters.lookup.ServiceEndpointInfo;
import com.vmware.cis.data.internal.adapters.lookup.ServiceLocator;
import com.vmware.cis.data.internal.adapters.vmomi.impl.HttpConfigurationFactory;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceEndpointDiscovery {
    private static final Logger logger = LoggerFactory.getLogger(ServiceEndpointDiscovery.class);
    private static final String PRODUCT_CIS = "com.vmware.cis";
    private static final String SERVICE_TYPE_VC = "vcenterserver";
    private static final String ENDPOINT_VIM = "com.vmware.vim";
    private static final String SERVICE_TYPE_CLS = "cis.cls";
    public static final String PROVIDER_TYPE_VC = ServiceEndpointDiscovery.makeServiceTypeId("com.vmware.cis", "vcenterserver");
    public static final String PROVIDER_TYPE_CLS = ServiceEndpointDiscovery.makeServiceTypeId("com.vmware.cis", "cis.cls");
    public static final String PROTOCOL_VMOMI = "vmomi";
    public static final String PROTOCOL_VAPI = "vapi.json.https";
    public static final String PROTOCOL_VAPI_PLAIN = "vapi.json.http";

    public static Collection<ServiceEndpointInfo> findVcEndpoints(ServiceLocator serviceLocator) {
        return serviceLocator.findServiceEndpoints(PRODUCT_CIS, SERVICE_TYPE_VC, ENDPOINT_VIM, PROTOCOL_VMOMI);
    }

    public static Collection<ServiceEndpointInfo> filterByServiceType(Collection<ServiceEndpointInfo> endpoints, String desiredServiceType) {
        ArrayList<ServiceEndpointInfo> filtered = new ArrayList<ServiceEndpointInfo>(endpoints.size());
        for (ServiceEndpointInfo endpoint : endpoints) {
            if (!desiredServiceType.equals(endpoint.getServiceType())) continue;
            filtered.add(endpoint);
        }
        return filtered;
    }

    public static Map<String, IdentifiableServiceInstance> createVpxdInstanceIdPerNode(Collection<ServiceEndpointInfo> vpxdEndpoints, VmodlContext vmodlContext, HttpConfigurationFactory vlsiHttpConfigFactory) {
        HashMap<String, IdentifiableServiceInstance> vpxdInstanceIdByNode = new HashMap<String, IdentifiableServiceInstance>();
        for (ServiceEndpointInfo vpxdEndpoint : vpxdEndpoints) {
            URI endpointAddress = vpxdEndpoint.getUrl();
            HttpConfiguration httpConfig = vlsiHttpConfigFactory.createConfiguration(endpointAddress, vpxdEndpoint.getTrustStore());
            VcServiceInstanceIdentifier instanceId = new VcServiceInstanceIdentifier(vmodlContext, vpxdEndpoint.getUrl(), httpConfig);
            vpxdInstanceIdByNode.put(vpxdEndpoint.getNodeId(), instanceId);
        }
        return vpxdInstanceIdByNode;
    }

    public static Collection<ServiceEndpointInfo> onlySupported(Collection<ServiceEndpointInfo> endpoints, Map<String, IdentifiableServiceInstance> vpxdInstanceIdByNode) {
        assert (endpoints != null);
        assert (vpxdInstanceIdByNode != null);
        ArrayList<ServiceEndpointInfo> filtered = new ArrayList<ServiceEndpointInfo>(endpoints.size());
        for (ServiceEndpointInfo endpoint : endpoints) {
            String nodeId = endpoint.getNodeId();
            IdentifiableServiceInstance vpxdInstanceId = vpxdInstanceIdByNode.get(nodeId);
            if (vpxdInstanceId == null) {
                logger.debug("Skipping service '{}' because it resides on node '{}' which is outside of the target node set: {}", new Object[]{endpoint.getServiceType(), endpoint.getNodeId(), vpxdInstanceIdByNode.keySet()});
                continue;
            }
            String version = vpxdInstanceId.getVersion();
            if (version == null) {
                logger.debug("Skipping service '{}' because it resides on node '{}' for which there is no vCenter version.", (Object)endpoint.getServiceType(), (Object)endpoint.getNodeId());
                continue;
            }
            if (ServiceEndpointDiscovery.isSupportedVersion(version)) {
                filtered.add(endpoint);
                continue;
            }
            logger.debug("Ignoring old endpoint of version {} at {}", (Object)version, (Object)endpoint.getUrl());
        }
        return filtered;
    }

    public static boolean isSupportedVersion(String version) {
        assert (version != null);
        MajorMinorVersion actual = MajorMinorVersion.parseVersion(version);
        return !VersionAnalyzer.isVersionBeforeRise(actual);
    }

    private static String makeServiceTypeId(String productId, String serviceType) {
        return productId + ":" + serviceType;
    }
}

