/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.federation;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.internal.adapters.federation.QueryRouter;
import com.vmware.cis.data.internal.adapters.federation.RouterUtils;
import com.vmware.cis.data.internal.util.PropertyUtil;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class Vmodl1ModelKeyRouter
implements QueryRouter {
    @Override
    public Query route(Query query, String targetInstanceId) {
        if (query.getFilter() == null) {
            return query;
        }
        Filter filter = query.getFilter();
        ArrayList<PropertyPredicate> processedPredicates = new ArrayList<PropertyPredicate>(filter.getCriteria().size());
        block4: for (PropertyPredicate predicate : filter.getCriteria()) {
            if (PropertyUtil.isModelKey((String)predicate.getProperty())) {
                switch (predicate.getOperator()) {
                    case EQUAL: 
                    case IN: {
                        List<Object> keysForTargetInstance = this.extractModelKeysForServiceId(predicate.getComparableValue(), targetInstanceId);
                        if (!keysForTargetInstance.isEmpty()) {
                            processedPredicates.add(Vmodl1ModelKeyRouter.toModelKeyPredicate(keysForTargetInstance));
                            break;
                        }
                        if (filter.getOperator() != LogicalOperator.AND) continue block4;
                        return null;
                    }
                    case NOT_EQUAL: {
                        String predicateTargetInstance = this.getServiceInstanceIdFromModelKey(predicate.getComparableValue());
                        if (targetInstanceId.equals(predicateTargetInstance)) {
                            processedPredicates.add(predicate);
                            break;
                        }
                        if (filter.getOperator() != LogicalOperator.OR) continue block4;
                        return RouterUtils.replaceCriteria(query, null);
                    }
                    default: {
                        processedPredicates.add(predicate);
                        break;
                    }
                }
                continue;
            }
            processedPredicates.add(predicate);
        }
        if (processedPredicates.isEmpty() && filter.getOperator() == LogicalOperator.OR) {
            return null;
        }
        return RouterUtils.replaceCriteria(query, processedPredicates);
    }

    private List<Object> extractModelKeysForServiceId(Object predicateModelKeyValue, String targetInstanceId) {
        Collection<Object> modelKeyValues = RouterUtils.toCollection(predicateModelKeyValue);
        ArrayList<Object> keysForService = new ArrayList<Object>(modelKeyValues.size());
        for (Object modelKeyObj : modelKeyValues) {
            if (!targetInstanceId.equals(this.getServiceInstanceIdFromModelKey(modelKeyObj))) continue;
            keysForService.add(modelKeyObj);
        }
        return keysForService;
    }

    private String getServiceInstanceIdFromModelKey(Object modelKeyObj) {
        if (!(modelKeyObj instanceof ManagedObjectReference)) {
            throw new IllegalArgumentException(String.format("The comparableValue for %s must be ManagedObjectReference or a collection of ManagedObjectReference.", "@modelKey"));
        }
        return ((ManagedObjectReference)modelKeyObj).getServerGuid();
    }

    private static PropertyPredicate toModelKeyPredicate(List<Object> modelKeyValues) {
        Object comparableValue;
        PropertyPredicate.ComparisonOperator operator;
        assert (!modelKeyValues.isEmpty());
        if (modelKeyValues.size() == 1) {
            operator = PropertyPredicate.ComparisonOperator.EQUAL;
            comparableValue = modelKeyValues.get(0);
        } else {
            operator = PropertyPredicate.ComparisonOperator.IN;
            comparableValue = modelKeyValues;
        }
        return new PropertyPredicate("@modelKey", operator, comparableValue);
    }
}

