/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.lookup;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.Validate;

public final class KeyStoreMaker {
    public static KeyStore fromTrustedCertificates(String[] base64Certificates) {
        if (base64Certificates == null) {
            return null;
        }
        List<X509Certificate> certs = KeyStoreMaker.decodeCertificates(base64Certificates);
        return KeyStoreMaker.fromTrustedCertificates(certs);
    }

    public static KeyStore fromTrustedCertificates(List<X509Certificate> certs) {
        try {
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustStore.load(null, null);
            for (X509Certificate cert : certs) {
                trustStore.setCertificateEntry(cert.getSubjectDN().getName(), cert);
            }
            return trustStore;
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalStateException("Error create in-memory keystore", e);
        }
    }

    private static List<X509Certificate> decodeCertificates(String[] base64Certificates) {
        Validate.notEmpty((Object[])base64Certificates);
        Validate.noNullElements((Object[])base64Certificates);
        ArrayList<X509Certificate> result = new ArrayList<X509Certificate>(base64Certificates.length);
        for (String s : base64Certificates) {
            X509Certificate certificate = KeyStoreMaker.decodeCertificate(s);
            result.add(certificate);
        }
        return result;
    }

    private static X509Certificate decodeCertificate(String base64Certificate) {
        X509Certificate certificate;
        CertificateFactory factory;
        try {
            factory = CertificateFactory.getInstance("X509");
        }
        catch (CertificateException e) {
            throw new IllegalStateException("Internal error: X.509 CertificateFactory not supported by the runtime.", e);
        }
        try {
            factory = CertificateFactory.getInstance("X509");
            certificate = (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(Base64.decodeBase64((byte[])base64Certificate.getBytes("UTF-8"))));
        }
        catch (UnsupportedEncodingException | CertificateException e) {
            throw new IllegalArgumentException("Ignoring invalid base64 encoded certificate", e);
        }
        return certificate;
    }
}

