/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.lookup;

import com.vmware.cis.data.internal.adapters.federation.ServiceEndpointDiscovery;
import com.vmware.cis.data.internal.adapters.lookup.KeyStoreMaker;
import com.vmware.cis.data.internal.adapters.lookup.ServiceEndpointInfo;
import com.vmware.cis.data.internal.adapters.lookup.ServiceLocator;
import com.vmware.cis.data.internal.adapters.vmomi.impl.VmomiVersionMapper;
import com.vmware.cis.data.internal.provider.SsoDomain;
import com.vmware.vim.binding.lookup.ServiceRegistration;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Provider;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LsBasedServiceLocator
implements ServiceLocator {
    private static final Logger logger = LoggerFactory.getLogger(LsBasedServiceLocator.class);
    private static final String LS_SERVICE_ATTR__DOMAIN_ID = "domainId";
    private static final String LS_SERVICE_ATTR__DOMAIN_NAME = "domainName";
    private static final String LS_SERVICE_ATTR__DOMAIN_TYPE = "domainType";
    private final Provider<ServiceRegistration> _lookupServiceFactory;
    private final KeyStore _systemWideTrustStore;
    private final String _nodeIdFilter;
    private final boolean _searchAllSsoDomains;

    public LsBasedServiceLocator(Provider<ServiceRegistration> lookupService, KeyStore systemWideTrustStore, String nodeIdFilter) {
        this(lookupService, systemWideTrustStore, nodeIdFilter, false);
    }

    public LsBasedServiceLocator(Provider<ServiceRegistration> lookupService, KeyStore systemWideTrustStore, String nodeIdFilter, boolean searchAllSsoDomains) {
        Validate.notNull(lookupService, (String)"Argument `lookupService' is required.");
        this._lookupServiceFactory = lookupService;
        this._systemWideTrustStore = systemWideTrustStore;
        this._nodeIdFilter = nodeIdFilter;
        this._searchAllSsoDomains = searchAllSsoDomains;
    }

    @Override
    public Collection<ServiceEndpointInfo> findServiceEndpoints(String productId, String serviceType, String endpointType, String endpointProtocol) {
        ServiceRegistration lookupService = this.getLookupService();
        Map<String, List<EndpointAtNode>> endpoinsByService = this.findEndpoints(lookupService, productId, serviceType, endpointType, endpointProtocol);
        ArrayList<ServiceEndpointInfo> infos = new ArrayList<ServiceEndpointInfo>();
        for (String serviceName : endpoinsByService.keySet()) {
            for (EndpointAtNode endpointAtNode : endpoinsByService.get(serviceName)) {
                ServiceRegistration.Endpoint endpoint = endpointAtNode.endpoint;
                ServiceEndpointInfo info = new ServiceEndpointInfo(serviceName, endpoint.getUrl(), endpointAtNode.nodeId, this.createTrustStoreForEndpoint(endpoint), endpoint.endpointType.type, endpoint.endpointType.protocol, endpointAtNode.serviceId, endpointAtNode.vcVmodlVersion, endpointAtNode.ssoDomain);
                infos.add(info);
            }
        }
        return Collections.unmodifiableList(infos);
    }

    private ServiceRegistration getLookupService() {
        ServiceRegistration lookupService = (ServiceRegistration)this._lookupServiceFactory.get();
        if (lookupService == null) {
            throw new IllegalStateException("Provider for LookupService stub returned null object.");
        }
        return lookupService;
    }

    private Map<String, List<EndpointAtNode>> findEndpoints(ServiceRegistration lookupService, String productName, String serviceType, String endpointType, String endpointProtocol) {
        ServiceRegistration.ServiceType serviceTypeFilter = productName != null && serviceType != null ? new ServiceRegistration.ServiceType(productName, serviceType) : null;
        ServiceRegistration.EndpointType endpointTypeFilter = endpointProtocol != null && endpointType != null ? new ServiceRegistration.EndpointType(endpointProtocol, endpointType) : null;
        ServiceRegistration.Filter filter = new ServiceRegistration.Filter();
        filter.setNodeId(this._nodeIdFilter);
        filter.setServiceType(serviceTypeFilter);
        filter.setEndpointType(endpointTypeFilter);
        filter.setSearchAllSsoDomains(Boolean.valueOf(this._searchAllSsoDomains));
        Object[] foundServices = lookupService.list(filter);
        if (ArrayUtils.isEmpty((Object[])foundServices)) {
            return Collections.emptyMap();
        }
        HashMap<String, List<EndpointAtNode>> endpointsByService = new HashMap<String, List<EndpointAtNode>>();
        for (Object foundService : foundServices) {
            if (!this.serviceTypeMatchesFilter(((ServiceRegistration.Info)foundService).serviceType, productName, serviceType)) continue;
            String serviceTypeId = LsBasedServiceLocator.makeServiceTypeId(((ServiceRegistration.Info)foundService).serviceType.product, ((ServiceRegistration.Info)foundService).serviceType.type);
            if (ArrayUtils.isEmpty((Object[])((ServiceRegistration.Info)foundService).serviceEndpoints)) {
                logger.warn("No endpoints were returned by Lookup Service for entry {}. Entry ignored.", (Object)LsBasedServiceLocator.makeServiceTypeId(productName, serviceType));
                continue;
            }
            ArrayList<EndpointAtNode> endpoints = new ArrayList<EndpointAtNode>(((ServiceRegistration.Info)foundService).serviceEndpoints.length);
            for (ServiceRegistration.Endpoint endpoint : ((ServiceRegistration.Info)foundService).serviceEndpoints) {
                if (!this.endpointMatchesFilter(endpoint.endpointType, endpointType, endpointProtocol)) continue;
                endpoints.add(new EndpointAtNode(((ServiceRegistration.Info)foundService).nodeId, endpoint, ((ServiceRegistration.Info)foundService).serviceId, LsBasedServiceLocator.extractVmodlVersion(((ServiceRegistration.Info)foundService).serviceVersion, serviceTypeId), LsBasedServiceLocator.extractSsoDomain((ServiceRegistration.Info)foundService)));
            }
            LsBasedServiceLocator.putAll(endpointsByService, serviceTypeId, endpoints);
        }
        return endpointsByService;
    }

    private boolean serviceTypeMatchesFilter(ServiceRegistration.ServiceType actualType, String filterProduct, String filterType) {
        return !(filterProduct != null && !filterProduct.equals(actualType.product) || filterType != null && !filterType.equals(actualType.type));
    }

    private boolean endpointMatchesFilter(ServiceRegistration.EndpointType actualType, String filterType, String filterProtocol) {
        return !(filterType != null && !filterType.equals(actualType.type) || filterProtocol != null && !filterProtocol.equals(actualType.protocol));
    }

    private KeyStore createTrustStoreForEndpoint(ServiceRegistration.Endpoint endpoint) {
        return this._systemWideTrustStore == null ? KeyStoreMaker.fromTrustedCertificates(endpoint.sslTrust) : this._systemWideTrustStore;
    }

    private static Class<?> extractVmodlVersion(String serviceVersion, String serviceTypeId) {
        if (!serviceTypeId.equals(ServiceEndpointDiscovery.PROVIDER_TYPE_VC)) {
            return null;
        }
        return VmomiVersionMapper.getVcVersion(serviceVersion);
    }

    public static SsoDomain extractSsoDomain(ServiceRegistration.Info foundService) {
        String domainId = LsBasedServiceLocator.getServiceAttribute(foundService, LS_SERVICE_ATTR__DOMAIN_ID);
        if (domainId == null) {
            return null;
        }
        String domainName = LsBasedServiceLocator.getServiceAttribute(foundService, LS_SERVICE_ATTR__DOMAIN_NAME);
        String domainType = LsBasedServiceLocator.getServiceAttribute(foundService, LS_SERVICE_ATTR__DOMAIN_TYPE);
        return new SsoDomain(domainId, domainName, domainType);
    }

    private static String makeServiceTypeId(String productId, String serviceType) {
        return productId + ":" + serviceType;
    }

    private static <K, V> void putAll(Map<K, List<V>> target, K key, List<V> values) {
        if (values.isEmpty()) {
            return;
        }
        List<V> existing = target.get(key);
        if (existing != null) {
            existing.addAll(values);
        } else {
            target.put(key, values);
        }
    }

    private static String getServiceAttribute(ServiceRegistration.Info info, String key) {
        assert (info != null);
        assert (key != null);
        ServiceRegistration.Attribute[] attributes = info.getServiceAttributes();
        if (attributes == null) {
            return null;
        }
        for (ServiceRegistration.Attribute attribute : attributes) {
            if (!key.equals(attribute.getKey())) continue;
            return attribute.getValue();
        }
        return null;
    }

    private static final class EndpointAtNode {
        public final String nodeId;
        public final ServiceRegistration.Endpoint endpoint;
        public final String serviceId;
        public final Class<?> vcVmodlVersion;
        public final SsoDomain ssoDomain;

        public EndpointAtNode(String nodeId, ServiceRegistration.Endpoint endpoint, String serviceId, Class<?> vcVmodlVersion, SsoDomain ssoDomain) {
            this.nodeId = nodeId;
            this.endpoint = endpoint;
            this.serviceId = serviceId;
            this.vcVmodlVersion = vcVmodlVersion;
            this.ssoDomain = ssoDomain;
        }
    }
}

