/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.property;

import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.internal.adapters.property.BackCompatPropertyProvider;
import com.vmware.cis.data.provider.DataProvider;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.client.Client;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public final class VappStoragePropertyProvider
implements BackCompatPropertyProvider {
    private static final String VAPP = "VirtualApp";
    private static final String VAPP_VAPSTORAGE_PROPERTY = "VirtualApp/vappStorage";
    private static final String VAPP_DATASTORE_PROPERTY = "VirtualApp/datastore";
    private static final String STORAGE_POD = "StoragePod";
    private static final String DATASTORE = "Datastore";
    private static final String DATASTORE_SUMMARY_TYPE = "Datastore/summary/type";
    private static final String DATASTORE_PARENT = "Datastore/parent";
    private static final String PMEM = "PMEM";

    @Override
    public Collection<String> getProperties() {
        return Collections.unmodifiableList(Arrays.asList(VAPP_VAPSTORAGE_PROPERTY));
    }

    @Override
    public List<Collection<?>> fetchPropertyValues(List<String> properties, Collection<Object> keys, DataProvider provider, Client vlsiClient) {
        assert (properties != null);
        assert (properties.size() == 1);
        assert (properties.contains(VAPP_VAPSTORAGE_PROPERTY));
        assert (!keys.isEmpty());
        Map<Object, Object[]> datastoresByVapp = VappStoragePropertyProvider.getDatastoresByVapp(provider, keys);
        Map<Object, Object> parentByVappDatastore = VappStoragePropertyProvider.getParentByVappDatastore(provider, datastoresByVapp);
        ArrayList result = new ArrayList();
        ArrayList<ManagedObjectReference[]> vappStorages = new ArrayList<ManagedObjectReference[]>();
        for (Object key : keys) {
            Object[] datastores = datastoresByVapp.get(key);
            ManagedObjectReference[] vappStorage = VappStoragePropertyProvider.getVappStorages(datastores, parentByVappDatastore);
            vappStorages.add(vappStorage);
        }
        result.add(vappStorages);
        return result;
    }

    private static ManagedObjectReference[] getVappStorages(Object[] datastores, Map<Object, Object> parentByVappDatastore) {
        if (datastores == null) {
            return new ManagedObjectReference[0];
        }
        ArrayList<ManagedObjectReference> result = new ArrayList<ManagedObjectReference>();
        for (Object datastore : datastores) {
            Object parent = parentByVappDatastore.get(datastore);
            if (VappStoragePropertyProvider.isStoragePod(parent)) {
                result.add((ManagedObjectReference)parent);
                continue;
            }
            result.add((ManagedObjectReference)datastore);
        }
        return result.toArray(new ManagedObjectReference[result.size()]);
    }

    private static boolean isStoragePod(Object object) {
        assert (object instanceof ManagedObjectReference);
        ManagedObjectReference objectMor = (ManagedObjectReference)object;
        return STORAGE_POD.equals(objectMor.getType());
    }

    private static Collection<Object> extractDatastoreRefs(Map<Object, Object[]> datastoresByVapp) {
        LinkedHashSet<Object> datastoreRefs = new LinkedHashSet<Object>();
        for (Object vapp : datastoresByVapp.keySet()) {
            Object[] datastores = datastoresByVapp.get(vapp);
            if (datastores == null) continue;
            for (Object datastoreRef : datastores) {
                datastoreRefs.add(datastoreRef);
            }
        }
        return datastoreRefs;
    }

    private static Map<Object, Object[]> getDatastoresByVapp(DataProvider provider, Collection<Object> vappKeys) {
        Query query = Query.Builder.select((String[])new String[]{VAPP_DATASTORE_PROPERTY}).from(new String[]{VAPP}).where("@modelKey", PropertyPredicate.ComparisonOperator.IN, vappKeys).build();
        ResultSet resultSet = provider.executeQuery(query);
        List items = resultSet.getItems();
        LinkedHashMap<Object, Object[]> datastoresByVapp = new LinkedHashMap<Object, Object[]>(items.size());
        for (ResourceItem item : items) {
            Object[] datastores = (Object[])item.get(VAPP_DATASTORE_PROPERTY);
            datastoresByVapp.put(item.getKey(), datastores);
        }
        return datastoresByVapp;
    }

    private static Map<Object, Object> getParentByVappDatastore(DataProvider provider, Map<Object, Object[]> datastoresByVapp) {
        Collection<Object> datastoreRefs = VappStoragePropertyProvider.extractDatastoreRefs(datastoresByVapp);
        if (datastoreRefs.isEmpty()) {
            return Collections.emptyMap();
        }
        Query query = Query.Builder.select((String[])new String[]{DATASTORE_PARENT}).from(new String[]{DATASTORE}).where(LogicalOperator.AND, new PropertyPredicate[]{new PropertyPredicate(DATASTORE_SUMMARY_TYPE, PropertyPredicate.ComparisonOperator.NOT_EQUAL, (Object)PMEM), new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.IN, datastoreRefs)}).build();
        ResultSet resultSet = provider.executeQuery(query);
        List items = resultSet.getItems();
        LinkedHashMap<Object, Object> parentByDatastore = new LinkedHashMap<Object, Object>();
        for (ResourceItem item : items) {
            Object parent = item.get(DATASTORE_PARENT);
            parentByDatastore.put(item.getKey(), parent);
        }
        return parentByDatastore;
    }
}

