/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.property;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.internal.adapters.property.BackCompatPropertyProvider;
import com.vmware.cis.data.provider.DataProvider;
import com.vmware.vim.vmomi.client.Client;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class VmVsanFaultDomainNamePropertyProvider
implements BackCompatPropertyProvider {
    private static final String VM = "VirtualMachine";
    private static final String VM_VSAN_FAULT_DOMAIN_NAME = "VirtualMachine/vsanFaultDomainName";
    private static final String VM_RUNTIME_HOST = "VirtualMachine/runtime/host";
    private static final String HOST = "HostSystem";
    private static final String HOST_VSAN_CONFIG_ENABLED = "HostSystem/config/vsanHostConfig/enabled";
    private static final String HOST_VSAN_FAULT_DOMAIN_INFO_NAME = "HostSystem/config/vsanHostConfig/faultDomainInfo/name";
    private static final Collection<String> _properties;

    @Override
    public Collection<String> getProperties() {
        return _properties;
    }

    @Override
    public List<Collection<?>> fetchPropertyValues(List<String> properties, Collection<Object> vmKeys, DataProvider provider, Client vlsiClient) {
        assert (properties != null);
        assert (properties.size() == 1);
        assert (properties.contains(VM_VSAN_FAULT_DOMAIN_NAME));
        Map<Object, Object> hostByVm = VmVsanFaultDomainNamePropertyProvider.fetchHostByVm(vmKeys, provider);
        Collection<Object> hostKeys = hostByVm.values();
        Map<Object, String> vsanFaultDomainNamesByHost = VmVsanFaultDomainNamePropertyProvider.fetchVsanFaultDomainNamesByHost(hostKeys, provider);
        ArrayList<String> vmVsanFaultDomainNames = new ArrayList<String>();
        for (Object vmKey : vmKeys) {
            Object hostKey = hostByVm.get(vmKey);
            if (hostKey == null) {
                vmVsanFaultDomainNames.add(null);
                continue;
            }
            String vsanFaultDomainName = vsanFaultDomainNamesByHost.get(hostKey);
            vmVsanFaultDomainNames.add(vsanFaultDomainName);
        }
        ArrayList propertyValues = new ArrayList();
        propertyValues.add(vmVsanFaultDomainNames);
        return propertyValues;
    }

    private static Map<Object, String> fetchVsanFaultDomainNamesByHost(Collection<Object> hostKeys, DataProvider provider) {
        Query query = Query.Builder.select((String[])new String[]{HOST_VSAN_CONFIG_ENABLED, HOST_VSAN_FAULT_DOMAIN_INFO_NAME}).from(new String[]{HOST}).where("@modelKey", PropertyPredicate.ComparisonOperator.IN, hostKeys).build();
        ResultSet resultSet = provider.executeQuery(query);
        LinkedHashMap<Object, String> vsanFaultDomainNamesByHost = new LinkedHashMap<Object, String>();
        List items = resultSet.getItems();
        for (ResourceItem item : items) {
            String vsanFaultDomainName = VmVsanFaultDomainNamePropertyProvider.getVsanFaultDomainName(item);
            vsanFaultDomainNamesByHost.put(item.getKey(), vsanFaultDomainName);
        }
        return vsanFaultDomainNamesByHost;
    }

    private static String getVsanFaultDomainName(ResourceItem resourceItem) {
        Boolean vsanConfigEnabled = (Boolean)resourceItem.get(HOST_VSAN_CONFIG_ENABLED);
        if (vsanConfigEnabled == null || !vsanConfigEnabled.booleanValue()) {
            return null;
        }
        return (String)resourceItem.get(HOST_VSAN_FAULT_DOMAIN_INFO_NAME);
    }

    private static Map<Object, Object> fetchHostByVm(Collection<Object> keys, DataProvider provider) {
        Query query = Query.Builder.select((String[])new String[]{VM_RUNTIME_HOST}).from(new String[]{VM}).where("@modelKey", PropertyPredicate.ComparisonOperator.IN, keys).build();
        ResultSet resultSet = provider.executeQuery(query);
        LinkedHashMap<Object, Object> hostByVm = new LinkedHashMap<Object, Object>();
        List items = resultSet.getItems();
        for (ResourceItem item : items) {
            Object hostKey = item.get(VM_RUNTIME_HOST);
            if (hostKey == null) continue;
            Object vmKey = item.getKey();
            hostByVm.put(vmKey, hostKey);
        }
        return hostByVm;
    }

    static {
        ArrayList<String> properties = new ArrayList<String>();
        properties.add(VM_VSAN_FAULT_DOMAIN_NAME);
        _properties = Collections.unmodifiableList(properties);
    }
}

