/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.tagging;

import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.internal.adapters.tagging.InvSvcTaggingIdConverter;
import com.vmware.cis.data.internal.adapters.tagging.LenientTaggingFacade;
import com.vmware.cis.data.internal.adapters.tagging.PropertyProvider;
import com.vmware.cis.tagging.CategoryModel;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;

final class InvSvcCategoryModelPropertyProvider
implements PropertyProvider {
    private final LenientTaggingFacade _tagging;

    public static Map<String, QuerySchema.PropertyInfo> getProperties() {
        LinkedHashMap<String, QuerySchema.PropertyInfo> properties = new LinkedHashMap<String, QuerySchema.PropertyInfo>();
        properties.put("inventoryservice:InventoryServiceCategory/name", QuerySchema.PropertyInfo.forFilterableProperty((QuerySchema.PropertyType)QuerySchema.PropertyType.STRING));
        properties.put("inventoryservice:InventoryServiceCategory/description", QuerySchema.PropertyInfo.forFilterableProperty((QuerySchema.PropertyType)QuerySchema.PropertyType.STRING));
        properties.put("inventoryservice:InventoryServiceCategory/multipleCardinality", QuerySchema.PropertyInfo.forFilterableProperty((QuerySchema.PropertyType)QuerySchema.PropertyType.BOOLEAN));
        properties.put("inventoryservice:InventoryServiceCategory/associableEntityType", QuerySchema.PropertyInfo.forFilterableProperty((QuerySchema.PropertyType)QuerySchema.PropertyType.STRING));
        properties.put("inventoryservice:InventoryServiceCategory/associableEntityTypeName", QuerySchema.PropertyInfo.forFilterableProperty((QuerySchema.PropertyType)QuerySchema.PropertyType.STRING));
        properties.put("inventoryservice:InventoryServiceCategory/associableWithAllEntityTypes", QuerySchema.PropertyInfo.forFilterableProperty((QuerySchema.PropertyType)QuerySchema.PropertyType.BOOLEAN));
        properties.put("inventoryservice:InventoryServiceCategory/childTags", QuerySchema.PropertyInfo.forFilterableProperty((QuerySchema.PropertyType)QuerySchema.PropertyType.ID));
        return Collections.unmodifiableMap(properties);
    }

    InvSvcCategoryModelPropertyProvider(LenientTaggingFacade tagging) {
        assert (tagging != null);
        this._tagging = tagging;
    }

    @Override
    public List<List<Object>> get(List<?> modelKeys, List<String> properties) {
        assert (modelKeys != null);
        assert (properties != null);
        ArrayList<String> ids = new ArrayList<String>(modelKeys.size());
        for (Object modelKey : modelKeys) {
            String id = InvSvcCategoryModelPropertyProvider.toCategoryId(modelKey);
            ids.add(id);
        }
        List<CategoryModel> categoryModels = this._tagging.getCategories(ids);
        return this.getItems(categoryModels, properties);
    }

    @Override
    public List<List<Object>> list(List<String> properties) {
        assert (properties != null);
        List<CategoryModel> categoryModels = this._tagging.getAllCategories();
        return this.getItems(categoryModels, properties);
    }

    private List<List<Object>> getItems(List<CategoryModel> categoryModels, List<String> properties) {
        assert (categoryModels != null);
        assert (properties != null);
        ArrayList<List<Object>> items = new ArrayList<List<Object>>(categoryModels.size());
        for (CategoryModel categoryModel : categoryModels) {
            ArrayList<Object> values = new ArrayList<Object>(properties.size());
            for (String property : properties) {
                Object value = this.getProperty(categoryModel, property);
                values.add(value);
            }
            items.add(values);
        }
        return items;
    }

    private Object getProperty(CategoryModel categoryModel, String property) {
        assert (categoryModel != null);
        assert (property != null);
        switch (property) {
            case "@modelKey": {
                String id = categoryModel.getId();
                return InvSvcTaggingIdConverter.taggingIdToMor(id);
            }
            case "@type": {
                return "inventoryservice:InventoryServiceCategory";
            }
            case "inventoryservice:InventoryServiceCategory/name": {
                return categoryModel.getName();
            }
            case "inventoryservice:InventoryServiceCategory/description": {
                return categoryModel.getDescription();
            }
            case "inventoryservice:InventoryServiceCategory/multipleCardinality": {
                return CategoryModel.Cardinality.MULTIPLE.equals((Object)categoryModel.getCardinality());
            }
            case "inventoryservice:InventoryServiceCategory/childTags": {
                List<String> ids = this._tagging.listTagsForCategory(categoryModel.getId());
                return InvSvcTaggingIdConverter.taggingIdsToMorArray(ids);
            }
            case "inventoryservice:InventoryServiceCategory/associableEntityType": 
            case "inventoryservice:InventoryServiceCategory/associableEntityTypeName": {
                Set associableTypes = categoryModel.getAssociableTypes();
                Object[] associableTypesArray = associableTypes.isEmpty() ? null : associableTypes.toArray();
                return associableTypesArray;
            }
            case "inventoryservice:InventoryServiceCategory/associableWithAllEntityTypes": {
                return new Object[]{categoryModel.getAssociableTypes().isEmpty()};
            }
        }
        throw new IllegalArgumentException("Unknown property : " + property);
    }

    private static String toCategoryId(Object key) {
        Validate.notNull((Object)key, (String)"Null key for model inventoryservice:InventoryServiceCategory");
        if (!(key instanceof ManagedObjectReference)) {
            throw new IllegalArgumentException(String.format("Key for model '%s' must be a ManagedObjectReference and not %s: <%s>", "inventoryservice:InventoryServiceCategory", key.getClass().getCanonicalName(), key));
        }
        ManagedObjectReference ref = (ManagedObjectReference)key;
        return InvSvcTaggingIdConverter.taggingMorToId(ref);
    }
}

