/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.tagging;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.SortCriterion;
import com.vmware.cis.data.internal.adapters.tagging.FilteringPropertyProvider;
import com.vmware.cis.data.internal.adapters.tagging.PropertyProvider;
import com.vmware.cis.data.internal.provider.merge.DefaultItemComparator;
import com.vmware.cis.data.internal.provider.util.filter.FilterEvaluator;
import com.vmware.cis.data.internal.provider.util.property.PropertyByName;
import com.vmware.cis.data.internal.util.PropertyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;

public final class PropertyProviderBasedQueryExecutor {
    private final PropertyProvider _data;
    private final FilteringPropertyProvider _search;

    public PropertyProviderBasedQueryExecutor(PropertyProvider data) {
        this(data, new FilteringPropertyProvider(){

            @Override
            public List<?> getKeys(PropertyPredicate predicate) {
                return null;
            }
        });
    }

    public PropertyProviderBasedQueryExecutor(PropertyProvider data, FilteringPropertyProvider search) {
        assert (data != null);
        assert (search != null);
        this._data = data;
        this._search = search;
    }

    public ResultSet executeQuery(Query query) {
        ResultSet.Builder resultBuilder;
        assert (query != null);
        List<?> filteredKeys = this.filter(query.getFilter());
        if (query.getLimit() != 0) {
            List<?> sortedKeys = this.sort(filteredKeys, query.getSortCriteria());
            List<?> pagedKeys = PropertyProviderBasedQueryExecutor.page(sortedKeys, query.getOffset(), query.getLimit());
            resultBuilder = ResultSet.Builder.properties((List)query.getProperties());
            List<List<Object>> items = this.getPropertyValues(pagedKeys, query.getProperties());
            assert (pagedKeys.size() == items.size());
            Iterator<List<Object>> itemIterator = items.iterator();
            for (Object key : pagedKeys) {
                List<Object> propertyValues = itemIterator.next();
                resultBuilder.item(key, propertyValues);
            }
        } else {
            resultBuilder = ResultSet.Builder.properties((String[])new String[0]);
        }
        return resultBuilder.totalCount(query.getWithTotalCount() ? Integer.valueOf(filteredKeys.size()) : null).build();
    }

    private List<?> filter(Filter filter) {
        List<?> keys = this.filterByNative(filter);
        if (keys != null) {
            return keys;
        }
        List<String> propertiesInInterpretableFilter = PropertyProviderBasedQueryExecutor.getPropsAndKey(filter);
        List<List<Object>> allItems = this._data.list(propertiesInInterpretableFilter);
        return this.filterByInterpreted(filter, propertiesInInterpretableFilter, allItems);
    }

    private List<?> filterByNative(Filter filter) {
        if (filter == null) {
            return null;
        }
        if (filter.getCriteria().size() > 1 && filter.getOperator().equals((Object)LogicalOperator.OR)) {
            return null;
        }
        if (filter.getCriteria().size() == 1) {
            PropertyPredicate predicate = (PropertyPredicate)filter.getCriteria().get(0);
            return this.filterByNative(predicate);
        }
        return this.filterByNativeInConjunction(filter.getCriteria());
    }

    private List<?> filterByNativeInConjunction(List<PropertyPredicate> predicates) {
        assert (predicates != null);
        List<?> keys = null;
        ArrayList<PropertyPredicate> remainingPredicates = new ArrayList<PropertyPredicate>(predicates.size());
        for (PropertyPredicate predicate : predicates) {
            if (keys != null) {
                remainingPredicates.add(predicate);
                continue;
            }
            keys = this.filterByNative(predicate);
            if (keys != null) continue;
            remainingPredicates.add(predicate);
        }
        if (keys == null) {
            return null;
        }
        Filter filter = new Filter(remainingPredicates, LogicalOperator.AND);
        List<String> propertiesInInterpretableFilter = PropertyProviderBasedQueryExecutor.getPropsAndKey(filter);
        List<List<Object>> allItems = this._data.get(keys, propertiesInInterpretableFilter);
        return this.filterByInterpreted(filter, propertiesInInterpretableFilter, allItems);
    }

    private List<?> filterByNative(PropertyPredicate predicate) {
        assert (predicate != null);
        if (!"@modelKey".equals(predicate.getProperty()) || !PropertyProviderBasedQueryExecutor.operatorIsEquality(predicate.getOperator())) {
            return this._search.getKeys(predicate);
        }
        Collection<Object> comparableCollection = PropertyProviderBasedQueryExecutor.getComparableCollection(predicate);
        ArrayList<Object> modelKeys = new ArrayList<Object>(comparableCollection);
        return PropertyProviderBasedQueryExecutor.getModelKeys(this._data.get(modelKeys, PropertyUtil.PROPERTY_LIST_MODEL_KEY), PropertyUtil.PROPERTY_LIST_MODEL_KEY);
    }

    private List<?> filterByInterpreted(Filter filter, List<String> propertiesInFilter, List<List<Object>> items) {
        assert (propertiesInFilter != null);
        assert (items != null);
        if (filter == null) {
            return PropertyProviderBasedQueryExecutor.getModelKeys(items, propertiesInFilter);
        }
        if (items.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<List<Object>> filtered = new ArrayList<List<Object>>(items.size());
        final HashMap<String, Integer> indexByProperty = new HashMap<String, Integer>(propertiesInFilter.size());
        int i = 0;
        for (String string : propertiesInFilter) {
            indexByProperty.put(string, i++);
        }
        for (final List list : items) {
            PropertyByName valueByName = new PropertyByName(){

                public Object getValue(String propertyName) {
                    Integer index = (Integer)indexByProperty.get(propertyName);
                    if (index == null) {
                        return null;
                    }
                    return list.get(index);
                }
            };
            if (!FilterEvaluator.eval((Filter)filter, (PropertyByName)valueByName)) continue;
            filtered.add(list);
        }
        return PropertyProviderBasedQueryExecutor.getModelKeys(filtered, propertiesInFilter);
    }

    private static Collection<Object> getComparableCollection(PropertyPredicate predicate) {
        assert (predicate != null);
        if (PropertyPredicate.ComparisonOperator.IN.equals((Object)predicate.getOperator())) {
            assert (predicate.getComparableValue() instanceof Collection);
            Collection comparableCollection = (Collection)predicate.getComparableValue();
            return comparableCollection;
        }
        return Collections.singletonList(predicate.getComparableValue());
    }

    private static List<String> getPropsAndKey(Filter filter) {
        if (filter == null) {
            return Collections.singletonList("@modelKey");
        }
        LinkedHashSet<String> properties = new LinkedHashSet<String>(filter.getCriteria().size() + 1);
        properties.add("@modelKey");
        for (PropertyPredicate predicate : filter.getCriteria()) {
            properties.add(predicate.getProperty());
        }
        return new ArrayList<String>(properties);
    }

    private static List<?> getModelKeys(List<List<Object>> items, List<String> properties) {
        int modelKeyIndex = properties.indexOf("@modelKey");
        assert (modelKeyIndex >= 0);
        ArrayList<Object> modelKeys = new ArrayList<Object>(items.size());
        for (List<Object> item : items) {
            Object modelKey = item.get(modelKeyIndex);
            modelKeys.add(modelKey);
        }
        return modelKeys;
    }

    private static List<?> getModelKeysOfItems(List<ResourceItem> items, List<String> properties) {
        int modelKeyIndex = properties.indexOf("@modelKey");
        assert (modelKeyIndex >= 0);
        ArrayList modelKeys = new ArrayList(items.size());
        for (ResourceItem item : items) {
            Object modelKey = item.getPropertyValues().get(modelKeyIndex);
            modelKeys.add(modelKey);
        }
        return modelKeys;
    }

    private List<?> sort(List<?> ids, List<SortCriterion> sortCriteria) {
        assert (ids != null);
        assert (sortCriteria != null);
        if (ids.isEmpty() || sortCriteria.isEmpty()) {
            return ids;
        }
        List<SortCriterion> typeFreeSortCriteria = PropertyProviderBasedQueryExecutor.removeTypeFromSort(sortCriteria);
        List<String> propertiesInSort = PropertyProviderBasedQueryExecutor.getPropsAndKey(typeFreeSortCriteria);
        List<List<Object>> items = this._data.get(ids, propertiesInSort);
        ResultSet.Builder resultBuilder = ResultSet.Builder.properties(propertiesInSort);
        for (int index = 0; index < ids.size(); ++index) {
            Object id = ids.get(index);
            List<Object> propertyValues = items.get(index);
            resultBuilder.item(id, propertyValues);
        }
        ResultSet resultSet = resultBuilder.build();
        ArrayList<ResourceItem> resourceItems = new ArrayList<ResourceItem>(resultSet.getItems());
        Collections.sort(resourceItems, new DefaultItemComparator(propertiesInSort, typeFreeSortCriteria));
        return PropertyProviderBasedQueryExecutor.getModelKeysOfItems(resourceItems, propertiesInSort);
    }

    private static List<SortCriterion> removeTypeFromSort(List<SortCriterion> sortCriteria) {
        ArrayList<SortCriterion> newSortCriteria = new ArrayList<SortCriterion>(sortCriteria.size());
        for (SortCriterion sortCriterion : sortCriteria) {
            if (PropertyUtil.isType((String)sortCriterion.getProperty())) continue;
            newSortCriteria.add(sortCriterion);
        }
        return newSortCriteria;
    }

    private static List<String> getPropsAndKey(List<SortCriterion> sortCriteria) {
        assert (sortCriteria != null);
        LinkedHashSet<String> properties = new LinkedHashSet<String>(sortCriteria.size() + 1);
        properties.add("@modelKey");
        for (SortCriterion sortCriterion : sortCriteria) {
            properties.add(sortCriterion.getProperty());
        }
        return new ArrayList<String>(properties);
    }

    private static <T> List<T> page(List<T> list, int offset, int limit) {
        assert (list != null);
        assert (offset >= 0);
        if (list.isEmpty()) {
            return list;
        }
        if (limit == 0) {
            return Collections.emptyList();
        }
        if (offset >= list.size()) {
            return Collections.emptyList();
        }
        if (limit < 0) {
            return list.subList(offset, list.size());
        }
        int lastIndex = offset + limit;
        if (lastIndex < 0 || lastIndex >= list.size()) {
            return list.subList(offset, list.size());
        }
        return list.subList(offset, lastIndex);
    }

    private List<List<Object>> getPropertyValues(List<?> modelKeys, List<String> properties) {
        assert (modelKeys != null);
        assert (properties != null);
        if (modelKeys.isEmpty()) {
            return Collections.emptyList();
        }
        if (properties.isEmpty()) {
            return Collections.nCopies(modelKeys.size(), Collections.emptyList());
        }
        return this._data.get(modelKeys, properties);
    }

    private static boolean operatorIsEquality(PropertyPredicate.ComparisonOperator operator) {
        return operator == PropertyPredicate.ComparisonOperator.EQUAL || operator == PropertyPredicate.ComparisonOperator.IN;
    }
}

