/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.tagging;

import com.vmware.cis.data.internal.adapters.tagging.TagDataProviderConnection;
import com.vmware.cis.data.internal.adapters.tagging.TaggingVapiAuthenticator;
import com.vmware.cis.data.internal.adapters.util.vapi.SessionAwareApiProvider;
import com.vmware.cis.data.internal.adapters.util.vapi.SessionAwareVapiConnectionCloseable;
import com.vmware.cis.data.internal.adapters.util.vapi.VapiAuthenticator;
import com.vmware.cis.data.internal.adapters.util.vapi.VapiProtocolConnectionFactory;
import com.vmware.cis.data.internal.adapters.util.vapi.VapiSession;
import com.vmware.cis.data.internal.provider.AuthenticationTokenSource;
import com.vmware.cis.data.internal.provider.DataProviderConnection;
import com.vmware.cis.data.internal.provider.DataProviderConnector;
import com.vmware.cis.data.provider.DataProvider;
import com.vmware.vapi.protocol.ProtocolConnection;
import java.net.URI;
import java.security.KeyStore;
import org.apache.commons.lang.Validate;

public final class TagDataProvider
implements DataProviderConnector {
    private final VapiProtocolConnectionFactory _vApiConnectionFactory;
    private final URI _taggingVapiUri;
    private final KeyStore _trustStore;
    private final VapiAuthenticator _authenticator;

    public TagDataProvider(VapiProtocolConnectionFactory vApiConnectionFactory, URI taggingVapiUri, KeyStore trustStore) {
        Validate.notNull((Object)vApiConnectionFactory);
        Validate.notNull((Object)taggingVapiUri);
        this._vApiConnectionFactory = vApiConnectionFactory;
        this._taggingVapiUri = taggingVapiUri;
        this._trustStore = trustStore;
        this._authenticator = new TaggingVapiAuthenticator(vApiConnectionFactory, taggingVapiUri, trustStore);
    }

    public DataProviderConnection getConnection(AuthenticationTokenSource authn) {
        Validate.notNull((Object)authn);
        VapiSession session = this._authenticator.login(authn);
        ProtocolConnection connection = this._vApiConnectionFactory.connect(this._taggingVapiUri, this._trustStore);
        SessionAwareApiProvider apiProvider = new SessionAwareApiProvider(connection.getApiProvider(), session, this._taggingVapiUri);
        final SessionAwareVapiConnectionCloseable vapiConnection = new SessionAwareVapiConnectionCloseable(connection, session);
        final TagDataProviderConnection tagProvider = new TagDataProviderConnection(apiProvider, this._taggingVapiUri);
        return new DataProviderConnection(){

            public void close() throws Exception {
                vapiConnection.close();
            }

            public DataProvider getDataProvider() {
                return tagProvider;
            }
        };
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(url=" + this._taggingVapiUri + ")";
    }
}

