/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.tagging;

import com.vmware.cis.data.internal.adapters.federation.IdentifiableServiceInstance;
import com.vmware.cis.data.internal.adapters.federation.ServiceEndpointDiscovery;
import com.vmware.cis.data.internal.adapters.lookup.ServiceEndpointInfo;
import com.vmware.cis.data.internal.adapters.lookup.ServiceLocator;
import com.vmware.cis.data.internal.provider.SsoDomain;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.Validate;

public final class TaggingDiscovery {
    private static final String PRODUCT_CIS = "com.vmware.cis";
    private static final String SERVICE_TYPE_INVSVC = "cs.inventory";
    private static final String ENDPOINT_INVSVC_VAPI = "com.vmware.cis.inventory.vapi";
    private static final String PROTOCOL_VAPI = "vapi.json.https";

    public static Collection<ServiceEndpointInfo> findTaggingEndpoints(ServiceLocator serviceLocator) {
        Validate.notNull((Object)serviceLocator);
        return serviceLocator.findServiceEndpoints(PRODUCT_CIS, SERVICE_TYPE_INVSVC, ENDPOINT_INVSVC_VAPI, PROTOCOL_VAPI);
    }

    public static ServiceEndpointInfo chooseEndpointForTagAndCategoryData(Collection<ServiceEndpointInfo> taggingEndpoints, Map<String, IdentifiableServiceInstance> vpxdInstanceIdByNode, SsoDomain localSsoDomain) {
        assert (taggingEndpoints != null);
        for (ServiceEndpointInfo e : taggingEndpoints) {
            if (!"http".equals(e.getUrl().getScheme())) continue;
            return e;
        }
        Collection<ServiceEndpointInfo> supportedEndpoints = ServiceEndpointDiscovery.onlySupported(taggingEndpoints, vpxdInstanceIdByNode);
        if (supportedEndpoints.isEmpty()) {
            return null;
        }
        if (localSsoDomain == null) {
            return supportedEndpoints.iterator().next();
        }
        for (ServiceEndpointInfo e : supportedEndpoints) {
            if (!localSsoDomain.equals((Object)e.getSsoDomain())) continue;
            return e;
        }
        return supportedEndpoints.iterator().next();
    }
}

