/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.util.vapi;

import com.google.common.collect.MapMaker;
import com.google.common.util.concurrent.Striped;
import com.vmware.cis.data.internal.adapters.util.vapi.VapiProtocolConnectionFactory;
import com.vmware.vapi.cis.authn.ProtocolFactory;
import com.vmware.vapi.core.ApiProvider;
import com.vmware.vapi.core.ApiProviderStub;
import com.vmware.vapi.protocol.ClientConfiguration;
import com.vmware.vapi.protocol.HttpConfiguration;
import com.vmware.vapi.protocol.ProtocolConnection;
import java.net.URI;
import java.security.KeyStore;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SharedProtocolConnectionFactory
implements VapiProtocolConnectionFactory {
    private static final int DEFAULT_MAX_CONNECTIONS = 50;
    private static final int DEFAULT_READ_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(60L);
    private static final int DEFAULT_KEEP_ALIVE = (int)TimeUnit.SECONDS.toMillis(25L);
    private static final Logger logger = LoggerFactory.getLogger(SharedProtocolConnectionFactory.class);
    private final ProtocolFactory _protocolFactory = new ProtocolFactory();
    private final Striped<Lock> _connectionGuard = Striped.lock((int)Runtime.getRuntime().availableProcessors());
    private final ConcurrentMap<Key, PooledConnection> _connectionPool = new MapMaker().weakValues().makeMap();
    private final int _maxConnections;
    private final int _readTimeoutMs;
    private final int _keepAlivePeriodMs;

    public SharedProtocolConnectionFactory() {
        this(50, DEFAULT_READ_TIMEOUT, DEFAULT_KEEP_ALIVE);
    }

    public SharedProtocolConnectionFactory(int maxConnections, int readTimeoutMs, int keepAlivePeriodMs) {
        this._maxConnections = maxConnections;
        this._readTimeoutMs = readTimeoutMs;
        this._keepAlivePeriodMs = keepAlivePeriodMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProtocolConnection connect(URI endpoint, KeyStore trustStore) {
        Key poolKey = new Key(endpoint, trustStore);
        Lock guard = (Lock)this._connectionGuard.get((Object)poolKey);
        guard.lock();
        try {
            PooledConnection connection = (PooledConnection)this._connectionPool.get(poolKey);
            if (connection != null) {
                ++connection.leaseCount;
                logger.debug("Reusing existing vAPI ProtocolConnection to: {} . The new lease count is: {}.", (Object)endpoint, (Object)connection.leaseCount);
            } else {
                logger.debug("Creating new vAPI ProtocolConnection to endpoint: {}", (Object)endpoint);
                connection = this.createNewConnection(endpoint, trustStore);
                this._connectionPool.put(poolKey, connection);
            }
            LeasedConnection leasedConnection = new LeasedConnection(poolKey, connection);
            return leasedConnection;
        }
        finally {
            guard.unlock();
        }
    }

    private PooledConnection createNewConnection(URI endpoint, KeyStore trustStore) {
        ProtocolConnection rawConnection = this.createRawConnection(endpoint, trustStore);
        return new PooledConnection(rawConnection);
    }

    private ProtocolConnection createRawConnection(URI endpoint, KeyStore trustStore) {
        Validate.notNull((Object)endpoint, (String)"The endpoint is required.");
        boolean useSsl = "https".equals(endpoint.getScheme());
        if (useSsl) {
            Validate.notNull((Object)trustStore, (String)"trustStore is required for https endpoint");
        }
        HttpConfiguration.SslConfiguration sslConfig = useSsl ? new HttpConfiguration.SslConfiguration(trustStore) : null;
        HttpConfiguration httpConfig = new HttpConfiguration.Builder().setSslConfiguration(sslConfig).setMaxConnections(this._maxConnections).setSoTimeout(this._readTimeoutMs).setKeepAlivePeriod((long)this._keepAlivePeriodMs).setLibraryType(HttpConfiguration.LibType.APACHE_HTTP_ASYNC_CLIENT).getConfig();
        ClientConfiguration clientConfiguration = new ClientConfiguration.Builder().getConfig();
        return this._protocolFactory.getHttpConnection(endpoint.toString(), clientConfiguration, httpConfig);
    }

    private static final class Key {
        public final URI endpoint;
        public final KeyStore trustStore;

        public Key(URI endpoint, KeyStore trustStore) {
            this.endpoint = endpoint;
            this.trustStore = trustStore;
        }

        public int hashCode() {
            return new HashCodeBuilder(37, 41).append((Object)this.endpoint).append(System.identityHashCode(this.trustStore)).toHashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof Key) {
                Key right = (Key)other;
                return ObjectUtils.equals((Object)this.endpoint, (Object)right.endpoint) && ObjectUtils.equals((Object)this.trustStore, (Object)right.trustStore);
            }
            return false;
        }
    }

    private static final class PooledConnection {
        public final ProtocolConnection rawConnection;
        public int leaseCount;

        public PooledConnection(ProtocolConnection connection) {
            this.rawConnection = connection;
            this.leaseCount = 1;
        }
    }

    private final class LeasedConnection
    implements ProtocolConnection {
        private final Key _poolKey;
        private final PooledConnection _pooledConnection;
        private final AtomicBoolean _connected = new AtomicBoolean(true);

        public LeasedConnection(Key poolKey, PooledConnection pooledConnection) {
            this._poolKey = poolKey;
            this._pooledConnection = pooledConnection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void disconnect() {
            if (!this._connected.getAndSet(false)) {
                return;
            }
            boolean mustDisconnect = false;
            Lock guard = (Lock)SharedProtocolConnectionFactory.this._connectionGuard.get((Object)this._poolKey);
            guard.lock();
            try {
                --this._pooledConnection.leaseCount;
                if (this._pooledConnection.leaseCount <= 0) {
                    mustDisconnect = true;
                    SharedProtocolConnectionFactory.this._connectionPool.remove(this._poolKey);
                }
            }
            finally {
                guard.unlock();
                if (mustDisconnect) {
                    logger.info("Closing vAPI ProtocolConnection connection to: {}", (Object)this._poolKey.endpoint);
                    this._pooledConnection.rawConnection.disconnect();
                }
            }
        }

        public ApiProvider getApiProvider() {
            return this._pooledConnection.rawConnection.getApiProvider();
        }

        public ApiProviderStub getApiProviderStub() {
            return this._pooledConnection.rawConnection.getApiProviderStub();
        }
    }
}

