/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.vapi;

import com.vmware.cis.data.internal.adapters.util.vapi.DefaultVapiAuthenticatorFactory;
import com.vmware.cis.data.internal.adapters.util.vapi.SharedProtocolConnectionFactory;
import com.vmware.cis.data.internal.adapters.util.vapi.VapiAuthenticatorFactory;
import com.vmware.cis.data.internal.adapters.util.vapi.VapiProtocolConnectionFactory;
import com.vmware.cis.data.internal.adapters.vapi.VapiPropertyValueConverter;
import com.vmware.cis.data.internal.adapters.vapi.impl.DefaultVapiPropertyValueConverter;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.Validate;

public final class VapiDataProviderConfig {
    private final VapiProtocolConnectionFactory vApiConnectionFactory;
    private final VapiPropertyValueConverter propertyValueConverter;
    private final VapiAuthenticatorFactory customAuthFactory;
    private final Collection<Class<?>> queryModels;

    private VapiDataProviderConfig(VapiProtocolConnectionFactory vApiConnectionFactory, VapiPropertyValueConverter valueConverter, VapiAuthenticatorFactory customAuthFactory, Collection<Class<?>> queryModels) {
        assert (vApiConnectionFactory != null);
        assert (valueConverter != null);
        assert (customAuthFactory != null);
        assert (queryModels != null);
        this.vApiConnectionFactory = vApiConnectionFactory;
        this.propertyValueConverter = valueConverter;
        this.customAuthFactory = customAuthFactory;
        this.queryModels = queryModels;
    }

    public VapiPropertyValueConverter getPropertyValueConverter() {
        return this.propertyValueConverter;
    }

    public VapiProtocolConnectionFactory getVApiConnectionFactory() {
        return this.vApiConnectionFactory;
    }

    public VapiAuthenticatorFactory getAuthenticatorFactory() {
        return this.customAuthFactory;
    }

    public Collection<Class<?>> getExtendedModels() {
        return this.queryModels;
    }

    public static final class Builder {
        private VapiPropertyValueConverter propertyValueConverter = new DefaultVapiPropertyValueConverter();
        private VapiProtocolConnectionFactory vApiConnectionFactory = new SharedProtocolConnectionFactory();
        private VapiAuthenticatorFactory customAuthFactory = null;
        private Collection<Class<?>> _queryModels;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public Builder withPropertyValueConverter(VapiPropertyValueConverter propertyValueConverter) {
            Validate.notNull((Object)propertyValueConverter);
            this.propertyValueConverter = propertyValueConverter;
            return this;
        }

        public Builder withVapiConnectionFactory(VapiProtocolConnectionFactory vapiConnectionFactory) {
            Validate.notNull((Object)vapiConnectionFactory);
            this.vApiConnectionFactory = vapiConnectionFactory;
            return this;
        }

        public Builder withAuthenticatorFactory(VapiAuthenticatorFactory customAuthFactory) {
            Validate.notNull((Object)customAuthFactory);
            this.customAuthFactory = customAuthFactory;
            return this;
        }

        public Builder withExtendedModels(Collection<Class<?>> queryModels) {
            Validate.notNull(queryModels);
            this._queryModels = queryModels;
            return this;
        }

        public VapiDataProviderConfig build() {
            Collection<Object> queryModelsToUse = this._queryModels == null ? Collections.emptyList() : this._queryModels;
            return new VapiDataProviderConfig(this.vApiConnectionFactory, this.propertyValueConverter, new DefaultVapiAuthenticatorFactory(this.vApiConnectionFactory, this.customAuthFactory), queryModelsToUse);
        }
    }
}

