/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.vapi.impl;

import com.vmware.cis.data.internal.adapters.vapi.VapiPropertyValueConverter;
import com.vmware.cis.data.internal.adapters.vapi.impl.VapiValueConverter;
import com.vmware.vapi.data.BooleanValue;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.DoubleValue;
import com.vmware.vapi.data.IntegerValue;
import com.vmware.vapi.data.StringValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class DefaultVapiPropertyValueConverter
implements VapiPropertyValueConverter {
    @Override
    public Object fromVapiResultDataValue(String property, DataValue resourceTypeValue, DataValue dataValue) {
        assert (property != null);
        assert (dataValue != null);
        return VapiValueConverter.fromDataValue(dataValue);
    }

    @Override
    public DataValue toVapiComparableValue(String property, Object comparableValue) {
        assert (property != null);
        assert (comparableValue != null);
        if (comparableValue instanceof Integer) {
            Integer integerValue = (Integer)comparableValue;
            return new IntegerValue(integerValue.longValue());
        }
        if (comparableValue instanceof Long) {
            return new IntegerValue(((Long)comparableValue).longValue());
        }
        if (comparableValue instanceof Boolean) {
            return BooleanValue.getInstance((boolean)((Boolean)comparableValue));
        }
        if (comparableValue instanceof String) {
            return new StringValue((String)comparableValue);
        }
        if (comparableValue instanceof Float) {
            Float floatValue = (Float)comparableValue;
            return new DoubleValue(floatValue.doubleValue());
        }
        if (comparableValue instanceof Double) {
            return new DoubleValue(((Double)comparableValue).doubleValue());
        }
        throw new IllegalArgumentException("Unsupported type " + comparableValue.getClass());
    }

    @Override
    public List<DataValue> toVapiComparableList(String property, Collection<?> comparableCollection) {
        assert (property != null);
        assert (comparableCollection != null);
        ArrayList<DataValue> vapiComparableList = new ArrayList<DataValue>(comparableCollection.size());
        for (Object comparableElement : comparableCollection) {
            vapiComparableList.add(this.toVapiComparableValue(property, comparableElement));
        }
        return vapiComparableList;
    }

    @Override
    public boolean isTypeRequired() {
        return false;
    }
}

