/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.vapi.impl;

import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.internal.adapters.util.vapi.VapiOsgiAwareStubFactory;
import com.vmware.cis.data.internal.adapters.vapi.VapiDataProviderConfig;
import com.vmware.cis.data.internal.adapters.vapi.impl.VapiDataProviderQueryConverter;
import com.vmware.cis.data.internal.adapters.vapi.impl.VapiDataProviderResultSetConverter;
import com.vmware.cis.data.internal.adapters.vapi.impl.VapiDataProviderSchemaConverter;
import com.vmware.cis.data.provider.DataProvider;
import com.vmware.cis.data.provider.metadata.vapi.Schema;
import com.vmware.cis.data.provider.vapi.ResourceModel;
import com.vmware.cis.data.provider.vapi.ResourceModelTypes;
import com.vmware.vapi.core.ApiProvider;
import com.vmware.vapi.std.errors.InvalidArgument;
import com.vmware.vapi.std.errors.Unauthorized;
import java.net.URI;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VapiDataProviderConnection
implements DataProvider {
    private static final Logger _logger = LoggerFactory.getLogger(VapiDataProviderConnection.class);
    private final VapiOsgiAwareStubFactory _stubFactory;
    private final Schema _schemaStub;
    private final ResourceModel _resourceModelStub;
    private final VapiDataProviderQueryConverter _queryConverter;
    private final VapiDataProviderResultSetConverter _resultConverter;
    private final URI _uri;

    public VapiDataProviderConnection(ApiProvider apiProvider, VapiDataProviderConfig cfg, URI uri) {
        assert (apiProvider != null);
        assert (cfg != null);
        assert (uri != null);
        this._stubFactory = new VapiOsgiAwareStubFactory(apiProvider);
        this._resourceModelStub = this._stubFactory.createStub(ResourceModel.class);
        this._schemaStub = this._stubFactory.createStub(Schema.class);
        this._queryConverter = new VapiDataProviderQueryConverter(cfg.getPropertyValueConverter());
        this._resultConverter = new VapiDataProviderResultSetConverter(cfg.getPropertyValueConverter());
        this._uri = uri;
    }

    public ResultSet executeQuery(Query query) {
        ResourceModelTypes.ResultSet vapiResult;
        Validate.notNull((Object)query);
        ResourceModelTypes.QuerySpec vapiQuery = this._queryConverter.convertQuery(query);
        _logger.trace("Sending query to vAPI data provider: {}", (Object)query);
        try {
            vapiResult = this._resourceModelStub.query(vapiQuery);
        }
        catch (InvalidArgument ex) {
            throw new IllegalArgumentException("Invalid query", ex);
        }
        catch (Unauthorized ex) {
            _logger.trace("Return empty result because user is unauthorized");
            return ResultSet.Builder.properties((List)query.getProperties()).totalCount(query.getWithTotalCount() ? Integer.valueOf(0) : null).build();
        }
        _logger.trace("Received response from vAPI data provider: {}", (Object)vapiResult);
        return this._resultConverter.convertResultSet(vapiResult, query.getProperties(), query.getLimit(), query.getWithTotalCount());
    }

    public QuerySchema getSchema() {
        try {
            _logger.trace("Requesting schema from vAPI data provider");
            QuerySchema schema = VapiDataProviderSchemaConverter.convertSchema(this._schemaStub.get());
            _logger.trace("Received schema from vAPI data provider: {}", (Object)schema);
            return schema;
        }
        catch (Unauthorized ex) {
            _logger.trace("Return empty schema because user is unauthorized");
            return QuerySchema.EMPTY_SCHEMA;
        }
    }

    public String toString() {
        return "VapiConnection(url=" + this._uri + ")";
    }
}

