/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.vapi.impl;

import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.internal.adapters.vapi.VapiPropertyValueConverter;
import com.vmware.cis.data.internal.util.PropertyUtil;
import com.vmware.cis.data.provider.vapi.ResourceModelTypes;
import com.vmware.vapi.data.DataValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;

final class VapiDataProviderResultSetConverter {
    private final VapiPropertyValueConverter _propertyValueConverter;

    VapiDataProviderResultSetConverter(VapiPropertyValueConverter propertyValueConverter) {
        assert (propertyValueConverter != null);
        this._propertyValueConverter = propertyValueConverter;
    }

    public ResultSet convertResultSet(ResourceModelTypes.ResultSet vapiResultSet, List<String> properties, int limit, boolean withTotalCount) {
        Validate.notNull((Object)vapiResultSet);
        ResultSet.Builder resultBuilder = ResultSet.Builder.properties(properties);
        if (limit != 0) {
            this.convertItems(resultBuilder, vapiResultSet.getItems(), vapiResultSet.getProperties(), properties);
        }
        Integer totalCount = VapiDataProviderResultSetConverter.getTotalCount(vapiResultSet, withTotalCount);
        return resultBuilder.totalCount(totalCount).build();
    }

    private static Integer getTotalCount(ResourceModelTypes.ResultSet vapiResultSet, boolean withTotalCount) {
        if (withTotalCount) {
            if (vapiResultSet.getTotalCount() == null) {
                throw new IllegalArgumentException("Response does not contain total item count");
            }
            return vapiResultSet.getTotalCount().intValue();
        }
        return null;
    }

    private void convertItems(ResultSet.Builder resultBuilder, List<ResourceModelTypes.ResourceItem> vapiItems, List<String> vapiProperties, List<String> queryProperties) {
        if (vapiItems == null) {
            return;
        }
        int keyPosition = VapiDataProviderResultSetConverter.getKeyPosition(vapiProperties);
        int typePosition = vapiProperties.indexOf("@type");
        for (int i = 0; i < vapiItems.size(); ++i) {
            ResourceModelTypes.ResourceItem vapiItem = vapiItems.get(i);
            DataValue vapiKey = (DataValue)vapiItem.getPropertyValues().get(keyPosition);
            DataValue vapiType = typePosition == -1 ? null : (DataValue)vapiItem.getPropertyValues().get(typePosition);
            List<Object> item = this.convertItem(vapiItem, vapiType, vapiProperties, queryProperties);
            Object key = this._propertyValueConverter.fromVapiResultDataValue("@modelKey", vapiType, vapiKey);
            resultBuilder.item(key, item);
        }
    }

    private static int getKeyPosition(List<String> properties) {
        int index = 0;
        for (String property : properties) {
            if (PropertyUtil.isModelKey((String)property)) {
                return index;
            }
            ++index;
        }
        throw new IllegalArgumentException("No key in the vapi properties.");
    }

    private List<Object> convertItem(ResourceModelTypes.ResourceItem vapiItem, DataValue vapiType, List<String> vapiProperties, List<String> queryProperties) {
        Validate.notNull(vapiProperties);
        if (vapiProperties.size() != vapiItem.getPropertyValues().size()) {
            throw new IllegalArgumentException(String.format("The number of property values in a vAPI ResourceItem does not match the number of properties in the vAPI ResultSet: %d != %d", vapiItem.getPropertyValues().size(), vapiProperties.size()));
        }
        Map<String, DataValue> vapiValueByProperty = this.toVapiValueByProperty(vapiItem.getPropertyValues(), vapiProperties);
        ArrayList<Object> values = new ArrayList<Object>(queryProperties.size());
        for (String property : queryProperties) {
            DataValue vapiValue = vapiValueByProperty.get(property);
            Object value = null;
            if (vapiValue != null) {
                value = this._propertyValueConverter.fromVapiResultDataValue(property, vapiType, vapiValue);
            }
            values.add(value);
        }
        return values;
    }

    private Map<String, DataValue> toVapiValueByProperty(List<DataValue> vapiValues, List<String> vapiProperties) {
        assert (vapiValues != null);
        assert (vapiProperties != null);
        assert (vapiValues.size() == vapiProperties.size());
        HashMap<String, DataValue> valueByProperty = new HashMap<String, DataValue>(vapiValues.size());
        Iterator<DataValue> valueIt = vapiValues.iterator();
        for (String vapiProperty : vapiProperties) {
            DataValue dataValue = valueIt.next();
            if (dataValue == null) continue;
            valueByProperty.put(vapiProperty, dataValue);
        }
        return valueByProperty;
    }
}

