/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.vmomi.impl;

import com.vmware.cis.data.internal.adapters.federation.ServiceEndpointDiscovery;
import com.vmware.cis.data.internal.adapters.lookup.ServiceEndpointInfo;
import com.vmware.cis.data.internal.adapters.vmomi.VmomiAuthenticator;
import com.vmware.cis.data.internal.adapters.vmomi.VmomiAuthenticatorFactory;
import com.vmware.cis.data.internal.adapters.vmomi.VmomiSession;
import com.vmware.cis.data.internal.adapters.vmomi.impl.HttpConfigurationFactory;
import com.vmware.cis.data.internal.adapters.vmomi.impl.VcVmomiAuthenticator;
import com.vmware.cis.data.internal.provider.AuthenticationTokenSource;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultVmomiAuthenticatorFactory
implements VmomiAuthenticatorFactory {
    private static final Logger _logger = LoggerFactory.getLogger(DefaultVmomiAuthenticatorFactory.class);
    private final VmodlContext _vmodlContext;
    private final HttpConfigurationFactory _httpConfigFactory;
    private final VmomiAuthenticatorFactory _userSuppliedFactory;

    public DefaultVmomiAuthenticatorFactory(VmodlContext vmodlContext, HttpConfigurationFactory httpConfigFactory, VmomiAuthenticatorFactory userSuppliedFactory) {
        Validate.notNull((Object)vmodlContext);
        Validate.notNull((Object)httpConfigFactory);
        this._vmodlContext = vmodlContext;
        this._httpConfigFactory = httpConfigFactory;
        this._userSuppliedFactory = userSuppliedFactory;
    }

    @Override
    public VmomiAuthenticator getAuthenticator(ServiceEndpointInfo serviceInfo) {
        Validate.notNull((Object)serviceInfo);
        VmomiAuthenticator customAuthenticator = this.createCustomAuthenticator(serviceInfo);
        if (customAuthenticator != null) {
            _logger.debug("Authenticator from custom-supplied factory will be used for endpoint: {}", (Object)serviceInfo);
            return customAuthenticator;
        }
        if (ServiceEndpointDiscovery.PROVIDER_TYPE_VC.equals(serviceInfo.getServiceType())) {
            HttpConfiguration httpConfig = this._httpConfigFactory.createConfiguration(serviceInfo.getUrl(), serviceInfo.getTrustStore());
            _logger.debug("VcVmomiAuthenticator will be used for vpxd endpoint: {}", (Object)serviceInfo);
            return new VcVmomiAuthenticator(this._vmodlContext, serviceInfo.getUrl(), httpConfig);
        }
        _logger.debug("Provider will be used without authentication: {}", (Object)serviceInfo);
        return new NullVmomiAuthenticator();
    }

    private VmomiAuthenticator createCustomAuthenticator(ServiceEndpointInfo serviceInfo) {
        if (this._userSuppliedFactory != null) {
            return this._userSuppliedFactory.getAuthenticator(serviceInfo);
        }
        return null;
    }

    private static final class NullVmomiAuthenticator
    implements VmomiAuthenticator {
        private NullVmomiAuthenticator() {
        }

        @Override
        public VmomiSession login(AuthenticationTokenSource authn) {
            return null;
        }
    }
}

