/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.vmomi.impl;

import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.internal.adapters.vmomi.impl.VimSearchModel;
import com.vmware.cis.data.internal.adapters.vmomi.impl.VlsiClientUtil;
import com.vmware.cis.data.internal.adapters.vmomi.impl.VmomiDataProviderQueryConverter;
import com.vmware.cis.data.internal.adapters.vmomi.impl.VmomiDataProviderResultSetConverter;
import com.vmware.cis.data.internal.adapters.vmomi.impl.VmomiDataProviderSchemaConverter;
import com.vmware.cis.data.internal.provider.ext.search.SearchModelDescriptor;
import com.vmware.cis.data.internal.provider.profiler.QueryIdLogConfigurator;
import com.vmware.cis.data.internal.provider.schema.QuerySchemaCache;
import com.vmware.cis.data.internal.provider.schema.QuerySchemaCacheFactory;
import com.vmware.cis.data.internal.util.QueryMarker;
import com.vmware.cis.data.provider.DataProvider;
import com.vmware.vim.binding.cis.data.provider.BatchQuerySpec;
import com.vmware.vim.binding.cis.data.provider.BatchResultSet;
import com.vmware.vim.binding.cis.data.provider.QuerySpec;
import com.vmware.vim.binding.cis.data.provider.ResourceModel;
import com.vmware.vim.binding.cis.data.provider.schema.ResourceModelInfo;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.fault.InvalidArgument;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.core.RequestContext;
import com.vmware.vim.vmomi.core.Stub;
import com.vmware.vim.vmomi.core.impl.RequestContextImpl;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VmomiDataProviderConnection
implements DataProvider {
    private static final Logger _logger = LoggerFactory.getLogger(VmomiDataProviderConnection.class);
    private static final SearchModelDescriptor _vimSearch = VimSearchModel.createVimSearchModel();
    private final Client _vlsiClient;
    private final URI _serviceUri;
    private final QuerySchemaCache _schemaCache;
    private final String _schemaCacheKey;
    private final Callable<QuerySchema> _schemaGet;
    private final AtomicInteger _isBatchSupported = new AtomicInteger(-1);

    public VmomiDataProviderConnection(Client vlsiClient) {
        this(vlsiClient, QuerySchemaCacheFactory.createNoOpCache(), "");
    }

    public VmomiDataProviderConnection(Client vlsiClient, QuerySchemaCache schemaCache, String serviceTypeAndVersion) {
        assert (vlsiClient != null);
        assert (schemaCache != null);
        assert (serviceTypeAndVersion != null);
        this._vlsiClient = vlsiClient;
        this._serviceUri = vlsiClient.getBinding().getEndpointUri();
        this._schemaCache = schemaCache;
        this._schemaCacheKey = "VmomiDataProvider:" + serviceTypeAndVersion;
        this._schemaGet = new Callable<QuerySchema>(){

            @Override
            public QuerySchema call() {
                QuerySchema schema = VmomiDataProviderConnection.this.getSchemaImpl();
                QuerySchema extSchema = _vimSearch.addModel(schema);
                return extSchema;
            }

            public String toString() {
                return "Get Schema from " + VmomiDataProviderConnection.this._serviceUri;
            }
        };
    }

    public ResultSet executeQuery(Query query) {
        assert (query != null);
        if (_vimSearch.isSearchQuery(query)) {
            return this.executeSearchQuery(query);
        }
        return this.executeSingleQuery(query);
    }

    public QuerySchema getSchema() {
        return this._schemaCache.get(this._schemaCacheKey, this._schemaGet);
    }

    public String toString() {
        return "VmomiConnection(url=" + this._serviceUri + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QuerySchema getSchemaImpl() {
        ResourceModel resourceModelStub = VmomiDataProviderConnection.createStub(this._vlsiClient);
        ClassLoader originalLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(VlsiClientUtil.class.getClassLoader());
        try {
            _logger.trace("Requesting schema from VC data provider");
            ResourceModelInfo[] models = resourceModelStub.getSchema();
            QuerySchema schema = VmomiDataProviderSchemaConverter.convertSchema(models);
            _logger.trace("Received schema from VC data provider: {}", (Object)schema);
            QuerySchema querySchema = schema;
            return querySchema;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalLoader);
        }
    }

    private ResultSet executeSearchQuery(Query query) {
        assert (query != null);
        Collection childQueries = _vimSearch.toChildQueries(query);
        Collection<ResultSet> childResults = this.executeQueryBatch(childQueries);
        return _vimSearch.toAggregatedResult(childResults, query);
    }

    private ResultSet executeSingleQuery(Query query) {
        assert (query != null);
        QuerySpec querySpec = VmomiDataProviderQueryConverter.convertQuery(query);
        if (querySpec == null) {
            return ResultSet.Builder.properties((List)query.getProperties()).totalCount(query.getWithTotalCount() ? Integer.valueOf(0) : null).build();
        }
        com.vmware.vim.binding.cis.data.provider.ResultSet vmodlResult = this.query(querySpec);
        return VmomiDataProviderResultSetConverter.convertResultSet(vmodlResult, query);
    }

    private Collection<ResultSet> executeQueryBatch(Collection<Query> queryBatch) {
        assert (queryBatch != null);
        if (this.isBatchSupported()) {
            return this.executeQueryBatchNative(queryBatch);
        }
        return this.executeQueryBatchBackCompat(queryBatch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<ResultSet> executeQueryBatchBackCompat(Collection<Query> queryBatch) {
        assert (queryBatch != null);
        QueryIdLogConfigurator.QueryCounter queryCounter = QueryIdLogConfigurator.newQueryCounter((String)"");
        long beginTime = System.currentTimeMillis();
        ArrayList<ResultSet> resultBatch = new ArrayList<ResultSet>(queryBatch.size());
        for (Query query : queryBatch) {
            ResultSet result;
            if (Thread.currentThread().isInterrupted()) {
                long totalTime = System.currentTimeMillis() - beginTime;
                throw new RuntimeException(String.format("Interrupted vmomi query batch after %d ms execution. Executed %d out of %d queries.", totalTime, resultBatch.size(), queryBatch.size()));
            }
            try (QueryIdLogConfigurator logCfg = queryCounter.onQueryStart();){
                result = this.executeQuery(query);
            }
            resultBatch.add(result);
        }
        return resultBatch;
    }

    private Collection<ResultSet> executeQueryBatchNative(Collection<Query> queryBatch) {
        assert (queryBatch != null);
        QuerySpec[] querySpecs = VmomiDataProviderQueryConverter.convertQueries(queryBatch);
        com.vmware.vim.binding.cis.data.provider.ResultSet[] vmodlResults = this.queryBatch(querySpecs);
        Collection<ResultSet> results = VmomiDataProviderResultSetConverter.convertResultSets(vmodlResults, queryBatch);
        return results;
    }

    private com.vmware.vim.binding.cis.data.provider.ResultSet query(QuerySpec query) {
        try {
            return this.queryImpl(query);
        }
        catch (InvalidArgument ex) {
            throw new IllegalArgumentException("Invalid query", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private com.vmware.vim.binding.cis.data.provider.ResultSet queryImpl(QuerySpec query) {
        com.vmware.vim.binding.cis.data.provider.ResultSet result;
        ResourceModel resourceModelStub = VmomiDataProviderConnection.createStub(this._vlsiClient);
        ClassLoader originalLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(VlsiClientUtil.class.getClassLoader());
        try {
            _logger.trace("Sending query {} to VC data provider at {}\n{}", new Object[]{QueryMarker.getQueryId(), this._serviceUri, query});
            result = resourceModelStub.query(query);
            _logger.trace("Received response from VC data provider:\n{}", (Object)result);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalLoader);
        }
        return result;
    }

    private com.vmware.vim.binding.cis.data.provider.ResultSet[] queryBatch(QuerySpec[] query) {
        try {
            return this.queryBatchImpl(query);
        }
        catch (InvalidArgument ex) {
            throw new IllegalArgumentException("Invalid query in query batch", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private com.vmware.vim.binding.cis.data.provider.ResultSet[] queryBatchImpl(QuerySpec[] queryBatch) {
        Object[] results;
        ResourceModel resourceModelStub = VmomiDataProviderConnection.createStub(this._vlsiClient);
        ClassLoader originalLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(VlsiClientUtil.class.getClassLoader());
        try {
            if (_logger.isTraceEnabled()) {
                _logger.trace("Sending query batch '{}' to VC data provider at {} :\n{}", new Object[]{QueryMarker.getQueryId(), this._serviceUri, Arrays.toString(queryBatch)});
            }
            BatchQuerySpec batchSpec = new BatchQuerySpec();
            batchSpec.setQuerySpecs(queryBatch);
            BatchResultSet batchResult = resourceModelStub.queryBatch(batchSpec);
            results = batchResult.getResultSets();
            if (_logger.isTraceEnabled()) {
                _logger.trace("Received response batch from VC data provider at {} :\n{}", (Object)this._serviceUri, (Object)Arrays.toString(results));
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalLoader);
        }
        return results;
    }

    private boolean isBatchSupported() {
        int batchSupported = this._isBatchSupported.get();
        if (batchSupported >= 0) {
            return batchSupported > 0;
        }
        QuerySchema schema = this.getSchema();
        QuerySchema.ModelInfo hsInfo = (QuerySchema.ModelInfo)schema.getModels().get("HostSystem");
        QuerySchema.PropertyInfo hostMemoryUsage = null;
        if (hsInfo != null) {
            hostMemoryUsage = (QuerySchema.PropertyInfo)hsInfo.getProperties().get("memoryUsage");
        }
        batchSupported = hostMemoryUsage != null ? 1 : 0;
        this._isBatchSupported.compareAndSet(-1, batchSupported);
        return batchSupported > 0;
    }

    private static ResourceModel createStub(Client vlsiClient) {
        ManagedObjectReference ref = new ManagedObjectReference("DPResourceModel", "ResourceModel", null);
        ResourceModel stub = VlsiClientUtil.createStub(vlsiClient, ResourceModel.class, ref);
        VmomiDataProviderConnection.setOpId((ManagedObject)stub);
        return stub;
    }

    private static void setOpId(ManagedObject mo) {
        String opId = QueryMarker.getQueryId();
        if (opId == null) {
            return;
        }
        VmomiDataProviderConnection.getRequestContext(mo).put((Object)"operationID", (Object)opId);
    }

    private static RequestContextImpl getRequestContext(ManagedObject mo) {
        Stub stub = (Stub)mo;
        RequestContextImpl rc = (RequestContextImpl)stub._getRequestContext();
        if (rc == null) {
            rc = new RequestContextImpl();
            stub._setRequestContext((RequestContext)rc);
        }
        return rc;
    }
}

