/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.vmomi.impl;

import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.internal.adapters.vmomi.util.VmomiProperty;
import com.vmware.cis.data.internal.util.PropertyUtil;
import com.vmware.vim.binding.cis.data.provider.OptionalPropertyValue;
import com.vmware.vim.binding.cis.data.provider.ResourceItem;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.cis.CisIdConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;

final class VmomiDataProviderResultSetConverter {
    VmomiDataProviderResultSetConverter() {
    }

    public static ResultSet convertResultSet(com.vmware.vim.binding.cis.data.provider.ResultSet vmomiResultSet, Query query) {
        Validate.notNull((Object)vmomiResultSet);
        Validate.notNull((Object)query);
        List properties = query.getProperties();
        ResultSet.Builder resultBuilder = ResultSet.Builder.properties((List)properties);
        if (query.getLimit() != 0) {
            VmomiDataProviderResultSetConverter.convertItems(resultBuilder, vmomiResultSet.getItems(), vmomiResultSet.getProperties(), properties);
        }
        Integer totalCount = VmomiDataProviderResultSetConverter.getTotalCount(vmomiResultSet, query.getWithTotalCount());
        return resultBuilder.totalCount(totalCount).build();
    }

    static Collection<ResultSet> convertResultSets(com.vmware.vim.binding.cis.data.provider.ResultSet[] vmomiResults, Collection<Query> queries) {
        assert (vmomiResults != null);
        assert (queries != null);
        assert (vmomiResults.length == queries.size());
        Iterator<Query> queryIt = queries.iterator();
        ArrayList<ResultSet> results = new ArrayList<ResultSet>(vmomiResults.length);
        for (com.vmware.vim.binding.cis.data.provider.ResultSet vmomiResult : vmomiResults) {
            Query query = queryIt.next();
            ResultSet result = VmomiDataProviderResultSetConverter.convertResultSet(vmomiResult, query);
            results.add(result);
        }
        return results;
    }

    private static Integer getTotalCount(com.vmware.vim.binding.cis.data.provider.ResultSet vmomiResultSet, boolean withTotalCount) {
        if (withTotalCount) {
            if (vmomiResultSet.getTotalCount() == null) {
                throw new IllegalArgumentException("Response does not contain total item count");
            }
            return vmomiResultSet.getTotalCount().intValue();
        }
        return null;
    }

    private static void convertItems(ResultSet.Builder resultBuilder, ResourceItem[] vmomiItems, String[] vmomiProperties, List<String> coreProperties) {
        if (vmomiItems == null) {
            return;
        }
        int keyPosition = VmomiDataProviderResultSetConverter.getKeyPosition(vmomiProperties);
        for (int i = 0; i < vmomiItems.length; ++i) {
            ResourceItem vmomiItem = vmomiItems[i];
            OptionalPropertyValue optionalValueKey = vmomiItem.getPropertyValues()[keyPosition];
            List<Object> item = VmomiDataProviderResultSetConverter.convertItem(vmomiItem, vmomiProperties, coreProperties);
            resultBuilder.item(optionalValueKey.value, item);
        }
    }

    private static int getKeyPosition(String[] vmomiProperties) {
        int index = 0;
        for (String vmomiProperty : vmomiProperties) {
            if (PropertyUtil.isModelKey((String)vmomiProperty)) {
                return index;
            }
            ++index;
        }
        throw new IllegalArgumentException("No key in the vmomi properties.");
    }

    private static List<Object> convertItem(ResourceItem vmomiItem, String[] vmomiProperties, List<String> coreProperties) {
        Validate.notNull((Object)vmomiItem);
        Validate.notNull((Object)vmomiProperties);
        Validate.notNull(coreProperties);
        OptionalPropertyValue[] vmomiValues = vmomiItem.getPropertyValues();
        if (vmomiValues.length != vmomiProperties.length) {
            throw new IllegalArgumentException(String.format("The number of property value in a VMOMI ResourceItem does not match the number of properties in the VMOMI ResultSet: %d != %d", vmomiValues.length, vmomiProperties.length));
        }
        Map<String, Object> vmomiValueByProperty = VmomiDataProviderResultSetConverter.toVmomiValueByProperty(vmomiItem, vmomiProperties);
        ArrayList<Object> coreValues = new ArrayList<Object>(coreProperties.size());
        for (String coreProperty : coreProperties) {
            String vmomiProperty = VmomiProperty.toVmomiProperty(coreProperty);
            Object vmomiValue = vmomiValueByProperty.get(vmomiProperty);
            Object coreValue = VmomiDataProviderResultSetConverter.convertPropertyValue(coreProperty, vmomiValue);
            coreValues.add(coreValue);
        }
        return coreValues;
    }

    private static Map<String, Object> toVmomiValueByProperty(ResourceItem vmomiItem, String[] vmomiProperties) {
        assert (vmomiItem != null);
        assert (vmomiItem.getPropertyValues() != null);
        assert (vmomiProperties != null);
        assert (vmomiProperties.length == vmomiItem.getPropertyValues().length);
        OptionalPropertyValue[] vmomiValues = vmomiItem.getPropertyValues();
        HashMap<String, Object> valueByProperty = new HashMap<String, Object>(vmomiProperties.length);
        for (int i = 0; i < vmomiProperties.length; ++i) {
            String vmomiProperty = vmomiProperties[i];
            OptionalPropertyValue vmomiValue = vmomiValues[i];
            valueByProperty.put(vmomiProperty, vmomiValue.getValue());
        }
        return valueByProperty;
    }

    private static Object convertPropertyValue(String coreProperty, Object vmomiValue) {
        assert (coreProperty != null);
        Object coreValue = null;
        if (PropertyUtil.isType((String)coreProperty)) {
            ManagedObjectReference mor = VmomiDataProviderResultSetConverter.getMor(vmomiValue);
            if (mor != null) {
                coreValue = mor.getType();
            }
        } else {
            coreValue = VmomiProperty.isForeignKey(coreProperty) ? VmomiDataProviderResultSetConverter.convertToCisId(vmomiValue) : vmomiValue;
        }
        return coreValue;
    }

    private static Object convertToCisId(Object vmomiValue) {
        if (vmomiValue == null) {
            return null;
        }
        if (vmomiValue instanceof ManagedObjectReference[]) {
            ManagedObjectReference[] mors = (ManagedObjectReference[])vmomiValue;
            String[] cisIds = new String[mors.length];
            int i = 0;
            for (ManagedObjectReference mor : mors) {
                String cisId = CisIdConverter.toGlobalCisId((ManagedObjectReference)mor, (String)mor.getServerGuid());
                cisIds[i++] = cisId;
            }
            return cisIds;
        }
        ManagedObjectReference mor = VmomiDataProviderResultSetConverter.getMor(vmomiValue);
        String cisId = CisIdConverter.toGlobalCisId((ManagedObjectReference)mor, (String)mor.getServerGuid());
        return cisId;
    }

    private static ManagedObjectReference getMor(Object vmomiValue) {
        if (vmomiValue == null) {
            return null;
        }
        if (!(vmomiValue instanceof ManagedObjectReference)) {
            throw new IllegalArgumentException(String.format("VMOMI ResourceItem contains invalid model key value of class %s", vmomiValue.getClass().getCanonicalName()));
        }
        return (ManagedObjectReference)vmomiValue;
    }
}

