/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.vmomi.model;

import com.vmware.cis.data.model.DerivedProperty;
import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryModel;
import com.vmware.cis.data.model.Relationship;
import com.vmware.cis.data.model.SourceProperty;
import com.vmware.vim.binding.vim.AboutInfo;
import com.vmware.vim.binding.vim.host.IpConfig;
import com.vmware.vim.binding.vim.host.PciPassthruInfo;
import com.vmware.vim.binding.vim.host.PhysicalNic;
import com.vmware.vim.binding.vim.host.VirtualNic;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

@QueryModel(value="HostSystem")
public class HostExtendedDataModel {
    @Property(value="HostSystem/runtime/powerState")
    public String powerState;
    @Property(value="HostSystem/runtime/inMaintenanceMode")
    public Boolean inMaintenanceMode;
    @Property(value="HostSystem/runtime/inMaintenanceMode")
    public String inMaintenanceModeString;
    @Property(value="HostSystem/runtime/connectionState")
    public String connectionState;
    @Property(value="HostSystem/network")
    public String[] allNetwork;
    @Property(value="HostSystem/config/product")
    public AboutInfo product;
    @Property(value="HostSystem/config/network/consoleVnic")
    public VirtualNic[] nics;
    @Property(value="HostSystem/configManager/storageSystem")
    public String storageSystem;
    @Property(value="HostSystem/configManager/datastoreSystem")
    public String datastoreSystem;
    @Property(value="HostSystem/configManager/cacheConfigurationManager")
    public String cacheConfigurationManager;
    @Property(value="HostSystem/configManager/diagnosticSystem")
    public String diagnosticSystem;
    @Property(value="HostSystem/configManager/firewallSystem")
    public String firewallSystem;
    @Property(value="HostSystem/hp")
    public ManagedObjectReference associatedProfile;
    @Relationship(value={"HostSystem/parent"})
    @Property(value="ClusterComputeResource/@modelKey")
    public ManagedObjectReference cluster;
    @Relationship(value={"HostSystem/parent"})
    @Property(value="ClusterComputeResource/name")
    public String hostClusterName;
    @Relationship(value={"HostSystem/parent", "ComputeResource/resourcePool"})
    @Property(value="ResourcePool/@modelKey")
    public ManagedObjectReference rootRp;
    @Relationship(value={"HostSystem/parent", "ComputeResource/resourcePool"})
    @Property(value="ResourcePool/@modelKey")
    public ManagedObjectReference rp;
    @Relationship(value={"HostSystem/network"})
    @Property(value="DistributedVirtualPortgroup/@modelKey")
    public ManagedObjectReference[] dvpg;
    @Relationship(value={"HostSystem/network"})
    @Property(value="Network/@modelKey")
    public ManagedObjectReference[] standardnetwork;
    @Relationship(value={"HostSystem/network"})
    @Property(value="OpaqueNetwork/@modelKey")
    public ManagedObjectReference[] opaquenetwork;
    @Relationship(value={"HostSystem/datastore", "Datastore/parent"})
    @Property(value="StoragePod/@modelKey")
    public ManagedObjectReference[] storagePod;
    @Relationship(value={"HostSystem/configManager/certificateManager"})
    @Property(value="HostCertificateManager/certificateInfo/notBefore")
    public Date certificateValidFrom;
    @Relationship(value={"HostSystem/configManager/certificateManager"})
    @Property(value="HostCertificateManager/certificateInfo/notAfter")
    public Date certificateValidTo;
    @Relationship(value={"HostSystem/configManager/certificateManager"})
    @Property(value="HostCertificateManager/certificateInfo/status")
    public String certificateStatus;
    @Relationship(value={"HostSystem/configManager/certificateManager"})
    @Property(value="HostCertificateManager/certificateInfo/issuer")
    public String certificateIssuer;
    @Relationship(value={"HostSystem/configManager/certificateManager"})
    @Property(value="HostCertificateManager/certificateInfo/subject")
    public String certificateSubject;
    @Relationship(value={"HostSystem/parent", "AnyComputeResource/resourcePool"})
    @Property(value="ResourcePool/@modelKey")
    public ManagedObjectReference resourcePool;
    @Relationship(value={"HostSystem/network"})
    @Property(value="DistributedVirtualPortgroup/config/distributedVirtualSwitch")
    public ManagedObjectReference[] dvs;
    @Relationship(value={"HostSystem/network"})
    @Property(value="HostNetwork/@modelKey")
    public ManagedObjectReference[] hostNetwork;
    @Relationship(value={"HostSystem/hp"})
    @Property(value="HostProfile/name")
    public String associatedProfileName;
    @Relationship(value={"HostSystem/hp"})
    @Property(value="HostProfile/createdTime")
    public Calendar associatedProfileCreatedTime;
    @Relationship(value={"HostSystem/hp"})
    @Property(value="HostProfile/modifiedTime")
    public Calendar associatedProfileModifiedTime;
    @Property(value="HostSystem/hostProfileComplianceStatus")
    public String hostCompliance;
    @Relationship(value={"HostSystem/parent", "ComputeResource/resourcePool"})
    @Property(value="ResourcePool/rpcontents")
    public ManagedObjectReference[] rootRpContents;
    @Relationship(value={"ScheduledTask/info/taskObject~"})
    @Property(value="ScheduledTask/@modelKey")
    public ManagedObjectReference[] scheduledTask;
    @Relationship(value={"HostSystem/configManager/pciPassthruSystem"})
    @Property(value="HostPciPassthruSystem/pciPassthruInfo")
    public PciPassthruInfo[] pciPassthruInfo;
    @Relationship(value={"HostSystem/parent", "ComputeResource/parent", "Folder/parent"})
    @Property(value="Datacenter/@modelKey")
    public ManagedObjectReference grandgrandparentDcOfStandaloneHost;
    @Relationship(value={"HostSystem/parent", "ComputeResource/parent"})
    @Property(value="Folder/@modelKey")
    public ManagedObjectReference grandparentFolderOfStandaloneHost;

    @DerivedProperty(value="HostSystem/ip")
    public static String[] getIp(@SourceProperty(value="HostSystem/config/network/vnic") VirtualNic[] vnic, @SourceProperty(value="HostSystem/config/network/consoleVnic") VirtualNic[] consoleVnic, @SourceProperty(value="HostSystem/config/network/pnic") PhysicalNic[] pnic) {
        List<String> ipAll = HostExtendedDataModel.getVnicIpV4Addresses(vnic);
        ipAll.addAll(HostExtendedDataModel.getVnicIpV4Addresses(consoleVnic));
        ipAll.addAll(HostExtendedDataModel.getPnicIpV4Addresses(pnic));
        return ipAll.toArray(new String[ipAll.size()]);
    }

    @DerivedProperty(value="HostSystem/ipv6")
    public static String[] getIpv6(@SourceProperty(value="HostSystem/config/network/vnic") VirtualNic[] vnic, @SourceProperty(value="HostSystem/config/network/consoleVnic") VirtualNic[] consoleVnic, @SourceProperty(value="HostSystem/config/network/pnic") PhysicalNic[] pnic) {
        List<String> ipAll = HostExtendedDataModel.getVnicIpV6Addresses(vnic);
        ipAll.addAll(HostExtendedDataModel.getVnicIpV6Addresses(consoleVnic));
        ipAll.addAll(HostExtendedDataModel.getPnicIpV6Addresses(pnic));
        return ipAll.toArray(new String[ipAll.size()]);
    }

    @DerivedProperty(value="HostSystem/encryptionStatus")
    public static String getEncryptionStatus(@SourceProperty(value="HostSystem/runtime/cryptoState") String cryptoState) {
        if (cryptoState == null) {
            return "na";
        }
        return cryptoState;
    }

    @DerivedProperty(value="HostSystem/cpuUsage")
    public static Integer getCpuUsage(@SourceProperty(value="HostSystem/hardware/cpuInfo/numCpuCores") Short numCpu, @SourceProperty(value="HostSystem/hardware/cpuInfo/hz") Long cpuHz, @SourceProperty(value="HostSystem/summary/quickStats/overallCpuUsage") Integer overallCpuUsage) {
        if (HostExtendedDataModel.isNullOrZero(numCpu) || HostExtendedDataModel.isNullOrZero(cpuHz) || HostExtendedDataModel.isNullOrZero(overallCpuUsage)) {
            return 0;
        }
        BigDecimal numerator = new BigDecimal(overallCpuUsage * 100);
        BigDecimal denominator = new BigDecimal((long)numCpu.shortValue() * cpuHz / 1000000L);
        return numerator.divideToIntegralValue(denominator).intValue();
    }

    @DerivedProperty(value="HostSystem/memoryUsage")
    public static Integer getMemoryUsage(@SourceProperty(value="HostSystem/summary/quickStats/overallMemoryUsage") Integer overallMemoryUsage, @SourceProperty(value="HostSystem/hardware/memorySize") Long memorySize) {
        if (HostExtendedDataModel.isNullOrZero(overallMemoryUsage) || HostExtendedDataModel.isNullOrZero(memorySize)) {
            return 0;
        }
        BigDecimal numerator = new BigDecimal(overallMemoryUsage * 100);
        BigDecimal denominator = new BigDecimal(memorySize / 0x100000L);
        return numerator.divideToIntegralValue(denominator).intValue();
    }

    @DerivedProperty(value="HostSystem/pciPassthruSupported")
    public static boolean getPciPassthruSupported(@SourceProperty(value="HostSystem/pciPassthruInfo") PciPassthruInfo[] hostPciPassthruInfo) {
        if (hostPciPassthruInfo == null || hostPciPassthruInfo.length == 0) {
            return false;
        }
        for (PciPassthruInfo pciPassthruInfo : hostPciPassthruInfo) {
            if (!pciPassthruInfo.isPassthruCapable()) continue;
            return true;
        }
        return false;
    }

    @DerivedProperty(value="HostSystem/vsanFaultDomainName")
    public static String getVsanFaultDomain(@SourceProperty(value="HostSystem/config/vsanHostConfig/enabled") Boolean vsanHostConfigEnabled, @SourceProperty(value="HostSystem/config/vsanHostConfig/faultDomainInfo/name") String faultDomainName) {
        if (vsanHostConfigEnabled == null || !vsanHostConfigEnabled.booleanValue()) {
            return null;
        }
        return faultDomainName;
    }

    private static boolean isNullOrZero(Number i) {
        return i == null || i.longValue() == 0L;
    }

    private static List<String> getVnicIpV4Addresses(VirtualNic[] vnic) {
        if (ArrayUtils.isEmpty((Object[])vnic)) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> ipAll = new ArrayList<String>();
        for (int i = 0; i < vnic.length; ++i) {
            VirtualNic.Specification vnicSpec = vnic[i].spec;
            if (vnicSpec == null || vnicSpec.ip == null || StringUtils.isEmpty((String)vnicSpec.ip.ipAddress)) continue;
            ipAll.add(vnicSpec.ip.ipAddress);
        }
        return ipAll;
    }

    private static List<String> getVnicIpV6Addresses(VirtualNic[] vnic) {
        if (ArrayUtils.isEmpty((Object[])vnic)) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> ipAll = new ArrayList<String>();
        for (int i = 0; i < vnic.length; ++i) {
            List<String> ipv6s;
            VirtualNic.Specification vnicSpec = vnic[i].spec;
            if (vnicSpec == null || vnicSpec.ip == null || (ipv6s = HostExtendedDataModel.getIPv6(vnicSpec.ip.ipV6Config)).size() <= 0) continue;
            ipAll.addAll(ipv6s);
        }
        return ipAll;
    }

    private static List<String> getPnicIpV4Addresses(PhysicalNic[] pnic) {
        if (ArrayUtils.isEmpty((Object[])pnic)) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> ipAll = new ArrayList<String>();
        for (int i = 0; i < pnic.length; ++i) {
            PhysicalNic.Specification pnicSpec = pnic[i].spec;
            if (pnicSpec == null || pnicSpec.ip == null || StringUtils.isEmpty((String)pnicSpec.ip.ipAddress)) continue;
            ipAll.add(pnicSpec.ip.ipAddress);
        }
        return ipAll;
    }

    private static List<String> getPnicIpV6Addresses(PhysicalNic[] pnic) {
        if (ArrayUtils.isEmpty((Object[])pnic)) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> ipAll = new ArrayList<String>();
        for (int i = 0; i < pnic.length; ++i) {
            List<String> ipv6s;
            PhysicalNic.Specification pnicSpec = pnic[i].spec;
            if (pnicSpec == null || pnicSpec.ip == null || (ipv6s = HostExtendedDataModel.getIPv6(pnicSpec.ip.ipV6Config)).size() <= 0) continue;
            ipAll.addAll(ipv6s);
        }
        return ipAll;
    }

    private static List<String> getIPv6(IpConfig.IpV6AddressConfiguration ipV6Config) {
        if (ipV6Config == null || ArrayUtils.isEmpty((Object[])ipV6Config.ipV6Address)) {
            return new ArrayList<String>(0);
        }
        IpConfig.IpV6Address[] ipV6Addr = ipV6Config.ipV6Address;
        ArrayList<String> ipv6s = new ArrayList<String>();
        for (int i = 0; i < ipV6Addr.length; ++i) {
            if (StringUtils.isEmpty((String)ipV6Addr[i].ipAddress)) continue;
            ipv6s.add(ipV6Addr[i].ipAddress);
        }
        return ipv6s;
    }
}

