/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.vmomi.util;

import com.vmware.cis.data.internal.util.PropertyUtil;
import com.vmware.cis.data.internal.util.QualifiedProperty;
import org.apache.commons.lang.Validate;

public final class VmomiProperty {
    public static final String FOREIGN_KEY_SUFFIX = "@moId";

    public static boolean isForeignKey(String property) {
        Validate.notEmpty((String)property);
        return property.endsWith("/@moId");
    }

    public static String stripForeignKeySuffix(String property) {
        String clearedProperty = property.substring(0, property.length() - (FOREIGN_KEY_SUFFIX.length() + 1));
        return clearedProperty;
    }

    public static String appendForeignKeySuffix(String property) {
        return property + '/' + FOREIGN_KEY_SUFFIX;
    }

    public static String toVmomiProperty(String coreProperty) {
        assert (coreProperty != null);
        if (PropertyUtil.isType((String)coreProperty)) {
            return "@modelKey";
        }
        if (PropertyUtil.isModelKey((String)coreProperty)) {
            return coreProperty;
        }
        String simpleProperty = QualifiedProperty.forQualifiedName((String)coreProperty).getSimpleProperty();
        if (VmomiProperty.isForeignKey(simpleProperty)) {
            return VmomiProperty.stripForeignKeySuffix(simpleProperty);
        }
        return simpleProperty;
    }
}

