/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.binding.rbd;

import com.vmware.vim.binding.impl.vmodl.DynamicDataImpl;
import com.vmware.vim.binding.rbd.fault.DuplicateName;
import com.vmware.vim.binding.rbd.fault.InvalidRuleName;
import com.vmware.vim.binding.rbd.fault.InvalidRuleSpecFault;
import com.vmware.vim.binding.rbd.fault.ObjectIsNotEditable;
import com.vmware.vim.binding.rbd.version.version2;
import com.vmware.vim.binding.rbd.version.version3;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.data;
import com.vmware.vim.binding.vmodl.faults;
import com.vmware.vim.binding.vmodl.list;
import com.vmware.vim.binding.vmodl.managed;
import com.vmware.vim.binding.vmodl.managedObjectType;
import com.vmware.vim.binding.vmodl.map;
import com.vmware.vim.binding.vmodl.name;
import com.vmware.vim.binding.vmodl.optional;
import com.vmware.vim.binding.vmodl.privilege;
import com.vmware.vim.binding.vmodl.propertyOrder;
import com.vmware.vim.binding.vmodl.readonly;
import com.vmware.vim.binding.vmodl.task;
import com.vmware.vim.binding.vmodl.versionClass;
import com.vmware.vim.binding.vmodl.wsdlName;
import com.vmware.vim.vmomi.core.util.StringUtil;

@managed
@versionClass(value=version2.class)
@wsdlName(value="Rule")
public interface Rule
extends ManagedObject {
    @readonly
    @name(value="spec")
    @versionClass(value=version2.class)
    public RuleSpec getSpec();

    @readonly
    @name(value="metadata")
    @versionClass(value=version2.class)
    public RuleMetadata getMetadata();

    @readonly
    @name(value="editable")
    @versionClass(value=version2.class)
    @optional
    public Boolean isEditable();

    @versionClass(value=version2.class)
    @wsdlName(value="RetrieveRuleSpec")
    public RuleSpec retrieveSpec();

    @versionClass(value=version2.class)
    @wsdlName(value="RetrieveRuleMetadata")
    public RuleMetadata retrieveMetadata();

    @versionClass(value=version2.class)
    @wsdlName(value="RetrieveRuleEditable")
    @optional
    public Boolean retrieveEditable();

    @versionClass(value=version2.class)
    @wsdlName(value="DestroyRule")
    @privilege(value="AutoDeploy.Rule.Delete")
    public void destroy();

    @versionClass(value=version2.class)
    @wsdlName(value="UpdateRuleMetadata")
    @privilege(value="AutoDeploy.Rule.Edit")
    @faults(value={"rbd1FaultInvalidRuleName", "rbd1FaultDuplicateName"})
    public void updateMetadata(@name(value="meta") @versionClass(value=version2.class) RuleMetadata var1) throws InvalidRuleName, DuplicateName;

    @versionClass(value=version2.class)
    @wsdlName(value="UpdateRuleSpec")
    @privilege(value="AutoDeploy.Rule.Edit")
    @faults(value={"rbd1FaultInvalidRuleSpecFault", "rbd1FaultObjectIsNotEditable"})
    public void updateSpec(@name(value="ruleSpec") @versionClass(value=version2.class) RuleSpec var1, @name(value="force") @versionClass(value=version3.class) @optional Boolean var2) throws InvalidRuleSpecFault, ObjectIsNotEditable;

    @versionClass(value=version3.class)
    @wsdlName(value="com.vmware.rbd.UpdateSpecWithTransform_Task")
    @privilege(value="AutoDeploy.Rule.Edit")
    @task
    @managedObjectType(value="com.vmware.vim.binding.vim.Task")
    public ManagedObjectReference updateSpecWithTransform(@name(value="ruleSpec") @versionClass(value=version3.class) RuleSpec var1, @name(value="itemsToBeConverted") @versionClass(value=version3.class) @map String[] var2, @name(value="force") @versionClass(value=version3.class) @optional Boolean var3, @name(value="noSignatureCheck") @versionClass(value=version3.class) @optional Boolean var4);

    @versionClass(value=version2.class)
    @wsdlName(value="RuleRuleSpec")
    @data
    @propertyOrder(value={"patternList", "itemList"})
    public static class RuleSpec
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public Pattern[] patternList;
        public ManagedObjectReference[] itemList;

        public RuleSpec() {
        }

        public RuleSpec(Pattern[] patternArray, ManagedObjectReference[] managedObjectReferenceArray) {
            this.patternList = patternArray;
            this.itemList = managedObjectReferenceArray;
        }

        @list
        @optional
        @versionClass(value=version2.class)
        public Pattern[] getPatternList() {
            return this.patternList;
        }

        @list
        @optional
        @versionClass(value=version2.class)
        public void setPatternList(Pattern[] patternArray) {
            this.patternList = patternArray;
        }

        @managedObjectType(value="com.vmware.vim.binding.vmodl.ManagedObject")
        @map
        @optional
        @versionClass(value=version2.class)
        public ManagedObjectReference[] getItemList() {
            return this.itemList;
        }

        @managedObjectType(value="com.vmware.vim.binding.vmodl.ManagedObject")
        @map
        @optional
        @versionClass(value=version2.class)
        public void setItemList(ManagedObjectReference[] managedObjectReferenceArray) {
            this.itemList = managedObjectReferenceArray;
        }

        public String toString() {
            int n;
            StringBuilder stringBuilder = new StringBuilder(160);
            stringBuilder.append("(rbd.RuleSpec) {\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicType = ");
            stringBuilder.append(this.getDynamicType());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(vmodl.DynamicProperty) [\n");
                for (n = 0; n < this.getDynamicProperty().length; ++n) {
                    stringBuilder.append("      ");
                    stringBuilder.append(StringUtil.indent((String)("" + this.getDynamicProperty()[n]), (boolean)true));
                    if (n < this.getDynamicProperty().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("patternList = ");
            if (this.getPatternList() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(rbd.Pattern) [\n");
                for (n = 0; n < this.getPatternList().length; ++n) {
                    stringBuilder.append("      ");
                    stringBuilder.append(StringUtil.indent((String)("" + (Object)((Object)this.getPatternList()[n])), (boolean)true));
                    if (n < this.getPatternList().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("itemList = ");
            if (this.getItemList() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(MANAGED) [\n");
                for (n = 0; n < this.getItemList().length; ++n) {
                    stringBuilder.append("      ");
                    stringBuilder.append(StringUtil.indent((String)("" + this.getItemList()[n]), (boolean)true));
                    if (n < this.getItemList().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append("\n}");
            return stringBuilder.toString();
        }
    }

    @versionClass(value=version2.class)
    @wsdlName(value="RulePattern")
    @data
    @propertyOrder(value={"attribute", "type", "pattern"})
    public static class Pattern
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public String attribute;
        public String type;
        public String pattern;

        public Pattern() {
        }

        public Pattern(String string, String string2, String string3) {
            this.attribute = string;
            this.type = string2;
            this.pattern = string3;
        }

        @versionClass(value=version2.class)
        public String getAttribute() {
            return this.attribute;
        }

        @versionClass(value=version2.class)
        public void setAttribute(String string) {
            this.attribute = string;
        }

        @versionClass(value=version2.class)
        public String getType() {
            return this.type;
        }

        @versionClass(value=version2.class)
        public void setType(String string) {
            this.type = string;
        }

        @versionClass(value=version2.class)
        public String getPattern() {
            return this.pattern;
        }

        @versionClass(value=version2.class)
        public void setPattern(String string) {
            this.pattern = string;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(200);
            stringBuilder.append("(rbd.Pattern) {\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicType = ");
            stringBuilder.append(this.getDynamicType());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    stringBuilder.append("      ");
                    stringBuilder.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("attribute = ");
            stringBuilder.append(this.getAttribute());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("type = ");
            stringBuilder.append(this.getType());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("pattern = ");
            stringBuilder.append(this.getPattern());
            stringBuilder.append("\n}");
            return stringBuilder.toString();
        }

        @versionClass(value=version2.class)
        @wsdlName(value="RulePatternType")
        public static enum Type {
            none,
            string,
            ipv4,
            ipv6;

        }
    }

    @versionClass(value=version2.class)
    @wsdlName(value="RuleRuleMetadata")
    @data
    @propertyOrder(value={"name"})
    public static class RuleMetadata
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public String name;

        public RuleMetadata() {
        }

        public RuleMetadata(String string) {
            this.name = string;
        }

        @versionClass(value=version2.class)
        public String getName() {
            return this.name;
        }

        @versionClass(value=version2.class)
        public void setName(String string) {
            this.name = string;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(120);
            stringBuilder.append("(rbd.RuleMetadata) {\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicType = ");
            stringBuilder.append(this.getDynamicType());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    stringBuilder.append("      ");
                    stringBuilder.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("name = ");
            stringBuilder.append(this.getName());
            stringBuilder.append("\n}");
            return stringBuilder.toString();
        }
    }
}

