/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.impl;

import com.vmware.sso.tokenmgmt.SsoDomain;
import com.vmware.vim.binding.cis.cm.fault.ComponentManagerFault;
import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vise.data.query.type;
import com.vmware.vise.security.UserSessionListener;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.sso.AuthSessionUtil;
import com.vmware.vise.vim.lookup.UserSpecificLsFactory;
import com.vmware.vise.vim.security.sso.SsoAdminService;
import com.vmware.vise.vim.security.sso.SsoServerInfo;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vise.vim.security.sso.SsoServiceProvider;
import com.vmware.vise.vim.security.sso.SsoUtil;
import com.vmware.vsphere.client.cm.util.CmReferenceUtil;
import com.vmware.vsphere.client.cm.util.CmUtil;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CmSsoServiceProviderImpl
implements SsoServiceProvider,
UserSessionListener {
    private static final Log _logger = LogFactory.getLog(CmSsoServiceProviderImpl.class);
    private static final String LS_SSO_SERVICE_CACHE_KEY = "lsSsoServiceCache";
    private final UserSpecificLsFactory _lsFactory;
    private final SsoService _ssoService;

    public CmSsoServiceProviderImpl(UserSpecificLsFactory userSpecificLsFactory, SsoService ssoService) {
        Validate.notNull((Object)userSpecificLsFactory);
        Validate.notNull((Object)ssoService);
        this._lsFactory = userSpecificLsFactory;
        this._ssoService = ssoService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionEnded(HttpSessionEvent httpSessionEvent) throws Exception {
        Map map = (Map)SessionUtil.removeData((String)LS_SSO_SERVICE_CACHE_KEY, (HttpSession)httpSessionEvent.getSession());
        if (map == null || map.isEmpty()) {
            return;
        }
        CmSsoServiceProviderImpl cmSsoServiceProviderImpl = this;
        synchronized (cmSsoServiceProviderImpl) {
            for (Map.Entry entry : map.entrySet()) {
                SsoAdminService ssoAdminService = (SsoAdminService)entry.getValue();
                try {
                    ssoAdminService.logout();
                }
                catch (Exception exception) {
                    _logger.error((Object)("Failed to log out of service " + ssoAdminService), (Throwable)exception);
                }
            }
        }
        map.clear();
    }

    public void sessionStarted(HttpSessionEvent httpSessionEvent, Locale locale) throws Exception {
    }

    @type(value="cm:Server")
    public SsoAdminService getAdminService(URI uRI, SsoDomain ssoDomain) throws Exception {
        SsoAdminService ssoAdminService;
        String string = CmReferenceUtil.getServerId(uRI);
        Map map = (Map)SessionUtil.getData((String)LS_SSO_SERVICE_CACHE_KEY);
        if (map != null && (ssoAdminService = (SsoAdminService)map.get(string)) != null) {
            return ssoAdminService;
        }
        return this.getAdminServiceSynchronized(uRI);
    }

    private synchronized SsoAdminService getAdminServiceSynchronized(URI uRI) throws Exception {
        Object object;
        String string = CmReferenceUtil.getServerId(uRI);
        Object object2 = SessionUtil.getData((String)LS_SSO_SERVICE_CACHE_KEY);
        if (object2 != null && (object = (SsoAdminService)object2.get(string)) != null) {
            return object;
        }
        if (object2 == null && (object = (HashMap)SessionUtil.setDataIfAbsent((String)LS_SSO_SERVICE_CACHE_KEY, object2 = new HashMap())) != null) {
            object2 = object;
        }
        if ((object = this.findSsoServiceInfo(uRI)) == null) {
            throw CmUtil.getFault("error.ssoServiceInfoNotFound", uRI.toString());
        }
        SsoServerInfo ssoServerInfo = this.findSsoServerInfo((ServiceRegistration.Info)object);
        SsoAdminService ssoAdminService = SsoUtil.getAdminService((SsoServerInfo)ssoServerInfo, (SsoService)this._ssoService, (SamlToken)AuthSessionUtil.getSsoToken((SsoDomain)ssoServerInfo.getSsoDomain()), (boolean)false);
        object2.put(string, ssoAdminService);
        return ssoAdminService;
    }

    private ServiceRegistration.Info findSsoServiceInfo(URI uRI) throws ComponentManagerFault {
        ServiceRegistration.Filter filter = new ServiceRegistration.Filter();
        ServiceRegistration.EndpointType endpointType = new ServiceRegistration.EndpointType();
        endpointType.setType("com.vmware.cis.cs.identity.admin");
        filter.setEndpointType(endpointType);
        Object[] objectArray = this._lsFactory.getLookupService().getServiceRegistrationInfos(filter);
        String string = CmReferenceUtil.getServerId(uRI);
        if (string == null) {
            return null;
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Searching for hostname '" + string + "' among " + Arrays.toString(objectArray)));
        }
        for (ServiceRegistration.Info info : (ServiceRegistration.Info[])ArrayUtil.toSafe((Object[])objectArray, ServiceRegistration.Info.class)) {
            String string2 = CmUtil.getServerHostname(info);
            if (!string.equals(string2)) continue;
            return info;
        }
        return null;
    }

    private SsoServerInfo findSsoServerInfo(ServiceRegistration.Info info) throws Exception {
        ServiceRegistration.Endpoint[] endpointArray;
        for (ServiceRegistration.Endpoint endpoint : endpointArray = info.getServiceEndpoints()) {
            if (!endpoint.getEndpointType().getType().equals("com.vmware.cis.cs.identity.admin")) continue;
            String string = endpoint.getUrl().toString();
            for (Map.Entry entry : this._ssoService.getServerInfos().entrySet()) {
                SsoServerInfo ssoServerInfo = (SsoServerInfo)entry.getValue();
                if (!ssoServerInfo.getAllAdminAppUrls().contains(string)) continue;
                if (ssoServerInfo.getAdminAppUrl().equals(string)) {
                    return ssoServerInfo;
                }
                return this.createServerInfoFromExisting(string, ssoServerInfo);
            }
            throw new Exception(String.format("SsoAdminService endpoint '%s' does not match any of the servers in SsoService.getServerInfos()", string));
        }
        throw new Exception(String.format("Service '%s' is missing any endpoints", info.serviceNameDefault));
    }

    private SsoServerInfo createServerInfoFromExisting(String string, SsoServerInfo ssoServerInfo) throws UnsupportedEncodingException, CertificateException {
        SsoServerInfo.Builder builder = new SsoServerInfo.Builder();
        builder.adminAppUrl = string;
        builder.keyStore = ssoServerInfo.getKeyStore();
        builder.ssoDomain = ssoServerInfo.getSsoDomain();
        builder.allStsServerInfos = ssoServerInfo.getAllStsServerInfos();
        return builder.getInstance();
    }
}

