/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.impl;

import com.vmware.vim.binding.sca.ServiceInfo;
import com.vmware.vim.binding.sca.ServiceInstance;
import com.vmware.vim.binding.sca.ServiceManager;
import com.vmware.vim.binding.sca.fault.ServiceManagerFault;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.security.UserSessionListener;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.i18n.CatalogRetriever;
import com.vmware.vise.vim.sca.ScaService;
import com.vmware.vise.vim.sca.ScaServiceManager;
import com.vmware.vise.vim.security.sso.SsoServiceManager;
import com.vmware.vsphere.client.cm.util.CmAuthorizationService;
import com.vmware.vsphere.client.cm.util.CmReferenceUtil;
import com.vmware.vsphere.client.cm.util.CmUtil;
import com.vmware.vsphere.client.cm.util.InternalServerInfo;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.concurrent.Executor;
import javax.servlet.http.HttpSessionEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScaCatalogLocator
implements UserSessionListener {
    private static final Log _logger = LogFactory.getLog(ScaCatalogLocator.class);
    private static final String RES_BUNDLE_BASE_NAME = "resourceBundleBaseNames";
    private static final String RES_BUNDLE_URL_PATH = "resourceBundleUrlPath";
    private static final String FAKE_PRODUCT_ID = "com.vmware.sca";
    private static final String SCA_SERVICE_ID = "vmware-sca";
    private SsoServiceManager _ssoServiceManager = null;
    private ScaServiceManager _scaServiceManager = null;
    private CatalogRetriever _catalogRetriever = null;
    private final Executor _executor;
    private final CmAuthorizationService _cmAuthorizationService;

    public ScaCatalogLocator(CmAuthorizationService cmAuthorizationService, Executor executor) {
        this._cmAuthorizationService = cmAuthorizationService;
        this._executor = executor;
        _logger.info((Object)"instantiated");
    }

    public void setScaServiceManager(ScaServiceManager scaServiceManager) {
        this._scaServiceManager = scaServiceManager;
    }

    public void setSsoServiceManager(SsoServiceManager ssoServiceManager) {
        this._ssoServiceManager = ssoServiceManager;
    }

    public void setCatalogRetriever(CatalogRetriever catalogRetriever) {
        this._catalogRetriever = catalogRetriever;
    }

    public void sessionStarted(HttpSessionEvent httpSessionEvent, Locale locale) throws Exception {
        if (this._cmAuthorizationService.isCurrentUserAuthorized()) {
            Runnable runnable = this.getInitScaListTask(locale);
            this._executor.execute(runnable);
        }
    }

    public void sessionEnded(HttpSessionEvent httpSessionEvent) throws Exception {
    }

    private Runnable getInitScaListTask(Locale locale) {
        final SessionUtil.ThreadContext threadContext = SessionUtil.getThreadContext((boolean)true);
        final Locale locale2 = locale;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ScaCatalogLocator.this.setThreadContext(threadContext, null);
                try {
                    ScaCatalogLocator.this.initScaList(locale2);
                }
                catch (Exception exception) {
                    _logger.warn((Object)"Problem occured when trying to gather resource bundles from the SCA++ service: ", (Throwable)exception);
                }
                finally {
                    ScaCatalogLocator.this.setThreadContext(null, null);
                }
            }
        };
        return runnable;
    }

    private void initScaList(Locale locale) throws ServiceManagerFault, InterruptedException {
        int n = 5;
        _logger.info((Object)String.format("Retrieving SCA++ resource bundles information in ... %d seconds", n));
        Thread.sleep(n * 1000);
        Collection<InternalServerInfo> collection = CmUtil.getServers(this._ssoServiceManager);
        for (InternalServerInfo internalServerInfo : collection) {
            URI uRI = CmReferenceUtil.getServerReference(internalServerInfo);
            Runnable runnable = this.getProcessResourceBundlesTask(locale, uRI);
            this._executor.execute(runnable);
        }
    }

    private Runnable getProcessResourceBundlesTask(Locale locale, URI uRI) {
        final SessionUtil.ThreadContext threadContext = SessionUtil.getThreadContext((boolean)true);
        final ClassLoader classLoader = this.getClass().getClassLoader();
        final URI uRI2 = uRI;
        final Locale locale2 = locale;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ScaCatalogLocator.this.setThreadContext(threadContext, classLoader);
                try {
                    ScaCatalogLocator.this.processResourceBundles(uRI2, locale2);
                }
                catch (Exception exception) {
                    _logger.warn((Object)("Problem occured when trying to gather SCA++ resource bundles from: " + uRI2.toString()), (Throwable)exception);
                }
                finally {
                    ScaCatalogLocator.this.setThreadContext(null, null);
                }
            }
        };
        return runnable;
    }

    private void processResourceBundles(URI uRI, Locale locale) throws ServiceManagerFault, UnsupportedEncodingException, URISyntaxException {
        _logger.info((Object)("Retrieving SCA++ resource bundles information from " + CmReferenceUtil.getServerId(uRI)));
        ScaService scaService = this._scaServiceManager.getService((Object)uRI);
        String string = this.extractServiceVersion(scaService);
        ManagedObjectReference managedObjectReference = scaService.getServiceContent().serviceManager;
        ServiceManager serviceManager = (ServiceManager)scaService.getManagedObject(managedObjectReference);
        CatalogRetriever.ResourceBundle resourceBundle = serviceManager.list(null);
        if (ArrayUtil.isNullOrEmpty((Object[])resourceBundle)) {
            _logger.info((Object)("SCA++ returned empty service list for " + CmReferenceUtil.getServerId(uRI)));
            return;
        }
        ArrayList<CatalogRetriever.ResourceBundle> arrayList = new ArrayList<CatalogRetriever.ResourceBundle>();
        for (Object object : resourceBundle) {
            if (((ServiceInfo)object).rescBundleUrl == null) continue;
            URI uRI2 = new URI(URLDecoder.decode(((ServiceInfo)object).rescBundleUrl.toString(), "UTF-8"));
            CatalogRetriever.ResourceBundle resourceBundle2 = new CatalogRetriever.ResourceBundle();
            resourceBundle2.productId = FAKE_PRODUCT_ID;
            resourceBundle2.serviceId = ((ServiceInfo)object).serviceId;
            resourceBundle2.resBundleUrl = uRI2;
            resourceBundle2.resBundleBaseName = ((ServiceInfo)object).rescBundleBasename;
            resourceBundle2.serviceVersion = string;
            arrayList.add(resourceBundle2);
        }
        CatalogRetriever.ResourceBundle resourceBundle3 = this.getScaOwnResourceBundle(scaService);
        if (resourceBundle3 != null) {
            arrayList.add(resourceBundle3);
        }
        if (arrayList.size() > 0) {
            _logger.info((Object)String.format("Discovered '%d' resource bundles via SCA++ from %s", arrayList.size(), CmReferenceUtil.getServerId(uRI)));
            this._catalogRetriever.addResourceBundle(locale, (CatalogRetriever.ResourceBundle[])ArrayUtil.toArray(arrayList, CatalogRetriever.ResourceBundle.class));
        }
    }

    private String extractServiceVersion(ScaService scaService) {
        assert (scaService != null);
        ServiceInstance serviceInstance = scaService.getServiceInstance();
        if (serviceInstance == null) {
            return null;
        }
        ServiceInstance.Property[] propertyArray = serviceInstance.getServerProperties();
        if (propertyArray == null) {
            return null;
        }
        for (ServiceInstance.Property property : propertyArray) {
            if (!"version".equals(property.name)) continue;
            return property.value;
        }
        return null;
    }

    private void setThreadContext(SessionUtil.ThreadContext threadContext, ClassLoader classLoader) {
        if (classLoader != null) {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        SessionUtil.setThreadContext((SessionUtil.ThreadContext)threadContext);
    }

    private CatalogRetriever.ResourceBundle getScaOwnResourceBundle(ScaService scaService) throws URISyntaxException {
        Object[] objectArray = scaService.getServiceInstance().getServerProperties();
        if (ArrayUtil.isNullOrEmpty((Object[])objectArray)) {
            return null;
        }
        CatalogRetriever.ResourceBundle resourceBundle = new CatalogRetriever.ResourceBundle();
        resourceBundle.productId = FAKE_PRODUCT_ID;
        resourceBundle.serviceId = SCA_SERVICE_ID;
        for (ServiceInstance.Property property : (ServiceInstance.Property[])ArrayUtil.toSafe((Object[])objectArray, ServiceInstance.Property.class)) {
            if (RES_BUNDLE_URL_PATH.equalsIgnoreCase(property.name)) {
                resourceBundle.resBundleUrl = this.getResourceBundleUrl(scaService, property.value);
            }
            if (!RES_BUNDLE_BASE_NAME.equalsIgnoreCase(property.name)) continue;
            resourceBundle.resBundleBaseName = property.value;
        }
        return resourceBundle.resBundleUrl != null && resourceBundle.resBundleBaseName != null ? resourceBundle : null;
    }

    private URI getResourceBundleUrl(ScaService scaService, String string) throws URISyntaxException {
        URI uRI = scaService.getVmomiClient().getBinding().getEndpointUri();
        URI uRI2 = new URI(uRI.getScheme(), uRI.getHost(), string, null);
        return uRI2;
    }
}

