/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.impl;

import com.vmware.vise.core.model.monitor.IssueInfo;
import com.vmware.vise.core.model.monitor.IssueStatus;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.DataProviderAdapter;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.type;
import com.vmware.vsphere.client.cm.util.CmReferenceUtil;
import com.vmware.vsphere.client.cm.util.CmUtil;
import com.vmware.vsphere.client.cm.util.DataRetriever;
import com.vmware.vsphere.client.cm.util.DataRetrieverResult;
import com.vmware.vsphere.client.cm.util.InternalServerInfo;
import com.vmware.vsphere.client.cm.util.PropertyCache;
import com.vmware.vsphere.client.cm.util.ServerPropertyValueExtractor;
import java.net.URI;

@type(value="Issue")
public class ServerIssueAdapter
implements DataProviderAdapter {
    private static final String ISSUE_INFO_PROPERTY = "info";
    private static final String ISSUE_ENTITY_PROPERTY = "info.entity";
    private static final String ISSUE_TYPE = "Issue";
    private final DataRetriever _dataRetriever;
    private final PropertyCache<String> _unreachableServerCache;

    public ServerIssueAdapter(DataRetriever dataRetriever, PropertyCache<String> propertyCache) {
        this._dataRetriever = dataRetriever;
        this._unreachableServerCache = propertyCache;
    }

    public Response getData(RequestSpec requestSpec) throws Exception {
        Response response = new Response();
        QuerySpec[] querySpecArray = requestSpec.querySpec;
        response.resultSet = new ResultSet[querySpecArray.length];
        for (int i = 0; i < querySpecArray.length; ++i) {
            response.resultSet[i] = ServerIssueAdapter.querySpecRelevant(querySpecArray[i], this._dataRetriever.getObjectReferenceService()) ? this.getResultSet(querySpecArray[i]) : null;
        }
        return response;
    }

    private ResultSet getResultSet(QuerySpec querySpec) {
        Constraint constraint = querySpec.resourceSpec.constraint;
        assert (constraint instanceof PropertyConstraint);
        PropertyConstraint propertyConstraint = (PropertyConstraint)constraint;
        URI uRI = (URI)propertyConstraint.comparableValue;
        IssueInfo issueInfo = this.getIssueForServer(uRI);
        if (issueInfo == null) {
            return null;
        }
        ResultSet resultSet = new ResultSet();
        resultSet.queryName = querySpec.name;
        resultSet.items = new ResultItem[1];
        ResultItem resultItem = new ResultItem();
        resultItem.resourceObject = uRI;
        resultItem.properties = new PropertyValue[1];
        resultItem.properties[0] = new PropertyValue();
        resultItem.properties[0].resourceObject = uRI;
        resultItem.properties[0].propertyName = ISSUE_INFO_PROPERTY;
        resultItem.properties[0].value = issueInfo;
        resultSet.items[0] = resultItem;
        return resultSet;
    }

    private IssueInfo getIssueForServer(URI uRI) {
        IssueInfo issueInfo = this.getServerUnreachableIssue(uRI);
        if (issueInfo != null) {
            return issueInfo;
        }
        issueInfo = this.getApplmgmtDownIssue(uRI);
        return issueInfo;
    }

    private IssueInfo getServerUnreachableIssue(URI uRI) {
        assert (CmReferenceUtil.isReferenceOfType(uRI, "cm:Server", this._dataRetriever.getObjectReferenceService()));
        IssueInfo issueInfo = null;
        String string = CmReferenceUtil.getServerId(uRI);
        if (this._unreachableServerCache.getProperty(string, "__singleton") != null) {
            Object[][] objectArray = this.getServerProperties(new String[]{"name"}, uRI);
            String string2 = (String)objectArray[0][0];
            issueInfo = new IssueInfo();
            issueInfo.entity = uRI;
            issueInfo.entityName = string2;
            issueInfo.description = CmUtil.getLocalizedString("issue.serverUnreachable", string2);
            issueInfo.typeDisplayName = CmUtil.getLocalizedString("issue.connectionIssueType", new String[0]);
            issueInfo.status = IssueStatus.ERROR;
        }
        return issueInfo;
    }

    private IssueInfo getApplmgmtDownIssue(URI uRI) {
        Object[][] objectArray = this.getServerProperties(new String[]{"name", "applmgmtExistsAndDown"}, uRI);
        String string = (String)objectArray[0][0];
        boolean bl = (Boolean)objectArray[1][0];
        if (!bl) {
            return null;
        }
        IssueInfo issueInfo = new IssueInfo();
        issueInfo.entity = uRI;
        issueInfo.entityName = string;
        issueInfo.description = CmUtil.getLocalizedString("issue.applmgmtNotRunning", string);
        issueInfo.typeDisplayName = CmUtil.getLocalizedString("issue.applmgmtIssueType", new String[0]);
        issueInfo.status = IssueStatus.ERROR;
        return issueInfo;
    }

    private Object[][] getServerProperties(String[] stringArray, URI uRI) {
        ObjectIdentityConstraint objectIdentityConstraint = QueryUtil.createObjectIdentityConstraint((Object)uRI);
        DataRetrieverResult<InternalServerInfo> dataRetrieverResult = this._dataRetriever.retrieveServers((Constraint)objectIdentityConstraint);
        ServerPropertyValueExtractor serverPropertyValueExtractor = this._dataRetriever.getServerValueExtractor();
        return serverPropertyValueExtractor.getValues(dataRetrieverResult.getResult(), stringArray);
    }

    private static boolean querySpecRelevant(QuerySpec querySpec, ObjectReferenceService objectReferenceService) {
        Constraint constraint = querySpec.resourceSpec.constraint;
        if (!(constraint instanceof PropertyConstraint)) {
            return false;
        }
        PropertyConstraint propertyConstraint = (PropertyConstraint)constraint;
        boolean bl = ISSUE_TYPE.equals(constraint.targetType) && propertyConstraint.comparator == Comparator.EQUALS && ISSUE_ENTITY_PROPERTY.equals(propertyConstraint.propertyName) && CmReferenceUtil.isReferenceOfType(propertyConstraint.comparableValue, "cm:Server", objectReferenceService);
        PropertySpec[] propertySpecArray = querySpec.resourceSpec.propertySpecs;
        boolean bl2 = propertySpecArray.length == 1 && propertySpecArray[0].propertyNames.length == 1 && propertySpecArray[0].propertyNames[0].equals(ISSUE_INFO_PROPERTY);
        return bl && bl2;
    }
}

