/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.impl;

import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.type;
import com.vmware.vsphere.client.cm.impl.CmDataProviderAdapterBase;
import com.vmware.vsphere.client.cm.util.CmAuthorizationService;
import com.vmware.vsphere.client.cm.util.CmReferenceUtil;
import com.vmware.vsphere.client.cm.util.DataRetriever;
import com.vmware.vsphere.client.cm.util.DataRetrieverResult;
import com.vmware.vsphere.client.cm.util.InternalServerInfo;
import com.vmware.vsphere.client.cm.util.ServerComparator;
import java.net.URI;

@type(value="cm:Server")
public class ServersDataProviderAdapter
extends CmDataProviderAdapterBase<InternalServerInfo> {
    private final DataRetriever _retriever;

    public ServersDataProviderAdapter(DataRetriever dataRetriever, CmAuthorizationService cmAuthorizationService) {
        super(cmAuthorizationService);
        this._retriever = dataRetriever;
    }

    @Override
    protected ResultSet processQueryInternal(Constraint constraint, QuerySpec querySpec) {
        InternalServerInfo[] internalServerInfoArray;
        DataRetrieverResult<InternalServerInfo> dataRetrieverResult = this._retriever.retrieveServers(constraint);
        ResultSpec resultSpec = querySpec.resultSpec;
        if (resultSpec != null && (resultSpec.maxResultCount == null || resultSpec.maxResultCount > 0) && resultSpec.order != null && (internalServerInfoArray = dataRetrieverResult.getResult()).length > 1) {
            dataRetrieverResult.sort(new ServerComparator(resultSpec.order, this._retriever.getServerValueExtractor()));
        }
        internalServerInfoArray = this.createResultSet(querySpec, dataRetrieverResult);
        return internalServerInfoArray;
    }

    protected Object[][] getPropertyValues(InternalServerInfo[] internalServerInfoArray, String[] stringArray) {
        return this._retriever.getServerValues(internalServerInfoArray, stringArray);
    }

    @Override
    protected URI getUri(InternalServerInfo internalServerInfo) {
        return CmReferenceUtil.getServerReference(internalServerInfo);
    }
}

