/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.impl;

import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.type;
import com.vmware.vsphere.client.cm.impl.CmDataProviderAdapterBase;
import com.vmware.vsphere.client.cm.util.CmAuthorizationService;
import com.vmware.vsphere.client.cm.util.CmReferenceUtil;
import com.vmware.vsphere.client.cm.util.DataRetriever;
import com.vmware.vsphere.client.cm.util.DataRetrieverResult;
import com.vmware.vsphere.client.cm.util.InternalServiceInfo;
import com.vmware.vsphere.client.cm.util.ServiceInfoComparator;
import java.net.URI;

@type(value="cm:Service")
public class ServicesDataProviderAdapter
extends CmDataProviderAdapterBase<InternalServiceInfo> {
    private final DataRetriever _retriever;

    public ServicesDataProviderAdapter(DataRetriever dataRetriever, CmAuthorizationService cmAuthorizationService) {
        super(cmAuthorizationService);
        this._retriever = dataRetriever;
    }

    @Override
    protected ResultSet processQueryInternal(Constraint constraint, QuerySpec querySpec) {
        DataRetrieverResult<InternalServiceInfo> dataRetrieverResult = this._retriever.retrieveServices(constraint);
        ResultSpec resultSpec = querySpec.resultSpec;
        if (resultSpec != null && (resultSpec.maxResultCount == null || resultSpec.maxResultCount > 0) && resultSpec.order != null) {
            dataRetrieverResult.sort(new ServiceInfoComparator(resultSpec.order, this._retriever.getServiceValueExtractor(), dataRetrieverResult.getResult()));
        }
        ResultSet resultSet = this.createResultSet(querySpec, dataRetrieverResult);
        return resultSet;
    }

    protected Object[][] getPropertyValues(InternalServiceInfo[] internalServiceInfoArray, String[] stringArray) {
        return this._retriever.getServiceValues(internalServiceInfoArray, stringArray);
    }

    @Override
    protected URI getUri(InternalServiceInfo internalServiceInfo) {
        return CmReferenceUtil.getServiceReference(internalServiceInfo);
    }
}

